/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.animation.Animator;
import android.content.Intent;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IamActivity;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.preview.ChatSnippet;
import io.intercom.android.sdk.preview.DefaultLauncher;
import io.intercom.android.sdk.preview.NotificationSnippet;
import io.intercom.android.sdk.preview.PreviewCallbacks;
import io.intercom.android.sdk.preview.PreviewInteractionManager;
import io.intercom.android.sdk.preview.Snippet;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringConfig;
import io.intercom.com.facebook.rebound.SpringListener;
import io.intercom.com.facebook.rebound.SpringSystem;
import io.intercom.com.facebook.rebound.SpringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class NotificationManager
implements PreviewCallbacks,
View.OnClickListener {
    public static final int MAX_DISPLAYED_NOTIFICATIONS = 3;
    private final PreviewInteractionManager interactionManager;
    private final LayoutInflater inflater;
    private final Map<String, Snippet> notifications = new HashMap<String, Snippet>();
    private final List<Conversation> lastDisplayedConversations = new ArrayList<Conversation>();
    private final Handler handler;
    private final MetricsStore metricsStore;
    private boolean hasAnimated = false;
    private boolean isStackForm = false;

    public NotificationManager(LayoutInflater inflater, Handler handler, PreviewInteractionManager interactionManager, MetricsStore metricsStore) {
        this.inflater = inflater;
        this.interactionManager = interactionManager;
        this.handler = handler;
        this.metricsStore = metricsStore;
    }

    public void displayNotificationPreview(final ViewGroup root, final List<Conversation> conversations) {
        final boolean hasChanged = !this.lastDisplayedConversations.equals(conversations) && !this.notifications.isEmpty();
        final HashMap<String, Snippet> tempNotifications = new HashMap<String, Snippet>(this.notifications);
        if (conversations.size() > 1) {
            this.isStackForm = true;
        }
        ViewUtils.waitForViewAttachment((View)root, new Runnable(){

            @Override
            public void run() {
                NotificationManager.this.displayPreviews(conversations, tempNotifications, root, hasChanged);
            }
        });
    }

    public void displayNotificationPreview(final ViewGroup root, final List<Conversation> conversations, final DefaultLauncher defaultLauncher) {
        if (conversations.size() == 1) {
            defaultLauncher.pulseForTransformation(new SimpleAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    defaultLauncher.fadeOffScreen(new SimpleAnimatorListener(){

                        @Override
                        public void onAnimationEnd(Animator animation) {
                            defaultLauncher.removeView();
                        }
                    });
                    NotificationManager.this.displayNotificationPreview(root, conversations);
                }
            });
        } else {
            defaultLauncher.fadeOffScreen(new SimpleAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    defaultLauncher.removeView();
                    NotificationManager.this.displayNotificationPreview(root, conversations);
                }
            });
        }
    }

    public boolean isDisplaying() {
        return !this.notifications.isEmpty();
    }

    public void reset() {
        this.notifications.clear();
    }

    @Override
    public void onSnippetTap(Conversation conversation) {
        this.interactionManager.openNotification(conversation);
        Part lastPart = conversation.getLastAdminPart();
        MetricObject metricObject = "chat".equals(lastPart.getMessageStyle()) && Part.DeliveryOption.FULL == lastPart.getDeliveryOption() ? MetricFactory.tappedOnFullInApp(conversation.getId(), lastPart.getMessageStyle()) : MetricFactory.tappedOnSnippet(conversation.getId(), lastPart.getMessageStyle());
        this.metricsStore.track(metricObject);
    }

    @Override
    public void onSnippetDismiss(Snippet notificationSnippet) {
        Part lastPart;
        ViewGroup rootView = null;
        try {
            rootView = this.interactionManager.getRootView();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Conversation conversation = notificationSnippet.getConversation();
        if (rootView != null) {
            this.interactionManager.markAsDismissed(conversation);
            rootView.removeView(notificationSnippet.getRootView());
            this.notifications.remove(conversation.getId());
            this.lastDisplayedConversations.remove(conversation);
            for (Snippet snippet : this.notifications.values()) {
                snippet.moveForward(rootView, this.inflater);
            }
            this.displayPill(this.inflater, rootView);
            if (this.notifications.isEmpty()) {
                this.hasAnimated = false;
                this.isStackForm = false;
            }
        }
        MetricObject metricObject = "chat".equals((lastPart = conversation.getLastAdminPart()).getMessageStyle()) && Part.DeliveryOption.FULL == lastPart.getDeliveryOption() ? MetricFactory.dismissedFullInApp(conversation.getId(), lastPart.getMessageStyle()) : MetricFactory.dismissedSnippet(conversation.getId(), lastPart.getMessageStyle());
        this.metricsStore.track(metricObject);
    }

    public void onClick(View view) {
        Intent iamInboxIntent = IamActivity.openInbox(view.getContext());
        view.getContext().startActivity(iamInboxIntent);
    }

    private void displayPreviews(List<Conversation> conversations, Map<String, Snippet> temp, ViewGroup root, boolean hasDifferentConversations) {
        if (hasDifferentConversations) {
            this.updateNotifications(conversations, temp, root);
        } else if (!this.isDisplaying()) {
            this.addNewNotifications(conversations, root);
        }
        this.hasAnimated = true;
        this.displayPill(this.inflater, root);
        this.lastDisplayedConversations.clear();
        this.lastDisplayedConversations.addAll(conversations);
    }

    private void addNewNotifications(List<Conversation> conversations, ViewGroup root) {
        int count = conversations.size();
        for (int i = 0; i < count; ++i) {
            Conversation conversation = conversations.get(i);
            Snippet snippet = !this.isStackForm && "chat".equals(conversation.getLastPart().getMessageStyle()) ? new ChatSnippet(root.getContext(), conversation, i, SpringSystem.create(), root.getHeight(), this) : new NotificationSnippet(root.getContext(), conversation, i, SpringSystem.create(), this.handler, root.getHeight(), this);
            this.notifications.put(conversation.getId(), snippet);
            if (i >= 3) continue;
            snippet.display(root, this.inflater, !this.hasAnimated);
        }
    }

    private void updateNotifications(final List<Conversation> conversations, final Map<String, Snippet> temp, final ViewGroup root) {
        final Conversation conversation = conversations.get(0);
        Iterator<Snippet> iterator = temp.values().iterator();
        Snippet firstSnippet = iterator.next();
        while (iterator.hasNext()) {
            Snippet p = iterator.next();
            if (p.getPosition() >= firstSnippet.getPosition()) continue;
            firstSnippet = p;
        }
        if (this.isReply(conversation)) {
            firstSnippet.update(conversation, new Runnable(){

                @Override
                public void run() {
                    NotificationManager.this.syncUpdates(conversations, temp, root);
                }
            });
        } else if (temp.size() == 1 && firstSnippet instanceof ChatSnippet) {
            firstSnippet.moveBackward(root, new SimpleAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    NotificationManager.this.addNewView(conversation, root, temp);
                    NotificationManager.this.handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            NotificationManager.this.syncUpdates(conversations, temp, root);
                        }
                    }, 220L);
                }
            });
        } else {
            for (Snippet snippet : temp.values()) {
                if (snippet.getPosition() < 3) {
                    snippet.moveBackward(root);
                    continue;
                }
                snippet.setPosition(snippet.getPosition() + 1);
            }
            this.addNewView(conversation, root, temp);
            this.syncUpdates(conversations, temp, root);
        }
    }

    private void addNewView(Conversation conversation, ViewGroup root, Map<String, Snippet> temp) {
        NotificationSnippet notification = new NotificationSnippet(root.getContext(), conversation, 0, SpringSystem.create(), this.handler, root.getHeight(), this);
        ((Snippet)notification).display(root, this.inflater, true);
        if (temp.containsKey(conversation.getId())) {
            temp.get(conversation.getId()).removeView();
        }
        temp.put(conversation.getId(), notification);
    }

    private void syncUpdates(List<Conversation> conversations, Map<String, Snippet> temp, ViewGroup root) {
        for (int i = 0; i < conversations.size(); ++i) {
            Conversation tempConversation = conversations.get(i);
            Snippet snippet = temp.remove(tempConversation.getId());
            if (snippet instanceof ChatSnippet && i > 0 || snippet == null) {
                if (snippet != null) {
                    snippet.removeView();
                }
                snippet = new NotificationSnippet(root.getContext(), tempConversation, i, SpringSystem.create(), this.handler, root.getHeight(), this);
            }
            if (i < 3) {
                snippet.display(root, tempConversation, this.inflater, false);
            } else {
                snippet.removeView();
            }
            this.notifications.put(tempConversation.getId(), snippet);
        }
        for (Snippet snippet : temp.values()) {
            snippet.removeView();
        }
    }

    private void displayPill(LayoutInflater inflater, ViewGroup root) {
        TextView pill = (TextView)root.findViewById(R.id.preview_pill);
        if (this.notifications.size() <= 3) {
            if (pill != null) {
                root.removeView((View)pill);
            }
        } else {
            if (pill == null) {
                inflater.inflate(R.layout.intercom_notification_pill, root, true);
                pill = (TextView)root.findViewById(R.id.preview_pill);
                pill.setAlpha(0.0f);
                pill.setScaleX(0.4f);
                pill.setScaleY(0.4f);
                pill.setOnClickListener((View.OnClickListener)this);
                this.animatePill((View)pill);
            }
            String text = pill.getResources().getString(R.string.intercom_pill_display_text, new Object[]{this.notifications.size() - 3});
            pill.setText((CharSequence)text);
        }
    }

    private void animatePill(final View view) {
        SpringConfig springConfig = new SpringConfig(400.0, 24.0);
        final Spring spring = SpringSystem.create().createSpring();
        spring.setSpringConfig(springConfig);
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                final float initialY = view.getY();
                spring.setCurrentValue((double)(view.getY() + 200.0f));
                spring.setEndValue((double)view.getY());
                spring.addListener((SpringListener)new SimpleSpringListener(){

                    public void onSpringUpdate(Spring spring) {
                        super.onSpringUpdate(spring);
                        view.setY((float)spring.getCurrentValue());
                        view.setAlpha((float)SpringUtil.mapValueFromRangeToRange((double)spring.getCurrentValue(), (double)(initialY + 200.0f), (double)initialY, (double)0.0, (double)1.0));
                        double v = SpringUtil.mapValueFromRangeToRange((double)spring.getCurrentValue(), (double)(initialY + 200.0f), (double)initialY, (double)0.4, (double)1.0);
                        view.setScaleX((float)v);
                        view.setScaleY((float)v);
                    }
                });
            }
        }, 500L);
    }

    public boolean isReply(Conversation conversation) {
        return !this.lastDisplayedConversations.isEmpty() && conversation.getId().equals(this.lastDisplayedConversations.get(0).getId());
    }
}

