/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import io.intercom.android.sdk.models.Conversation;
import java.util.ArrayList;
import java.util.List;

public class ConversationList
implements Parcelable {
    private final List<Conversation> conversations = new ArrayList<Conversation>();
    private final List<String> unreadConversationIds;
    private final boolean morePagesAvailable;
    public static final Parcelable.Creator<ConversationList> CREATOR = new Parcelable.Creator<ConversationList>(){

        public ConversationList createFromParcel(Parcel in) {
            return new ConversationList(in);
        }

        public ConversationList[] newArray(int size) {
            return new ConversationList[size];
        }
    };

    public ConversationList() {
        this(new Builder());
    }

    private ConversationList(Builder builder) {
        if (builder.conversations != null) {
            for (Conversation.Builder conversationBuilder : builder.conversations) {
                this.conversations.add(conversationBuilder.build());
            }
        }
        this.unreadConversationIds = new ArrayList<String>();
        if (builder.unread_conversation_ids != null) {
            for (String id2 : builder.unread_conversation_ids) {
                if (id2 == null) continue;
                this.unreadConversationIds.add(id2);
            }
        }
        this.morePagesAvailable = builder.more_pages_available;
    }

    public List<Conversation> getConversations() {
        return this.conversations;
    }

    public List<String> getUnreadConversationIds() {
        return this.unreadConversationIds;
    }

    public int getTotalUnreadCount() {
        return this.unreadConversationIds.size();
    }

    public boolean hasMorePages() {
        return this.morePagesAvailable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationList that = (ConversationList)o;
        if (this.morePagesAvailable != that.morePagesAvailable) {
            return false;
        }
        if (!this.conversations.equals(that.conversations)) {
            return false;
        }
        return this.unreadConversationIds.equals(that.unreadConversationIds);
    }

    public int hashCode() {
        int result = this.conversations.hashCode();
        result = 31 * result + this.unreadConversationIds.hashCode();
        result = 31 * result + (this.morePagesAvailable ? 1 : 0);
        return result;
    }

    protected ConversationList(Parcel in) {
        if (in.readByte() == 1) {
            in.readList(this.conversations, Conversation.class.getClassLoader());
        }
        this.morePagesAvailable = in.readByte() != 0;
        this.unreadConversationIds = new ArrayList<String>();
        if (in.readByte() == 1) {
            in.readList(this.unreadConversationIds, Conversation.class.getClassLoader());
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.conversations == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.conversations);
        }
        dest.writeByte((byte)(this.morePagesAvailable ? 1 : 0));
        if (this.unreadConversationIds == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.unreadConversationIds);
        }
    }

    public static final class Builder {
        private List<Conversation.Builder> conversations;
        private List<String> unread_conversation_ids;
        private boolean more_pages_available;

        public ConversationList build() {
            return new ConversationList(this);
        }
    }
}

