/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.text.Spanned;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.SubheadngBlock;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;

public class Subheading
implements SubheadngBlock {
    private final LayoutInflater inflater;
    private final StyleType style;

    public Subheading(LayoutInflater inflater, StyleType style) {
        this.style = style;
        this.inflater = inflater;
    }

    public View addSubheading(Spanned text, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview;
        int color2 = Injector.get().getIdentityStore().getAppConfig().getBaseColor();
        switch (this.style) {
            case ADMIN: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_admin_subheading, parent, false);
                textview.setTextColor(color2);
                textview.setLinkTextColor(color2);
                break;
            }
            case NOTE: 
            case CONTAINER_CARD: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_post_subheading, parent, false);
                textview.setTextColor(color2);
                textview.setLinkTextColor(color2);
                break;
            }
            case POST: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_post_subheading, parent, false);
                color2 = ColorUtils.lightenColor(color2);
                textview.setTextColor(color2);
                textview.setLinkTextColor(color2);
                break;
            }
            default: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_user_subheading, parent, false);
            }
        }
        textview.setClickable(true);
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        textview.setText((CharSequence)text);
        textview.setGravity(alignment.getGravity());
        BlockUtils.setLayoutMarginsAndGravity((View)textview, alignment.getGravity(), isLastObject);
        return textview;
    }
}

