/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.SocialAccount;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.utilities.IntentUtils;
import io.intercom.android.sdk.views.behavior.ToolbarTeamMateProfileBehavior;
import io.intercom.android.sdk.views.behavior.ToolbarTeamProfileBehavior;
import io.intercom.com.bumptech.glide.Glide;
import java.util.Arrays;
import java.util.List;

public class ProfileCoordinator {
    private final AppBarLayout appBarLayout;
    private final TextView toolbarTitle;
    private final TextView toolbarSubtitle;
    private final TextView toolbarRole;
    private final TextView toolbarLocation;
    private final TextView toolbarBio;
    private final ImageView toolbarAvatar;
    private final ImageView toolbarBackground;
    private final ImageButton twitterButton;
    private final ImageButton linkedInButton;
    private final TextView collapsedTeamToolbarTitle;
    private final TextView collapsedTeamToolbarSubtitle;
    private final List<ImageView> teamPresenceAvatars;
    private final List<TextView> teamPresenceNames;
    private final TextView teamBio;
    private final CoordinatorLayout coordinatorLayout;
    private final ViewGroup titleLayoutCoordinator;
    private final ViewGroup teamMateProfileLayout;
    private final ViewGroup teamProfileLayout;
    private final LinearLayout socialLayout;
    private final ToolbarTeamProfileBehavior teamProfileBehavior;
    private AppBarLayout.OnOffsetChangedListener offsetListener = null;
    private State currentState = State.IDLE;

    public ProfileCoordinator(CoordinatorLayout rootView) {
        int baseColor = Injector.get().getIdentityStore().getAppConfig().getBaseColor();
        this.coordinatorLayout = (CoordinatorLayout)rootView.findViewById(R.id.conversation_coordinator_layout);
        this.appBarLayout = (AppBarLayout)rootView.findViewById(R.id.app_bar_layout);
        this.teamMateProfileLayout = (ViewGroup)rootView.findViewById(R.id.intercom_teammate_profile_container_view);
        this.teamMateProfileLayout.setBackgroundColor(baseColor);
        this.titleLayoutCoordinator = (FrameLayout)rootView.findViewById(R.id.profile_toolbar_coordinator);
        this.toolbarTitle = (TextView)this.teamMateProfileLayout.findViewById(R.id.intercom_collapsing_title);
        this.toolbarSubtitle = (TextView)this.teamMateProfileLayout.findViewById(R.id.intercom_collapsing_subtitle);
        this.toolbarRole = (TextView)this.teamMateProfileLayout.findViewById(R.id.intercom_collapsing_role);
        this.toolbarLocation = (TextView)this.teamMateProfileLayout.findViewById(R.id.intercom_collapsing_location);
        this.toolbarBio = (TextView)this.teamMateProfileLayout.findViewById(R.id.intercom_collapsing_bio);
        this.toolbarAvatar = (ImageView)this.teamMateProfileLayout.findViewById(R.id.intercom_collapsing_teammate_avatar);
        this.twitterButton = (ImageButton)this.teamMateProfileLayout.findViewById(R.id.twitter_button);
        this.linkedInButton = (ImageButton)this.teamMateProfileLayout.findViewById(R.id.linkedin_button);
        this.toolbarBackground = (ImageView)rootView.findViewById(R.id.collapsing_background_image);
        this.socialLayout = (LinearLayout)rootView.findViewById(R.id.social_button_layout);
        this.teamProfileLayout = (ViewGroup)rootView.findViewById(R.id.intercom_team_profile);
        this.teamProfileLayout.setBackgroundColor(baseColor);
        this.teamProfileLayout.setAlpha(0.0f);
        this.collapsedTeamToolbarTitle = (TextView)this.teamProfileLayout.findViewById(R.id.intercom_collapsing_title);
        this.collapsedTeamToolbarSubtitle = (TextView)this.teamProfileLayout.findViewById(R.id.intercom_collapsing_subtitle);
        this.teamPresenceAvatars = Arrays.asList((ImageView)this.teamProfileLayout.findViewById(R.id.intercom_collapsing_team_avatar1), (ImageView)this.teamProfileLayout.findViewById(R.id.intercom_collapsing_team_avatar2), (ImageView)this.teamProfileLayout.findViewById(R.id.intercom_collapsing_team_avatar3));
        this.teamPresenceNames = Arrays.asList((TextView)this.teamProfileLayout.findViewById(R.id.intercom_collapsing_team_name_1), (TextView)this.teamProfileLayout.findViewById(R.id.intercom_collapsing_team_name_2), (TextView)this.teamProfileLayout.findViewById(R.id.intercom_collapsing_team_name_3));
        this.teamBio = (TextView)this.teamProfileLayout.findViewById(R.id.intercom_collapsing_team_bio);
        this.teamProfileBehavior = new ToolbarTeamProfileBehavior(rootView.getContext(), this.teamProfileLayout);
    }

    public static int getTextHeight(TextView textView, String text, int textSize, int parentWidth) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            textView.setVisibility(8);
            return 0;
        }
        textView.setVisibility(0);
        textView.setText((CharSequence)text);
        textView.setTextSize(2, (float)textSize);
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)parentWidth, (int)Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        textView.measure(widthMeasureSpec, heightMeasureSpec);
        return textView.getMeasuredHeight();
    }

    public void setTeamPresence(@NonNull TeamPresence teamPresence) {
        this.teamMateProfileLayout.setAlpha(0.0f);
        this.teamProfileLayout.setAlpha(1.0f);
        List<Participant> admins = teamPresence.getActiveAdmins();
        this.setTeamCollapsingSubtitle(teamPresence.getExpectedResponseDelay());
        if (!admins.isEmpty()) {
            for (int i = 0; i < this.teamPresenceAvatars.size(); ++i) {
                ImageView avatarView = this.teamPresenceAvatars.get(i);
                TextView nameTextView = this.teamPresenceNames.get(i);
                if (i < admins.size()) {
                    Participant admin = admins.get(i);
                    this.setAvatar(admin.getAvatar(), avatarView);
                    nameTextView.setText((CharSequence)admin.getForename());
                    avatarView.setVisibility(0);
                    nameTextView.setVisibility(0);
                    continue;
                }
                avatarView.setVisibility(8);
                nameTextView.setVisibility(8);
            }
        }
        if (this.teamProfileLayout.getHeight() == 0) {
            this.teamProfileLayout.measure(0, 0);
            int height = this.teamProfileLayout.getMeasuredHeight();
            int bioHeight = ProfileCoordinator.getTextHeight(this.teamBio, Injector.get().getIdentityStore().getAppConfig().getTeamProfileBio(), 14, this.teamProfileLayout.getMeasuredWidth());
            this.titleLayoutCoordinator.getLayoutParams().height = height += bioHeight;
            this.toolbarBackground.getLayoutParams().height = height;
            Context context = this.titleLayoutCoordinator.getContext();
            this.applyOffsetChangedListener(new ToolbarTeamProfileBehavior(context, this.teamProfileLayout));
        }
    }

    public void setTeamCollapsingSubtitle(@Nullable String subtitle) {
        this.setSubtitle(this.collapsedTeamToolbarSubtitle, subtitle);
    }

    public void setTeamMatePresence(LastParticipatingAdmin lastParticipant, String lastActiveTime, Context context) {
        boolean changingFromTeamProfile = false;
        this.appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this.teamProfileBehavior);
        if (this.teamMateProfileLayout.getAlpha() < 1.0f) {
            changingFromTeamProfile = true;
            ObjectAnimator.ofFloat((Object)this.teamMateProfileLayout, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}).setDuration(150L).start();
            ObjectAnimator.ofFloat((Object)this.teamProfileLayout, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(150L).start();
        }
        this.setCollapsingTitle(String.format(context.getString(R.string.intercom_teammate_from_company), lastParticipant.getFirstName(), Injector.get().getIdentityStore().getAppConfig().getName()));
        this.setCollapsingAvatar(lastParticipant.getAvatar());
        this.setRoleText(lastParticipant.getJobTitle());
        this.setLocationText(lastParticipant.getLocation(context.getResources()));
        this.setCollapsingSubtitle(lastActiveTime);
        this.setSocialAccounts(lastParticipant.getTwitter(), lastParticipant.getLinkedIn(), context);
        if (this.teamMateProfileLayout.getHeight() == 0 || changingFromTeamProfile) {
            this.teamMateProfileLayout.measure(0, 0);
            int height = this.teamMateProfileLayout.getMeasuredHeight();
            int bioHeight = ProfileCoordinator.getTextHeight(this.toolbarBio, lastParticipant.getIntro(), 14, this.teamMateProfileLayout.getMeasuredWidth());
            this.titleLayoutCoordinator.getLayoutParams().height = height += bioHeight;
            this.toolbarBackground.getLayoutParams().height = height;
            this.applyOffsetChangedListener(new ToolbarTeamMateProfileBehavior(context, this.teamMateProfileLayout));
        }
    }

    private void applyOffsetChangedListener(final AppBarLayout.OnOffsetChangedListener behavior) {
        this.appBarLayout.addOnOffsetChangedListener(behavior);
        this.appBarLayout.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                ProfileCoordinator.this.appBarLayout.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                behavior.onOffsetChanged(ProfileCoordinator.this.appBarLayout, 0);
                return false;
            }
        });
    }

    public void startOffsetListener() {
        if (this.offsetListener == null) {
            this.offsetListener = new AppBarLayout.OnOffsetChangedListener(){

                public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                    if (verticalOffset == 0) {
                        ProfileCoordinator.this.currentState = State.EXPANDED;
                    } else if (Math.abs(verticalOffset) >= appBarLayout.getTotalScrollRange()) {
                        ProfileCoordinator.this.currentState = State.COLLAPSED;
                    } else {
                        ProfileCoordinator.this.currentState = State.IDLE;
                    }
                }
            };
            this.appBarLayout.addOnOffsetChangedListener(this.offsetListener);
        }
    }

    public boolean isExpanded() {
        return this.currentState == State.EXPANDED;
    }

    public void trackOpenMetric(String conversationId) {
        String profileType = this.teamProfileLayout.getAlpha() == 0.0f ? "TeamMateProfile" : "TeamProfile";
        Injector.get().getMetricsStore().track(MetricFactory.profileExpanded(conversationId, profileType));
    }

    private void setCollapsingAvatar(Avatar avatar) {
        this.setAvatar(avatar, this.toolbarAvatar);
        this.setToolbarBackground(avatar);
    }

    private void setRoleText(String role) {
        this.toolbarRole.setText((CharSequence)role);
        if (TextUtils.isEmpty((CharSequence)role)) {
            this.toolbarRole.setVisibility(8);
        }
    }

    private void setLocationText(String location) {
        this.toolbarLocation.setText((CharSequence)location);
    }

    private void setCollapsingTitle(@Nullable String title) {
        this.toolbarTitle.setText((CharSequence)title);
    }

    public void setTeamCollapsingTitle(@Nullable String title) {
        this.collapsedTeamToolbarTitle.setText((CharSequence)title);
    }

    public void setCollapsingSubtitle(@Nullable String subtitle) {
        this.setSubtitle(this.toolbarSubtitle, subtitle);
    }

    private void setSocialAccounts(final SocialAccount twitter, final SocialAccount linkedIn, final Context context) {
        if (twitter instanceof SocialAccount.NullSocialAccount) {
            this.twitterButton.setVisibility(8);
        } else {
            this.twitterButton.setVisibility(0);
            this.twitterButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)twitter.getProfileUrl()));
                    IntentUtils.safelyOpenIntent(context, intent);
                }
            });
        }
        if (linkedIn instanceof SocialAccount.NullSocialAccount) {
            this.linkedInButton.setVisibility(8);
        } else {
            this.linkedInButton.setVisibility(0);
            this.linkedInButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)linkedIn.getProfileUrl()));
                    IntentUtils.safelyOpenIntent(context, intent);
                }
            });
        }
        if (this.linkedInButton.getVisibility() == 8 && this.twitterButton.getVisibility() == 8) {
            this.socialLayout.setVisibility(8);
        }
    }

    private void setAvatar(Avatar avatar, ImageView imageView) {
        imageView.setVisibility(0);
        AvatarUtils.createAvatar(avatar, imageView, imageView.getContext());
    }

    private void setSubtitle(TextView subtitle, @Nullable String subtitleText) {
        subtitle.setText((CharSequence)subtitleText);
    }

    private void setToolbarBackground(Avatar avatar) {
        String imageUrl = avatar.getImageUrl();
        if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
            Glide.with((Context)this.toolbarBackground.getContext()).load(imageUrl).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(imageUrl)).into(this.toolbarBackground);
        }
    }

    public void flingCoordinator(int yVelocity) {
        CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)this.appBarLayout.getLayoutParams();
        AppBarLayout.Behavior behavior = (AppBarLayout.Behavior)params.getBehavior();
        if (behavior != null) {
            behavior.onNestedFling(this.coordinatorLayout, this.appBarLayout, null, 0.0f, (float)yVelocity, false);
        }
    }

    public AppBarLayout getAppBarLayout() {
        return this.appBarLayout;
    }

    private static enum State {
        COLLAPSED,
        EXPANDED,
        IDLE;

    }
}

