/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.content.Context;
import android.media.SoundPool;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.preview.PreviewInteractionManager;
import io.intercom.android.sdk.utilities.ViewUtils;

public abstract class BaseManager {
    protected final PreviewInteractionManager interactionManager;
    protected final LayoutInflater inflater;

    public BaseManager(LayoutInflater inflater, PreviewInteractionManager interactionManager) {
        this.inflater = inflater;
        this.interactionManager = interactionManager;
    }

    protected final void waitForRootViewAttachment(final ViewGroup root, final Runnable runnable) {
        if (root.getHeight() == 0) {
            root.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    ViewUtils.removeGlobalLayoutListener((View)root, this);
                    runnable.run();
                }
            });
        } else {
            runnable.run();
        }
    }

    protected static void playNotificationSound(Context context) {
        SoundPool soundPool = new SoundPool(1, 5, 0);
        soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                soundPool.play(sampleId, 1.0f, 1.0f, 1, 0, 1.0f);
            }
        });
        soundPool.load(context, R.raw.intercomsdk_birdy_done_1, 1);
    }
}

