/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Config;
import io.intercom.android.sdk.models.events.FirstMessageEvent;
import io.intercom.android.sdk.nexus.NexusConfig;
import io.intercom.android.sdk.utilities.ColorUtils;

public class AppConfig {
    private static final String APP_NAME = "app_name";
    private static final String APP_POWERED_BY = "app_powered_by";
    private static final String APP_FIRST_REQUEST = "app_is_first_request";
    private static final String APP_INBOUND_MESSAGES = "app_inbound_messages";
    private static final String APP_TEAM_BIO = "app_team_bio";
    private static final String APP_PRIMARY_COLOR = "app_primary_color";
    private static final String APP_PRIMARY_DARK_COLOR = "app_primary_dark_color";
    private static final String APP_USER_UPDATE_CACHE_MAX_AGE = "app_user_update_cache_max_age";
    private static final String APP_RATE_LIMIT_PERIOD = "app_rate_limit_period";
    private static final String APP_RATE_LIMIT_COUNT = "app_rate_limit_count";
    private static final String APP_MESSAGE_RESPONSE = "app_message_response";
    private static final String APP_AUDIO_ENABLED = "app_audio_enabled";
    private static final String APP_WALLPAPER = "app_wallpaper";
    private final SharedPreferences prefs;
    private NexusConfig realTimeConfig = new NexusConfig();
    private String teamProfileBio = "";
    private String wallpaper = "";
    private String name = "";
    private String messageResponse = "";
    private int baseColor;
    private int baseColorDark;
    private int userUpdateCacheMaxAge;
    private int rateLimitPeriod;
    private int rateLimitCount;
    private boolean isFirstRequest;
    private boolean inboundMessages;
    private boolean showPoweredBy;
    private boolean audioEnabled;

    public AppConfig(Context context) {
        this.prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        this.name = this.prefs.getString(APP_NAME, "");
        this.baseColor = this.prefs.getInt(APP_PRIMARY_COLOR, ContextCompat.getColor((Context)context, (int)R.color.intercom_main_blue));
        this.baseColorDark = this.prefs.getInt(APP_PRIMARY_DARK_COLOR, ColorUtils.darkenColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_main_blue)));
        this.showPoweredBy = this.prefs.getBoolean(APP_POWERED_BY, false);
        this.isFirstRequest = this.prefs.getBoolean(APP_FIRST_REQUEST, false);
        this.inboundMessages = this.prefs.getBoolean(APP_INBOUND_MESSAGES, false);
        this.userUpdateCacheMaxAge = this.prefs.getInt(APP_USER_UPDATE_CACHE_MAX_AGE, 0);
        this.rateLimitPeriod = this.prefs.getInt(APP_RATE_LIMIT_PERIOD, 60);
        this.rateLimitCount = this.prefs.getInt(APP_RATE_LIMIT_COUNT, Integer.MAX_VALUE);
        this.messageResponse = this.prefs.getString(APP_MESSAGE_RESPONSE, "");
        this.audioEnabled = this.prefs.getBoolean(APP_AUDIO_ENABLED, true);
        this.teamProfileBio = this.prefs.getString(APP_TEAM_BIO, "");
        this.wallpaper = this.prefs.getString(APP_WALLPAPER, "");
    }

    protected void update(Config config) {
        if (this.isNewConfig(config)) {
            boolean nexusConfigChanged = !config.getRealTimeConfig().equals((Object)this.realTimeConfig);
            this.name = config.getName();
            this.teamProfileBio = config.getWelcomeMessage();
            this.wallpaper = config.getMessengerBackground();
            this.baseColor = Color.parseColor((String)config.getBaseColor());
            this.baseColorDark = ColorUtils.darkenColor(this.baseColor);
            this.isFirstRequest = config.isFirstRequest();
            this.inboundMessages = config.isInboundMessages();
            this.showPoweredBy = config.isShowPoweredBy();
            this.audioEnabled = config.isAudioEnabled();
            this.userUpdateCacheMaxAge = config.getUserUpdateCacheMaxAge();
            this.rateLimitPeriod = config.getRateLimitPeriod();
            this.rateLimitCount = config.getRateLimitCount();
            this.messageResponse = config.getMessageResponse();
            this.realTimeConfig = config.getRealTimeConfig();
            this.prefs.edit().putString(APP_NAME, this.name).putString(APP_TEAM_BIO, this.teamProfileBio).putString(APP_MESSAGE_RESPONSE, this.messageResponse).putInt(APP_PRIMARY_COLOR, this.baseColor).putInt(APP_PRIMARY_DARK_COLOR, this.baseColorDark).putInt(APP_USER_UPDATE_CACHE_MAX_AGE, this.userUpdateCacheMaxAge).putInt(APP_RATE_LIMIT_COUNT, this.rateLimitCount).putInt(APP_RATE_LIMIT_PERIOD, this.rateLimitPeriod).putBoolean(APP_POWERED_BY, this.showPoweredBy).putBoolean(APP_FIRST_REQUEST, this.isFirstRequest).putBoolean(APP_INBOUND_MESSAGES, this.inboundMessages).putBoolean(APP_AUDIO_ENABLED, this.audioEnabled).apply();
            if (this.isFirstRequest) {
                Injector.get().getBus().post((Object)new FirstMessageEvent());
            }
            if (nexusConfigChanged) {
                Injector.get().getNexusClient().cycle(this.realTimeConfig, true);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getTeamProfileBio() {
        return this.teamProfileBio;
    }

    public String getWallpaper() {
        return this.wallpaper;
    }

    @ColorInt
    public int getBaseColor() {
        return this.baseColor;
    }

    @ColorInt
    public int getBaseColorDark() {
        return this.baseColorDark;
    }

    public boolean isShowPoweredBy() {
        return this.showPoweredBy;
    }

    public boolean isInboundMessages() {
        return this.inboundMessages;
    }

    public boolean isFirstRequest() {
        return this.isFirstRequest;
    }

    public int getUserUpdateCacheMaxAge() {
        return this.userUpdateCacheMaxAge;
    }

    public int getRateLimitPeriod() {
        return this.rateLimitPeriod;
    }

    public int getRateLimitCount() {
        return this.rateLimitCount;
    }

    public NexusConfig getRealTimeConfig() {
        return this.realTimeConfig;
    }

    public String getMessageResponse() {
        return this.messageResponse;
    }

    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    public void resetRealTimeConfig() {
        this.realTimeConfig = new NexusConfig();
    }

    private boolean isNewConfig(Config config) {
        return !config.getMessageResponse().equals(this.messageResponse) || !config.getWelcomeMessage().equals(this.teamProfileBio) || !config.getMessengerBackground().equals(this.wallpaper) || !config.getRealTimeConfig().equals((Object)this.realTimeConfig) || !config.getName().equals(this.name) || Color.parseColor((String)config.getBaseColor()) != this.baseColor || config.getUserUpdateCacheMaxAge() != this.userUpdateCacheMaxAge || config.isAudioEnabled() != this.audioEnabled || config.isShowPoweredBy() != this.showPoweredBy || config.isInboundMessages() != this.inboundMessages || config.isFirstRequest() != this.isFirstRequest || config.getRateLimitCount() != this.rateLimitCount || config.getRateLimitPeriod() != this.rateLimitPeriod;
    }
}

