/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.content.ClipboardManager;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomPostActivity;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.views.holder.ContainerCardViewHolder;
import io.intercom.android.sdk.views.holder.ConversationListener;
import io.intercom.android.sdk.views.holder.ConversationViewHolder;
import io.intercom.android.sdk.views.holder.LoadingConversationLoadingLayout;
import io.intercom.android.sdk.views.holder.PartViewHolder;
import io.intercom.android.sdk.views.holder.TimeStampViewHolder;
import java.util.List;

public class RecyclerConversationAdapter
extends RecyclerView.Adapter<ConversationViewHolder>
implements ConversationListener {
    private final Context context;
    private final List<Part> partList;
    private final ClipboardManager clipboardManager;
    private final PartClickedListener partClickedListener;
    private boolean allowExpansionArrow = false;
    @Nullable
    private Part selectedPart;

    public static RecyclerConversationAdapter create(Context context, List<Part> partList, PartClickedListener partClickedListener) {
        ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
        return new RecyclerConversationAdapter(context, partList, clipboardManager, partClickedListener);
    }

    RecyclerConversationAdapter(Context context, List<Part> partList, ClipboardManager clipboardManager, PartClickedListener partClickedListener) {
        this.context = context;
        this.partList = partList;
        this.clipboardManager = clipboardManager;
        this.partClickedListener = partClickedListener;
    }

    public ConversationViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        switch (viewType) {
            case 6: {
                return new TimeStampViewHolder(inflater.inflate(R.layout.intercom_day_divider, parent, false), this, this.context);
            }
            case 1: 
            case 4: 
            case 5: {
                return new PartViewHolder(inflater.inflate(R.layout.intercom_row_admin_part, parent, false), viewType, this, this.clipboardManager, this.context);
            }
            case 2: {
                return new ContainerCardViewHolder(inflater.inflate(R.layout.intercom_row_post, parent, false), viewType, this, this.clipboardManager, this.context, false);
            }
            case 3: {
                return new ContainerCardViewHolder(inflater.inflate(R.layout.intercom_row_note, parent, false), viewType, this, this.clipboardManager, this.context, this.allowExpansionArrow);
            }
            case 7: {
                View view = inflater.inflate(R.layout.intercom_row_loading, parent, false);
                return new LoadingConversationLoadingLayout(view, this, this.context);
            }
        }
        return new PartViewHolder(inflater.inflate(R.layout.intercom_row_user_part, parent, false), viewType, this, this.clipboardManager, this.context);
    }

    public void onBindViewHolder(ConversationViewHolder holder, int position) {
        holder.bind(this.getPart(position));
    }

    public int getItemViewType(int position) {
        Part conversationPart = this.partList.get(position);
        String messageStyle = conversationPart.getMessageStyle();
        int type = 0;
        if ("admin_is_typing_style".equals(messageStyle)) {
            return 5;
        }
        if ("day_divider_style".equals(messageStyle)) {
            return 6;
        }
        if ("loading_layout_style".equals(messageStyle)) {
            return 7;
        }
        Participant user = conversationPart.getParticipant();
        if ("admin".equals(user.getType())) {
            if ("post".equals(messageStyle)) {
                type = 2;
            } else if ("note".equals(messageStyle)) {
                this.startAllowingExpansionArrowIfPositionIsNotLast(position);
                type = 3;
            } else {
                type = 1;
            }
        } else if (!user.getId().equals(Injector.get().getIdentityStore().getIntercomId())) {
            type = 4;
        }
        return type;
    }

    private void startAllowingExpansionArrowIfPositionIsNotLast(int position) {
        this.allowExpansionArrow |= position != this.partList.size() - 1;
    }

    public int getItemCount() {
        return this.partList.size();
    }

    @Override
    public int getCount() {
        return this.getItemCount();
    }

    @Override
    public Part getPart(int position) {
        return this.partList.get(position);
    }

    @Override
    @Nullable
    public Part getSelectedPart() {
        return this.selectedPart;
    }

    @Override
    public void onPartClicked(int position, PartViewHolder partViewHolder) {
        Part part = this.partList.get(position);
        if (part.getMessageState() == Part.MessageState.FAILED || part.getMessageState() == Part.MessageState.UPLOAD_FAILED || position == this.getCount() - 1) {
            this.partClickedListener.onPartClicked(part);
        } else if (part == this.selectedPart) {
            this.selectedPart = null;
            partViewHolder.setExpanded(false);
        } else {
            int index = this.partList.indexOf(this.selectedPart);
            this.notifyItemChanged(index);
            this.selectedPart = part;
            partViewHolder.setExpanded(true);
        }
    }

    @Override
    public void onContainerCardClicked(int position, ContainerCardViewHolder containerCardViewHolder) {
        Part part = this.partList.get(position);
        switch (this.getItemViewType(position)) {
            case 3: {
                if (!this.allowExpansionArrow) break;
                containerCardViewHolder.toggleExpanded();
                break;
            }
            case 2: {
                Context context = Injector.get().getContext();
                context.startActivity(IntercomPostActivity.buildPostIntent(context, part, "", new LastParticipatingAdmin.NullLastParticipant(), false));
                break;
            }
        }
    }

    public static interface PartClickedListener {
        public void onPartClicked(Part var1);
    }
}

