/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Base64;
import io.intercom.android.sdk.identity.IdentityStore;
import io.intercom.okhttp3.Interceptor;
import io.intercom.okhttp3.Request;
import io.intercom.okhttp3.Response;
import java.io.IOException;

public class HeaderInterceptor
implements Interceptor {
    private static final String CORDOVA_PREFS = "intercomsdk_cordova_prefs";
    private static final String CORDOVA_VERSION = "cordova_version";
    private static final String INTERCOM_AGENT = "X-INTERCOM-AGENT";
    private static final String INTERCOM_AGENT_WRAPPER = "X-INTERCOM-AGENT-WRAPPER";
    private static final String ANDROID_HEADER = "intercom-android-sdk/";
    private static final String CORDOVA_HEADER = "intercom-sdk-cordova/";
    private static final String AUTHORIZATION = "Authorization";
    private static final String CONTENT_TYPE_KEY = "Content-Type";
    private static final String CONTENT_TYPE_VALUE = "application/json";
    private final String cordovaVersion;
    private final String versionName;
    private final IdentityStore identityStore;

    public static HeaderInterceptor create(Context context, IdentityStore identityStore) {
        String cordovaVersion = context.getSharedPreferences(CORDOVA_PREFS, 0).getString(CORDOVA_VERSION, "");
        return new HeaderInterceptor(cordovaVersion, "3.0.0-beta1", identityStore);
    }

    HeaderInterceptor(String cordovaVersion, String versionName, IdentityStore identityStore) {
        this.cordovaVersion = cordovaVersion;
        this.versionName = versionName;
        this.identityStore = identityStore;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder requestBuilder = chain.request().newBuilder().header(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE).header(AUTHORIZATION, this.getBasicAuth()).header(INTERCOM_AGENT, ANDROID_HEADER + this.versionName);
        if (!this.cordovaVersion.isEmpty()) {
            requestBuilder.header(INTERCOM_AGENT_WRAPPER, CORDOVA_HEADER + this.cordovaVersion);
        }
        Request build = requestBuilder.build();
        return chain.proceed(build);
    }

    private String getBasicAuth() {
        String authString = this.identityStore.getAppId() + ":" + this.identityStore.getApiKey();
        return "Basic " + Base64.encodeToString((byte[])authString.getBytes(), (int)2);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static void setCordovaVersion(Context context, String cordovaVersion) {
        context.getSharedPreferences(CORDOVA_PREFS, 0).edit().putString(CORDOVA_VERSION, cordovaVersion).commit();
    }
}

