/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.TimeProvider;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class TimeFormatter {
    private final Context context;
    private final TimeProvider timeProvider;

    public TimeFormatter(Context context, TimeProvider timeProvider) {
        this.context = context;
        this.timeProvider = timeProvider;
    }

    public CharSequence getFormattedTime(long time) {
        if (time <= 0L) {
            return "";
        }
        Date date = new Date(time * 1000L);
        return this.getFormattedTime(date);
    }

    private CharSequence getFormattedTime(Date date) {
        Phrase displayDate;
        long diffInMin = this.getDifferenceInMinutes(date);
        long diffInHours = this.getDifferenceInHours(date);
        long diffInDays = this.getDifferenceInDays(date);
        long diffInWeeks = diffInDays / 7L;
        if (diffInWeeks > 0L) {
            displayDate = Phrase.from(this.context, R.string.intercom_time_week_ago).put("delta", Long.toString(diffInWeeks));
        } else if (diffInDays > 0L) {
            displayDate = Phrase.from(this.context, R.string.intercom_time_day_ago).put("delta", Long.toString(diffInDays));
        } else if (diffInHours > 0L) {
            displayDate = Phrase.from(this.context, R.string.intercom_time_hour_ago).put("delta", Long.toString(diffInHours));
        } else if (diffInMin >= 1L) {
            displayDate = Phrase.from(this.context, R.string.intercom_time_minute_ago).put("delta", Long.toString(diffInMin));
        } else {
            return this.context.getText(R.string.intercom_time_just_now);
        }
        return displayDate.format();
    }

    public CharSequence getAdminActiveStatus(long time) {
        if (time <= 0L) {
            return "";
        }
        Date date = new Date(time * 1000L);
        return this.getAdminActiveStatus(date);
    }

    private CharSequence getAdminActiveStatus(Date date) {
        long diffInMin = this.getDifferenceInMinutes(date);
        if (diffInMin > TimeUnit.DAYS.toMinutes(6L)) {
            return this.context.getText(R.string.intercom_active_status_w_ago);
        }
        Phrase displayDate = diffInMin >= TimeUnit.HOURS.toMinutes(23L) + 31L ? Phrase.from(this.context, R.string.intercom_active_status_d_ago).put("days", Long.toString(1L + (diffInMin / 60L - 13L) / 24L)) : (diffInMin >= 53L ? Phrase.from(this.context, R.string.intercom_active_status_h_ago).put("hours", Long.toString(1L + (diffInMin - 31L) / 60L)) : (diffInMin >= 38L ? Phrase.from(this.context, R.string.intercom_active_status_m_ago).put("minutes", Long.toString(45L)) : (diffInMin >= 16L ? Phrase.from(this.context, R.string.intercom_active_status_m_ago).put("minutes", Long.toString(30L)) : Phrase.from(this.context, R.string.intercom_active_status_15m_ago).put("minutes", Long.toString(15L)))));
        return displayDate.format();
    }

    private long getDifferenceInMinutes(Date date) {
        return TimeUnit.MILLISECONDS.toMinutes(this.timeProvider.currentTimeMillis() - date.getTime());
    }

    private long getDifferenceInHours(Date date) {
        return TimeUnit.MILLISECONDS.toHours(this.timeProvider.currentTimeMillis() - date.getTime());
    }

    private long getDifferenceInDays(Date date) {
        return TimeUnit.MILLISECONDS.toDays(this.timeProvider.currentTimeMillis() - date.getTime());
    }

    public static String getAbsoluteDate(long timeInSeconds) {
        return TimeFormatter.getAbsoluteDate(timeInSeconds, Calendar.getInstance());
    }

    @VisibleForTesting
    static String getAbsoluteDate(long timeInSeconds, Calendar calendar) {
        calendar.setTimeInMillis(timeInSeconds * 1000L);
        return String.format("%s %d", calendar.getDisplayName(2, 2, Locale.getDefault()), calendar.get(5));
    }

    public static String getAbsoluteTime(long timeInSeconds) {
        return TimeFormatter.getAbsoluteTime(timeInSeconds, Calendar.getInstance());
    }

    @VisibleForTesting
    static String getAbsoluteTime(long time, Calendar calendar) {
        calendar.setTimeInMillis(time * 1000L);
        return String.format(Locale.getDefault(), "%02d:%02d", calendar.get(11), calendar.get(12));
    }
}

