/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.view.View;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0003\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lio/intercom/android/sdk/utilities/AccessibilityUtils;", "", "<init>", "()V", "addClickAbilityAnnouncement", "", "view", "Landroid/view/View;", "removeClickAbilityAnnouncement", "addHeadingAnnouncement", "intercom-sdk-base_release"})
@StabilityInferred(parameters=1)
public final class AccessibilityUtils {
    @NotNull
    public static final AccessibilityUtils INSTANCE = new AccessibilityUtils();
    public static final int $stable;

    private AccessibilityUtils() {
    }

    public final void addClickAbilityAnnouncement(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.addAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK);
                info.setClickable(true);
            }
        });
    }

    public final void removeClickAbilityAnnouncement(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK);
                info.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_LONG_CLICK);
                info.setClickable(false);
                info.setLongClickable(false);
            }
        });
    }

    public final void addHeadingAnnouncement(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setHeading(true);
            }
        });
    }
}

