/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.utils.audio;

import android.content.Context;
import android.media.MediaRecorder;
import android.net.Uri;
import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.FileProvider;
import io.intercom.android.sdk.IntercomFileProviderKt;
import io.intercom.android.sdk.utilities.IoUtils;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0001\u0018\u0000 /2\u00020\u0001:\u0004/012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\u001eJ\b\u0010!\u001a\u00020\u000bH\u0002J\b\u0010\"\u001a\u00020\tH\u0002J\u0018\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u000bH\u0002J\b\u0010&\u001a\u00020\u001eH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000bH\u0002J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\tH\u0002J\b\u0010+\u001a\u00020\u001eH\u0002J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014\u00a8\u00063"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager;", "", "context", "Landroid/content/Context;", "amplitudeScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Landroid/content/Context;Lkotlinx/coroutines/CoroutineScope;)V", "mediaRecorder", "Landroid/media/MediaRecorder;", "currentRecordingFile", "Ljava/io/File;", "amplitudeMonitoringJob", "Lkotlinx/coroutines/Job;", "_recordingState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState;", "recordingState", "Lkotlinx/coroutines/flow/StateFlow;", "getRecordingState", "()Lkotlinx/coroutines/flow/StateFlow;", "_amplitudeLevel", "", "amplitudeLevel", "getAmplitudeLevel", "startRecording", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingResult;", "stopRecording", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingStopResult;", "cancelRecording", "", "cleanupCompletedRecording", "dispose", "createAudioFile", "createMediaRecorder", "configureRecorder", "recorder", "outputFile", "cleanup", "waitForFileAvailability", "", "file", "startAmplitudeMonitoring", "stopAmplitudeMonitoring", "normalizeAmplitude", "rawAmplitude", "", "Companion", "RecordingState", "RecordingResult", "RecordingStopResult", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
public final class AudioRecordingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final CoroutineScope amplitudeScope;
    @Nullable
    private MediaRecorder mediaRecorder;
    @Nullable
    private File currentRecordingFile;
    @Nullable
    private Job amplitudeMonitoringJob;
    @NotNull
    private final MutableStateFlow<RecordingState> _recordingState;
    @NotNull
    private final StateFlow<RecordingState> recordingState;
    @NotNull
    private final MutableStateFlow<Float> _amplitudeLevel;
    @NotNull
    private final StateFlow<Float> amplitudeLevel;
    public static final int $stable = 8;
    @NotNull
    private static final String AUDIO_RECORDINGS_FOLDER = "audio_recordings";
    @NotNull
    private static final String AUDIO_FILE_EXTENSION = "m4a";
    private static final int AUDIO_SAMPLE_RATE = 44100;
    private static final int AUDIO_BIT_RATE = 128000;
    private static final int FILE_AVAILABILITY_MAX_RETRIES = 10;
    private static final long FILE_AVAILABILITY_BASE_DELAY_MS = 10L;
    private static final long AMPLITUDE_MONITORING_INTERVAL_MS = 60L;
    private static final double MAX_AMPLITUDE_REFERENCE = 32767.0;

    public AudioRecordingManager(@NotNull Context context, @NotNull CoroutineScope amplitudeScope) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)amplitudeScope, (String)"amplitudeScope");
        this.context = context;
        this.amplitudeScope = amplitudeScope;
        this._recordingState = StateFlowKt.MutableStateFlow((Object)RecordingState.Idle.INSTANCE);
        this.recordingState = FlowKt.asStateFlow(this._recordingState);
        this._amplitudeLevel = StateFlowKt.MutableStateFlow((Object)Float.valueOf(0.0f));
        this.amplitudeLevel = FlowKt.asStateFlow(this._amplitudeLevel);
    }

    @NotNull
    public final StateFlow<RecordingState> getRecordingState() {
        return this.recordingState;
    }

    @NotNull
    public final StateFlow<Float> getAmplitudeLevel() {
        return this.amplitudeLevel;
    }

    @NotNull
    public final RecordingResult startRecording() {
        try {
            MediaRecorder recorder;
            File audioFile;
            if (!Intrinsics.areEqual((Object)this._recordingState.getValue(), (Object)RecordingState.Idle.INSTANCE)) {
                return new RecordingResult.Error("Recording already in progress");
            }
            this.currentRecordingFile = audioFile = this.createAudioFile();
            this.mediaRecorder = recorder = this.createMediaRecorder();
            this.configureRecorder(recorder, audioFile);
            recorder.prepare();
            recorder.start();
            this.startAmplitudeMonitoring(recorder);
            this._recordingState.setValue((Object)new RecordingState.Recording(audioFile));
            return RecordingResult.Success.INSTANCE;
        }
        catch (IOException e) {
            this.stopAmplitudeMonitoring();
            this.cleanup();
            this._recordingState.setValue((Object)new RecordingState.Error("Failed to start recording: " + e.getMessage()));
            return new RecordingResult.Error("Failed to start recording: " + e.getMessage());
        }
        catch (Exception e) {
            this.stopAmplitudeMonitoring();
            this.cleanup();
            this._recordingState.setValue((Object)new RecordingState.Error("Unexpected error: " + e.getMessage()));
            return new RecordingResult.Error("Unexpected error: " + e.getMessage());
        }
    }

    @NotNull
    public final RecordingStopResult stopRecording() {
        try {
            MediaRecorder recorder = this.mediaRecorder;
            File recordingFile = this.currentRecordingFile;
            if (recorder == null || recordingFile == null) {
                this._recordingState.setValue((Object)new RecordingState.Error("No active recording"));
                return new RecordingStopResult.Error("No active recording");
            }
            this.stopAmplitudeMonitoring();
            recorder.stop();
            recorder.release();
            this.mediaRecorder = null;
            if (!this.waitForFileAvailability(recordingFile)) {
                this.cleanup();
                this._recordingState.setValue((Object)new RecordingState.Error("Recording file is empty or missing"));
                return new RecordingStopResult.Error("Recording file is empty or missing");
            }
            Uri uri = FileProvider.getUriForFile((Context)this.context, (String)IntercomFileProviderKt.fileProviderAuthority(this.context), (File)recordingFile);
            Intrinsics.checkNotNull((Object)uri);
            this._recordingState.setValue((Object)new RecordingState.Completed(uri, recordingFile));
            return new RecordingStopResult.Success(uri, recordingFile);
        }
        catch (Exception e) {
            this.stopAmplitudeMonitoring();
            this.cleanup();
            this._recordingState.setValue((Object)new RecordingState.Error("Failed to stop recording: " + e.getMessage()));
            return new RecordingStopResult.Error("Failed to stop recording: " + e.getMessage());
        }
    }

    public final void cancelRecording() {
        this.stopAmplitudeMonitoring();
        this.cleanup();
        this._recordingState.setValue((Object)RecordingState.Idle.INSTANCE);
    }

    public final void cleanupCompletedRecording() {
        RecordingState state = (RecordingState)this._recordingState.getValue();
        if (state instanceof RecordingState.Completed) {
            IoUtils.safelyDelete(((RecordingState.Completed)state).getFile());
        }
        this._recordingState.setValue((Object)RecordingState.Idle.INSTANCE);
    }

    public final void dispose() {
        this.stopAmplitudeMonitoring();
        this.cleanup();
        this.cleanupCompletedRecording();
        this._recordingState.setValue((Object)RecordingState.Idle.INSTANCE);
    }

    private final File createAudioFile() {
        File cacheDir;
        File file = this.context.getExternalCacheDir();
        if (file == null) {
            file = this.context.getCacheDir();
        }
        if ((cacheDir = file) == null) {
            throw new IOException("Unable to access cache directories for audio recording");
        }
        File audioFolder = new File(cacheDir, AUDIO_RECORDINGS_FOLDER);
        audioFolder.mkdirs();
        String fileName = UUID.randomUUID() + ".m4a";
        return new File(audioFolder, fileName);
    }

    private final MediaRecorder createMediaRecorder() {
        return Build.VERSION.SDK_INT >= 31 ? new MediaRecorder(this.context) : new MediaRecorder();
    }

    private final void configureRecorder(MediaRecorder recorder, File outputFile) {
        MediaRecorder mediaRecorder;
        MediaRecorder $this$configureRecorder_u24lambda_u240 = mediaRecorder = recorder;
        boolean bl = false;
        $this$configureRecorder_u24lambda_u240.setAudioSource(1);
        $this$configureRecorder_u24lambda_u240.setOutputFormat(2);
        $this$configureRecorder_u24lambda_u240.setAudioEncoder(3);
        $this$configureRecorder_u24lambda_u240.setAudioSamplingRate(44100);
        $this$configureRecorder_u24lambda_u240.setAudioEncodingBitRate(128000);
        $this$configureRecorder_u24lambda_u240.setOutputFile(outputFile.getAbsolutePath());
    }

    private final void cleanup() {
        MediaRecorder mediaRecorder = this.mediaRecorder;
        if (mediaRecorder != null) {
            MediaRecorder mediaRecorder2;
            MediaRecorder $this$cleanup_u24lambda_u241 = mediaRecorder2 = mediaRecorder;
            boolean bl = false;
            try {
                $this$cleanup_u24lambda_u241.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            $this$cleanup_u24lambda_u241.release();
        }
        this.mediaRecorder = null;
        File file = this.currentRecordingFile;
        if (file != null) {
            File file2 = file;
            boolean bl = false;
            IoUtils.safelyDelete(file2);
        }
        this.currentRecordingFile = null;
    }

    private final boolean waitForFileAvailability(File file) {
        int n = 10;
        for (int i = 0; i < n; ++i) {
            int attempt = i;
            boolean bl = false;
            if (file.exists() && file.length() > 0L) {
                return true;
            }
            if (attempt >= 9) continue;
            long delayMs = 10L * (long)(1 << attempt);
            Thread.sleep(delayMs);
        }
        return false;
    }

    private final void startAmplitudeMonitoring(MediaRecorder recorder) {
        this.amplitudeMonitoringJob = BuildersKt.launch$default((CoroutineScope)this.amplitudeScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(recorder, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MediaRecorder $recorder;
            final /* synthetic */ AudioRecordingManager this$0;
            {
                this.$recorder = $recorder;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            try {
                                amplitude = this.$recorder.getMaxAmplitude();
                                normalizedAmplitude = AudioRecordingManager.access$normalizeAmplitude(this.this$0, amplitude);
                                AudioRecordingManager.access$get_amplitudeLevel$p(this.this$0).setValue((Object)Boxing.boxFloat((float)normalizedAmplitude));
                            }
                            catch (Exception var3_5) {
                                AudioRecordingManager.access$get_amplitudeLevel$p(this.this$0).setValue((Object)Boxing.boxFloat((float)0.0f));
                            }
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay((long)60L, (Continuation)((Continuation)this));
                            if (v0 != var5_2) continue;
                            return var5_2;
                        }
                        break;
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void stopAmplitudeMonitoring() {
        Job job2 = this.amplitudeMonitoringJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.amplitudeMonitoringJob = null;
        this._amplitudeLevel.setValue((Object)Float.valueOf(0.0f));
    }

    private final float normalizeAmplitude(int rawAmplitude) {
        if (rawAmplitude <= 0) {
            return 0.0f;
        }
        double ratio = (double)rawAmplitude / 32767.0;
        double decibels = (double)20 * Math.log10(Math.max(ratio, 0.001));
        double normalizedDb = Math.max(0.0, (decibels + 60.0) / 60.0);
        return (float)normalizedDb;
    }

    public static final /* synthetic */ float access$normalizeAmplitude(AudioRecordingManager $this, int rawAmplitude) {
        return $this.normalizeAmplitude(rawAmplitude);
    }

    public static final /* synthetic */ MutableStateFlow access$get_amplitudeLevel$p(AudioRecordingManager $this) {
        return $this._amplitudeLevel;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$Companion;", "", "<init>", "()V", "AUDIO_RECORDINGS_FOLDER", "", "AUDIO_FILE_EXTENSION", "AUDIO_SAMPLE_RATE", "", "AUDIO_BIT_RATE", "FILE_AVAILABILITY_MAX_RETRIES", "FILE_AVAILABILITY_BASE_DELAY_MS", "", "AMPLITUDE_MONITORING_INTERVAL_MS", "MAX_AMPLITUDE_REFERENCE", "", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingResult;", "", "Success", "Error", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingResult$Error;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingResult$Success;", "intercom-sdk-base_release"})
    public static interface RecordingResult {

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c7\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d7\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d7\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d7\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingResult$Error;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingResult;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=1)
        public static final class Error
        implements RecordingResult {
            @NotNull
            private final String message;
            public static final int $stable;

            public Error(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final Error copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new Error(message);
            }

            public static /* synthetic */ Error copy$default(Error error, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = error.message;
                }
                return error.copy(string2);
            }

            @NotNull
            public String toString() {
                return "Error(message=" + this.message + ')';
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                return Intrinsics.areEqual((Object)this.message, (Object)error.message);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0003\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d7\u0003J\t\u0010\b\u001a\u00020\tH\u00d7\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d7\u0001\u00a8\u0006\f"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingResult$Success;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=1)
        public static final class Success
        implements RecordingResult {
            @NotNull
            public static final Success INSTANCE = new Success();
            public static final int $stable;

            private Success() {
            }

            @NotNull
            public String toString() {
                return "Success";
            }

            public int hashCode() {
                return 1987294265;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success cfr_ignored_0 = (Success)other;
                return true;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00a8\u0006\n"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState;", "", "Idle", "Recording", "Completed", "Error", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState$Completed;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState$Error;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState$Idle;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState$Recording;", "intercom-sdk-base_release"})
    public static interface RecordingState {

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c7\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d7\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d7\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d7\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState$Completed;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState;", "uri", "Landroid/net/Uri;", "file", "Ljava/io/File;", "<init>", "(Landroid/net/Uri;Ljava/io/File;)V", "getUri", "()Landroid/net/Uri;", "getFile", "()Ljava/io/File;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=0)
        public static final class Completed
        implements RecordingState {
            @NotNull
            private final Uri uri;
            @NotNull
            private final File file;
            public static final int $stable = 8;

            public Completed(@NotNull Uri uri, @NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.uri = uri;
                this.file = file;
            }

            @NotNull
            public final Uri getUri() {
                return this.uri;
            }

            @NotNull
            public final File getFile() {
                return this.file;
            }

            @NotNull
            public final Uri component1() {
                return this.uri;
            }

            @NotNull
            public final File component2() {
                return this.file;
            }

            @NotNull
            public final Completed copy(@NotNull Uri uri, @NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return new Completed(uri, file);
            }

            public static /* synthetic */ Completed copy$default(Completed completed, Uri uri, File file, int n, Object object) {
                if ((n & 1) != 0) {
                    uri = completed.uri;
                }
                if ((n & 2) != 0) {
                    file = completed.file;
                }
                return completed.copy(uri, file);
            }

            @NotNull
            public String toString() {
                return "Completed(uri=" + this.uri + ", file=" + this.file + ')';
            }

            public int hashCode() {
                int result = this.uri.hashCode();
                result = result * 31 + this.file.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Completed)) {
                    return false;
                }
                Completed completed = (Completed)other;
                if (!Intrinsics.areEqual((Object)this.uri, (Object)completed.uri)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.file, (Object)completed.file);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c7\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d7\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d7\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d7\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState$Error;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=1)
        public static final class Error
        implements RecordingState {
            @NotNull
            private final String message;
            public static final int $stable;

            public Error(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final Error copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new Error(message);
            }

            public static /* synthetic */ Error copy$default(Error error, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = error.message;
                }
                return error.copy(string2);
            }

            @NotNull
            public String toString() {
                return "Error(message=" + this.message + ')';
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                return Intrinsics.areEqual((Object)this.message, (Object)error.message);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0003\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d7\u0003J\t\u0010\b\u001a\u00020\tH\u00d7\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d7\u0001\u00a8\u0006\f"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState$Idle;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=1)
        public static final class Idle
        implements RecordingState {
            @NotNull
            public static final Idle INSTANCE = new Idle();
            public static final int $stable;

            private Idle() {
            }

            @NotNull
            public String toString() {
                return "Idle";
            }

            public int hashCode() {
                return -114329640;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Idle)) {
                    return false;
                }
                Idle cfr_ignored_0 = (Idle)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c7\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d7\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d7\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d7\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState$Recording;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingState;", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=0)
        public static final class Recording
        implements RecordingState {
            @NotNull
            private final File file;
            public static final int $stable = 8;

            public Recording(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.file = file;
            }

            @NotNull
            public final File getFile() {
                return this.file;
            }

            @NotNull
            public final File component1() {
                return this.file;
            }

            @NotNull
            public final Recording copy(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return new Recording(file);
            }

            public static /* synthetic */ Recording copy$default(Recording recording, File file, int n, Object object) {
                if ((n & 1) != 0) {
                    file = recording.file;
                }
                return recording.copy(file);
            }

            @NotNull
            public String toString() {
                return "Recording(file=" + this.file + ')';
            }

            public int hashCode() {
                return this.file.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Recording)) {
                    return false;
                }
                Recording recording = (Recording)other;
                return Intrinsics.areEqual((Object)this.file, (Object)recording.file);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingStopResult;", "", "Success", "Error", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingStopResult$Error;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingStopResult$Success;", "intercom-sdk-base_release"})
    public static interface RecordingStopResult {

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c7\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d7\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d7\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d7\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingStopResult$Error;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingStopResult;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=1)
        public static final class Error
        implements RecordingStopResult {
            @NotNull
            private final String message;
            public static final int $stable;

            public Error(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.message = message;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final Error copy(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new Error(message);
            }

            public static /* synthetic */ Error copy$default(Error error, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = error.message;
                }
                return error.copy(string2);
            }

            @NotNull
            public String toString() {
                return "Error(message=" + this.message + ')';
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                return Intrinsics.areEqual((Object)this.message, (Object)error.message);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c7\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d7\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d7\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d7\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingStopResult$Success;", "Lio/intercom/android/sdk/m5/conversation/utils/audio/AudioRecordingManager$RecordingStopResult;", "uri", "Landroid/net/Uri;", "file", "Ljava/io/File;", "<init>", "(Landroid/net/Uri;Ljava/io/File;)V", "getUri", "()Landroid/net/Uri;", "getFile", "()Ljava/io/File;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=0)
        public static final class Success
        implements RecordingStopResult {
            @NotNull
            private final Uri uri;
            @NotNull
            private final File file;
            public static final int $stable = 8;

            public Success(@NotNull Uri uri, @NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.uri = uri;
                this.file = file;
            }

            @NotNull
            public final Uri getUri() {
                return this.uri;
            }

            @NotNull
            public final File getFile() {
                return this.file;
            }

            @NotNull
            public final Uri component1() {
                return this.uri;
            }

            @NotNull
            public final File component2() {
                return this.file;
            }

            @NotNull
            public final Success copy(@NotNull Uri uri, @NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return new Success(uri, file);
            }

            public static /* synthetic */ Success copy$default(Success success, Uri uri, File file, int n, Object object) {
                if ((n & 1) != 0) {
                    uri = success.uri;
                }
                if ((n & 2) != 0) {
                    file = success.file;
                }
                return success.copy(uri, file);
            }

            @NotNull
            public String toString() {
                return "Success(uri=" + this.uri + ", file=" + this.file + ')';
            }

            public int hashCode() {
                int result = this.uri.hashCode();
                result = result * 31 + this.file.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                if (!Intrinsics.areEqual((Object)this.uri, (Object)success.uri)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.file, (Object)success.file);
            }
        }
    }
}

