/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.errorreporting;

import io.intercom.android.sdk.errorreporting.ErrorReporter;

class IntercomExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler originalHandler;
    private final ErrorReporter reporter;

    static void enable(ErrorReporter reporter) {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler instanceof IntercomExceptionHandler) {
            return;
        }
        Thread.setDefaultUncaughtExceptionHandler(new IntercomExceptionHandler(currentHandler, reporter));
    }

    static void disable() {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler instanceof IntercomExceptionHandler) {
            IntercomExceptionHandler intercomHandler = (IntercomExceptionHandler)currentHandler;
            Thread.setDefaultUncaughtExceptionHandler(intercomHandler.originalHandler);
        }
    }

    IntercomExceptionHandler(Thread.UncaughtExceptionHandler originalHandler, ErrorReporter reporter) {
        this.originalHandler = originalHandler;
        this.reporter = reporter;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.reporter.saveReport(e);
        if (this.originalHandler != null) {
            this.originalHandler.uncaughtException(t, e);
        } else {
            System.err.printf("Exception in thread \"%s\" ", t.getName());
            e.printStackTrace(System.err);
        }
    }
}

