/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.carousel.permission;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.intercom.android.sdk.carousel.PermissionManager;
import io.intercom.android.sdk.carousel.permission.PermissionRequest;
import io.intercom.android.sdk.carousel.permission.PermissionResultListener;
import io.intercom.android.sdk.models.carousel.ScreenAction;
import java.util.Arrays;
import java.util.List;

class PermissionRequestBefore30
implements PermissionRequest {
    protected final PermissionManager permissionManager;
    @Nullable
    private PermissionResultListener permissionResultListener;
    private final PermissionResultListener nullListener = new NullPermissionResultListener();

    PermissionRequestBefore30(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public void attach(@Nullable PermissionResultListener permissionResultListener) {
        this.permissionResultListener = permissionResultListener;
    }

    @Override
    public void detach() {
        this.permissionResultListener = null;
    }

    @Override
    public void request(ScreenAction screenAction, int requestCode) {
        List<String> permissions = screenAction.getValidPermissions(this.permissionManager);
        if (!permissions.isEmpty()) {
            this.handleRequest(permissions, requestCode);
        }
    }

    @Override
    public void handleResult(@NonNull String[] permissions, @NonNull int[] grantResults) {
        this.handleRequestResult(permissions, grantResults);
    }

    protected void handleGranted(String[] permissions) {
        this.getListener().showGranted();
    }

    protected void handleRequest(List<String> permissions, int requestCode) {
        String[] permissionsArray = permissions.toArray(new String[0]);
        this.permissionManager.requestPermissions(permissionsArray, requestCode);
    }

    @NonNull
    PermissionResultListener getListener() {
        if (this.permissionResultListener == null) {
            return this.nullListener;
        }
        return this.permissionResultListener;
    }

    private void handleRequestResult(@NonNull String[] permissions, @NonNull int[] grantResults) {
        if (this.permissionManager.anyPermissionPermanentlyDeniedInResult(permissions, grantResults)) {
            this.getListener().showDeniedPermanently();
        } else if (this.permissionManager.permissionsGranted(Arrays.asList(permissions))) {
            this.handleGranted(permissions);
        } else {
            this.getListener().showDeniedTemporarily();
        }
    }

    private static final class NullPermissionResultListener
    implements PermissionResultListener {
        private NullPermissionResultListener() {
        }

        @Override
        public void showGranted() {
        }

        @Override
        public void showDeniedTemporarily() {
        }

        @Override
        public void showDeniedPermanently() {
        }

        @Override
        public void requestBackgroundLocationPermission() {
        }
    }
}

