/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.articles;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.articles.ArticleWebViewListener;
import io.intercom.android.sdk.utilities.LinkOpener;

public class ArticleWebViewClient
extends WebViewClient {
    private final String articleUrl;
    private final ArticleWebViewListener articleWebViewListener;
    private boolean isLoadError;
    private boolean isArticleNotFound = false;

    public ArticleWebViewClient(String url, ArticleWebViewListener articleWebViewListener) {
        this.articleUrl = url;
        this.articleWebViewListener = articleWebViewListener;
    }

    public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
        super.onReceivedHttpError(view, request, errorResponse);
        if (errorResponse.getStatusCode() == 404 || errorResponse.getStatusCode() == 401) {
            this.isLoadError = true;
            this.isArticleNotFound = true;
            this.articleWebViewListener.articleNotFound();
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (!this.isLoadError && !this.isArticleNotFound) {
            this.scrollToAnchorIfNeeded(view, url);
            this.articleWebViewListener.onArticleFinishedLoading();
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        if (!this.isArticleNotFound) {
            this.isLoadError = false;
            this.articleWebViewListener.onArticleStartedLoading();
        }
    }

    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        this.isLoadError = true;
        this.articleWebViewListener.onArticleLoadingError();
    }

    public boolean shouldOverrideUrlLoading(WebView view, String urlString) {
        Uri urlUri = Uri.parse((String)urlString);
        Uri articleUri = Uri.parse((String)this.articleUrl);
        String loadingUrlLastSegment = urlUri.getLastPathSegment();
        String articleUrlLastSegment = articleUri.getLastPathSegment();
        String loadingArticleId = this.extractArticleId(loadingUrlLastSegment);
        String articleId = this.extractArticleId(articleUrlLastSegment);
        if (!TextUtils.isEmpty((CharSequence)loadingArticleId) && !TextUtils.isEmpty((CharSequence)articleId) && loadingArticleId.equals(articleId)) {
            return false;
        }
        LinkOpener.handleUrl(urlString, view.getContext(), Injector.get().getApi());
        return true;
    }

    private String extractArticleId(String pathSegment) {
        if (TextUtils.isEmpty((CharSequence)pathSegment)) {
            return null;
        }
        int hyphenIndex = pathSegment.indexOf(45);
        if (hyphenIndex > 0) {
            return pathSegment.substring(0, hyphenIndex);
        }
        return pathSegment;
    }

    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        return this.shouldOverrideUrlLoading(view, request.getUrl().toString());
    }

    private void scrollToAnchorIfNeeded(WebView view, String url) {
        String anchor = Uri.parse((String)url).getFragment();
        if (anchor != null) {
            view.evaluateJavascript("document.getElementById('" + anchor + "').offsetTop", value -> {
                try {
                    int y = (int)this.getDensityIndependentPixels(Integer.parseInt(value), view.getContext());
                    this.articleWebViewListener.scrollArticleViewTo(y);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }
    }

    private float getDensityIndependentPixels(int pixels, Context context) {
        return TypedValue.applyDimension((int)1, (float)pixels, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

