/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.ActivityLifecycleHandler;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.ResetManager;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.errorreporting.ErrorReporter;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.IntercomRootActivity;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.m5.data.IntercomEvent;
import io.intercom.android.sdk.m5.push.IntercomPushClientHandler;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.HostAppState;
import io.intercom.android.sdk.user.UserUpdaterHelper;
import io.intercom.android.sdk.utilities.SimpleActivityLifecycleCallbacks;
import io.intercom.android.sdk.utilities.commons.TimeProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class LifecycleTracker
extends SimpleActivityLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private final Set<Integer> startedActivities = new HashSet<Integer>();
    private final MetricsStore metricsStore;
    private final ErrorReporter errorReporter;
    private final DeDuper deDuper;
    private final TimeProvider timeProvider;
    private final ResetManager resetManager;
    private final ActivityLifecycleHandler handler;
    private final Twig twig = LumberMill.getLogger();
    private final Provider<Api> apiProvider;
    private final IntercomDataLayer dataLayer;
    private final UserUpdaterHelper userUpdaterHelper;

    static LifecycleTracker create(MetricsStore metricsStore, ErrorReporter errorReporter, DeDuper deDuper, TimeProvider timeProvider, ResetManager resetManager, float transitionScale, Provider<Api> apiProvider, IntercomDataLayer dataLayer, UserUpdaterHelper userUpdaterHelper) {
        return new LifecycleTracker(metricsStore, errorReporter, deDuper, timeProvider, resetManager, new ActivityLifecycleHandler(Looper.getMainLooper(), transitionScale, dataLayer), apiProvider, dataLayer, userUpdaterHelper);
    }

    @VisibleForTesting
    LifecycleTracker(MetricsStore metricsStore, ErrorReporter errorReporter, DeDuper deDuper, TimeProvider timeProvider, ResetManager resetManager, ActivityLifecycleHandler handler, Provider<Api> apiProvider, IntercomDataLayer dataLayer, UserUpdaterHelper userUpdaterHelper) {
        this.metricsStore = metricsStore;
        this.errorReporter = errorReporter;
        this.deDuper = deDuper;
        this.timeProvider = timeProvider;
        this.resetManager = resetManager;
        this.handler = handler;
        this.apiProvider = apiProvider;
        this.dataLayer = dataLayer;
        this.userUpdaterHelper = userUpdaterHelper;
    }

    @Override
    public void onActivityStarted(Activity activity) {
        this.registerActivity(activity);
        this.handleExtras(activity);
        if (!((HostAppState)this.dataLayer.getHostAppState().getValue()).isForeground()) {
            long timestamp = this.timeProvider.currentTimeMillis();
            this.userUpdaterHelper.update(timestamp);
            this.dataLayer.emitEvent(new IntercomEvent.AppEnteredForeground(timestamp));
            this.dataLayer.appEnteredForeground();
            this.metricsStore.loadAndSendMetrics();
            this.errorReporter.sendSavedReport();
            if (activity instanceof IntercomRootActivity) {
                IntercomPushClientHandler.Companion.clear((Context)activity);
            }
        }
    }

    @Override
    public void onActivityResumed(Activity activity) {
        this.handler.removeMessages(1, activity);
        this.handler.sendMessage(ActivityLifecycleHandler.getMessage(0, activity));
        this.handleExtras(activity);
    }

    @Override
    public void onActivityPaused(Activity activity) {
        this.handler.sendMessage(ActivityLifecycleHandler.getMessage(2, activity));
    }

    @Override
    public void onActivityStopped(Activity activity) {
        this.unregisterActivity(activity);
        this.handler.removeMessages(1, activity);
        this.handler.sendMessage(ActivityLifecycleHandler.getMessage(3, activity));
        if (this.hasApplicationBecomeBackgrounded(activity)) {
            if (this.resetManager.isSoftReset()) {
                this.resetManager.hardReset();
            }
            long timestamp = this.timeProvider.currentTimeMillis();
            this.dataLayer.emitEvent(new IntercomEvent.AppEnteredBackground(timestamp));
            this.dataLayer.appEnteredBackground(timestamp);
            this.deDuper.reset();
            this.metricsStore.loadAndSendMetrics();
        }
    }

    void registerActivities(Collection<Integer> hashCodes) {
        this.startedActivities.addAll(hashCodes);
    }

    private void registerActivity(Activity activity) {
        this.startedActivities.add(System.identityHashCode(activity));
        this.twig.i("Started observing " + activity, new Object[0]);
    }

    private void unregisterActivity(Activity activity) {
        this.startedActivities.remove(System.identityHashCode(activity));
        this.twig.i("Stopped observing " + activity, new Object[0]);
    }

    private boolean hasApplicationBecomeBackgrounded(Activity activity) {
        return this.isApplicationInBackground(activity) && ((HostAppState)this.dataLayer.getHostAppState().getValue()).isForeground();
    }

    @VisibleForTesting
    boolean isApplicationInBackground(Activity activity) {
        return LifecycleTracker.isScreenLocked((Context)activity) || this.startedActivities.isEmpty() && !activity.isChangingConfigurations();
    }

    private static boolean isScreenLocked(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    private void handleExtras(Activity activity) {
        Intent intent = activity.getIntent();
        if (intent == null) {
            return;
        }
        if (!intent.hasExtra("io.intercom.android.sdk.INTERCOM_PUSH_INSTANCE_ID")) {
            return;
        }
        String instanceId = intent.getStringExtra("io.intercom.android.sdk.INTERCOM_PUSH_INSTANCE_ID");
        if (!TextUtils.isEmpty((CharSequence)instanceId)) {
            this.twig.i("Activity started from Mobile Push: " + activity, new Object[0]);
            this.apiProvider.get().markPushAsOpened(instanceId);
            Injector.get().getMetricTracker().openedPushOnlyNotification(instanceId);
        }
        intent.removeExtra("io.intercom.android.sdk.INTERCOM_PUSH_INSTANCE_ID");
    }
}

