/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.VisibleForTesting;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.m5.data.IntercomEvent;

class ActivityLifecycleHandler
extends Handler {
    static final int RESUMED_CODE = 0;
    static final int READY_FOR_VIEW_CODE = 1;
    static final int PAUSED_CODE = 2;
    static final int STOPPED_CODE = 3;
    private static final int ESTIMATED_ACTIVITY_TRANSITION_DURATION_MS = 500;
    private final long readyForViewDelayMs;
    private final IntercomDataLayer dataLayer;
    private final Twig twig = LumberMill.getLogger();

    ActivityLifecycleHandler(Looper looper, float transitionScale, IntercomDataLayer dataLayer) {
        super(looper);
        this.readyForViewDelayMs = (long)(transitionScale * 500.0f);
        this.dataLayer = dataLayer;
    }

    public void handleMessage(Message msg) {
        Activity activity = (Activity)msg.obj;
        switch (msg.what) {
            case 0: {
                this.sendMessageAfterDelay(ActivityLifecycleHandler.getMessage(1, activity), this.readyForViewDelayMs);
                break;
            }
            case 1: {
                this.twig.i("Ready to show in-app messages in " + activity, new Object[0]);
                this.dataLayer.emitEvent(new IntercomEvent.ActivityReadyForViewAttachment(activity));
                this.dataLayer.activityReadyForViewAttachment(activity);
                break;
            }
            case 2: {
                this.twig.i(activity + " was paused", new Object[0]);
                this.dataLayer.emitEvent(new IntercomEvent.ActivityPaused(activity));
                this.dataLayer.activityPaused(activity);
                break;
            }
            case 3: {
                this.dataLayer.emitEvent(new IntercomEvent.ActivityStopped(activity));
                this.dataLayer.activityStopped(activity);
                break;
            }
        }
    }

    @VisibleForTesting
    void sendMessageAfterDelay(Message message, long delayMs) {
        this.sendMessageDelayed(message, delayMs);
    }

    static Message getMessage(int code, Activity activity) {
        Message message = Message.obtain();
        message.what = code;
        message.obj = activity;
        return message;
    }
}

