/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.content.res.Configuration;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import java.util.Locale;

public class ContextLocaliser {
    private static final String SIMPLIFIED_CHINESE_ISO_15924 = "hans";
    private static final String SIMPLIFIED_CHINESE_COUNTRY = "CN";
    private static final String TRADITIONAL_CHINESE_ISO_15924 = "hant";
    private static final String TRADITIONAL_CHINESE_COUNTRY = "TW";
    private static final String FORMAL_TAG = "form";
    private static final String FAKE_FORMAL_COUNTRY = "FO";
    private static final Twig twig = LumberMill.getLogger();
    private final Provider<AppConfig> appConfigProvider;

    public ContextLocaliser(Provider<AppConfig> appConfigProvider) {
        this.appConfigProvider = appConfigProvider;
    }

    public Context createLocalisedContext(Context context) {
        Configuration localisedConfiguration = new Configuration(context.getResources().getConfiguration());
        Locale newLocale = ContextLocaliser.convertToLocale(this.appConfigProvider.get().getLocale());
        localisedConfiguration.setLocale(newLocale);
        return context.createConfigurationContext(localisedConfiguration);
    }

    public static Locale convertToLocale(String locale) {
        if (locale.length() <= 2) {
            return new Locale(locale);
        }
        String language = locale.substring(0, 2);
        String country = locale.substring(3);
        if (SIMPLIFIED_CHINESE_ISO_15924.equalsIgnoreCase(country)) {
            country = SIMPLIFIED_CHINESE_COUNTRY;
        } else if (TRADITIONAL_CHINESE_ISO_15924.equalsIgnoreCase(country)) {
            country = TRADITIONAL_CHINESE_COUNTRY;
        } else if (FORMAL_TAG.equalsIgnoreCase(country)) {
            country = FAKE_FORMAL_COUNTRY;
        }
        return new Locale(language, country);
    }
}

