/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.push;

import android.app.TaskStackBuilder;
import android.content.Context;
import android.os.Bundle;
import androidx.compose.runtime.internal.StabilityInferred;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.push.IntercomNotificationHandler;
import io.intercom.android.sdk.m5.push.IntercomPushData;
import io.intercom.android.sdk.user.DeviceData;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000  2\u00020\u0001:\u0001 B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ4\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J*\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0016H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006!"}, d2={"Lio/intercom/android/sdk/m5/push/IntercomPushClientHandler;", "", "<init>", "()V", "twig", "Lcom/intercom/twig/Twig;", "kotlin.jvm.PlatformType", "Lcom/intercom/twig/Twig;", "shouldSendDeviceToken", "", "context", "Landroid/content/Context;", "token", "", "sendTokenToIntercom", "", "api", "Lio/intercom/android/sdk/api/Api;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "appConfigProvider", "Lio/intercom/android/sdk/Provider;", "Lio/intercom/android/sdk/identity/AppConfig;", "handlePush", "message", "Landroid/os/Bundle;", "localisedContext", "customStack", "Landroid/app/TaskStackBuilder;", "isIntercomPush", "hasUserHashIfNeeded", "appConfig", "Companion", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
public final class IntercomPushClientHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Twig twig = LumberMill.getLogger();
    public static final int $stable = 8;

    public final boolean shouldSendDeviceToken(@NotNull Context context, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return !DeviceData.hasCachedDeviceToken(context, token);
    }

    public final void sendTokenToIntercom(@NotNull Context context, @NotNull String token, @NotNull Api api, @NotNull UserIdentity userIdentity, @NotNull Provider<AppConfig> appConfigProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter(appConfigProvider, (String)"appConfigProvider");
        if (userIdentity.identityExists()) {
            AppConfig appConfig = appConfigProvider.get();
            Intrinsics.checkNotNullExpressionValue((Object)appConfig, (String)"get(...)");
            if (this.hasUserHashIfNeeded(userIdentity, appConfig)) {
                api.setDeviceToken(token);
            }
        }
        DeviceData.cacheDeviceToken(context, token);
    }

    public final void handlePush(@NotNull Bundle message, @NotNull Context localisedContext, @NotNull UserIdentity userIdentity, @Nullable TaskStackBuilder customStack) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)localisedContext, (String)"localisedContext");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        IntercomPushData intercomPushData = IntercomPushData.Companion.createFrom(localisedContext, message);
        if (intercomPushData == null) {
            this.twig.i("This is not an Intercom push message", new Object[0]);
            return;
        }
        if (!userIdentity.identityExists()) {
            this.twig.i("Can't create push message as we have no user identity. This can be caused by messages being sent to a logged out user.", new Object[0]);
            IntercomNotificationHandler.INSTANCE.clear(localisedContext);
            return;
        }
        IntercomNotificationHandler.processIntercomPushNotification$intercom_sdk_base_release$default(IntercomNotificationHandler.INSTANCE, localisedContext, intercomPushData, customStack, null, 8, null);
    }

    public static /* synthetic */ void handlePush$default(IntercomPushClientHandler intercomPushClientHandler, Bundle bundle, Context context, UserIdentity userIdentity, TaskStackBuilder taskStackBuilder, int n, Object object) {
        if ((n & 8) != 0) {
            taskStackBuilder = null;
        }
        intercomPushClientHandler.handlePush(bundle, context, userIdentity, taskStackBuilder);
    }

    public final boolean isIntercomPush(@NotNull Bundle message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return IntercomPushData.Companion.isIntercomPush(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasUserHashIfNeeded(UserIdentity userIdentity, AppConfig appConfig) {
        if (!appConfig.isReceivedFromServer()) return false;
        if (!appConfig.isIdentityVerificationEnabled()) return true;
        if (!appConfig.isIdentityVerificationEnabled()) return false;
        String string2 = userIdentity.getHmac();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHmac(...)");
        if (StringsKt.isBlank((CharSequence)string2)) return false;
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lio/intercom/android/sdk/m5/push/IntercomPushClientHandler$Companion;", "", "<init>", "()V", "clear", "", "context", "Landroid/content/Context;", "setUpNotificationChannels", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void clear(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            IntercomNotificationHandler.INSTANCE.clear(context);
        }

        public final void setUpNotificationChannels(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            IntercomNotificationHandler.INSTANCE.setUpNotificationChannels$intercom_sdk_base_release(context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

