/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.m5.components.avatar.AvatarShape;
import io.intercom.android.sdk.models.AutoValue_Avatar;
import io.intercom.android.sdk.utilities.NullSafety;
import java.util.Objects;

@AutoValue
public abstract class Avatar
implements Parcelable {
    public static final Avatar NULL = Avatar.create("", "", AvatarShape.CIRCLE, "", "");
    public static final Parcelable.Creator<Avatar> CREATOR = new Parcelable.Creator<Avatar>(){

        public Avatar createFromParcel(Parcel in) {
            String imageUrl = in.readString();
            String initials = in.readString();
            AvatarShape shape = AvatarShape.Companion.fromName(in.readString());
            String label = in.readString();
            String imageDarkUrl = in.readString();
            return Avatar.create(imageUrl, initials, shape, label, imageDarkUrl);
        }

        public Avatar[] newArray(int size) {
            return new Avatar[size];
        }
    };

    public static Avatar create(String imageUrl, String initials, AvatarShape shape, String label, String imageDarkUrl) {
        return new AutoValue_Avatar(imageUrl, initials, shape, label, imageDarkUrl);
    }

    public static Avatar create(String imageUrl, String initials, AvatarShape shape, String label) {
        return new AutoValue_Avatar(imageUrl, initials, shape, label, "");
    }

    public static Avatar create(String imageUrl, String initials, AvatarShape shape) {
        return new AutoValue_Avatar(imageUrl, initials, shape, initials, "");
    }

    public static Avatar create(String imageUrl, String initials) {
        return new AutoValue_Avatar(imageUrl, initials, AvatarShape.CIRCLE, initials, "");
    }

    public abstract String getImageUrl();

    public abstract String getInitials();

    public abstract AvatarShape getShape();

    public abstract String getLabel();

    public abstract String getImageDarkUrl();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getImageUrl());
        dest.writeString(this.getInitials());
        dest.writeString(this.getShape().name());
        dest.writeString(this.getLabel());
        dest.writeString(this.getImageDarkUrl());
    }

    public static final class Builder {
        @Nullable
        String image_url;
        @Nullable
        String image_dark_url;
        @Nullable
        String initials;
        @Nullable
        String square_128;
        @Nullable
        AvatarShape shape;
        @Nullable
        String label;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            return Objects.equals(this.image_url, builder.image_url) && Objects.equals(this.image_dark_url, builder.image_dark_url) && Objects.equals(this.initials, builder.initials) && Objects.equals(this.square_128, builder.square_128) && Objects.equals((Object)this.shape, (Object)builder.shape) && Objects.equals(this.label, builder.label);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.image_url, this.image_dark_url, this.initials, this.square_128, this.shape});
        }

        public Builder withInitials(@Nullable String initials) {
            this.initials = initials;
            return this;
        }

        public Builder withImageUrl(@Nullable String imageUrl) {
            this.image_url = imageUrl;
            return this;
        }

        public Builder withImageDarkUrl(@Nullable String imageDarkUrl) {
            this.image_dark_url = imageDarkUrl;
            return this;
        }

        public Builder withShape(AvatarShape shape) {
            this.shape = shape;
            return this;
        }

        public Avatar build() {
            AvatarShape shape;
            String imageUrl = this.image_url;
            if (this.image_url == null) {
                imageUrl = this.square_128;
            }
            if ((shape = this.shape) == null) {
                shape = AvatarShape.CIRCLE;
            }
            String initials = NullSafety.valueOrEmpty(this.initials);
            String label = this.label == null ? initials : this.label;
            String imageDarkUrl = NullSafety.valueOrEmpty(this.image_dark_url);
            return Avatar.create(NullSafety.valueOrEmpty(imageUrl), initials, shape, label, imageDarkUrl);
        }
    }
}

