/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.UserAttributes;
import io.intercom.android.sdk.logger.LumberMill;

public class Registration {
    private final Twig twig = LumberMill.getLogger();
    private String email = "";
    private String userId = "";
    @Nullable
    private UserAttributes attributes;
    private Validity validity = Validity.NOT_SET;

    public static Registration create() {
        return new Registration();
    }

    public Registration withEmail(@NonNull String email) {
        boolean validEmail;
        boolean bl = validEmail = !TextUtils.isEmpty((CharSequence)email);
        if (validEmail) {
            this.email = email;
        } else {
            this.twig.e("Email cannot be null or empty", new Object[0]);
        }
        this.updateState(validEmail);
        return this;
    }

    public Registration withUserId(@NonNull String userId) {
        boolean validUserId;
        boolean bl = validUserId = !TextUtils.isEmpty((CharSequence)userId);
        if (validUserId) {
            this.userId = userId;
        } else {
            this.twig.e("UserId cannot be null or empty", new Object[0]);
        }
        this.updateState(validUserId);
        return this;
    }

    public Registration withUserAttributes(@NonNull UserAttributes userAttributes) {
        if (userAttributes == null) {
            this.validity = Validity.INVALID;
            this.twig.e("Registration.withUserAttributes method failed: the attributes Map provided is null", new Object[0]);
        } else if (userAttributes.isEmpty()) {
            this.validity = Validity.INVALID;
            this.twig.e("Registration.withUserAttributes method failed: the attributes Map provided is empty", new Object[0]);
        } else {
            this.attributes = userAttributes;
        }
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUserId() {
        return this.userId;
    }

    @Nullable
    public UserAttributes getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Registration that = (Registration)o;
        if (!this.email.equals(that.email)) {
            return false;
        }
        if (!this.userId.equals(that.userId)) {
            return false;
        }
        return this.attributes != null ? this.attributes.equals(that.attributes) : that.attributes == null;
    }

    public int hashCode() {
        int result2 = this.email.hashCode();
        result2 = 31 * result2 + this.userId.hashCode();
        result2 = 31 * result2 + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "Registration{email='" + this.email + '\'' + ", userId='" + this.userId + '\'' + ", attributes=" + this.attributes + '}';
    }

    boolean isValidRegistration() {
        return Validity.VALID.equals((Object)this.validity);
    }

    private void updateState(boolean newState) {
        if (this.validity == Validity.NOT_SET || this.validity == Validity.VALID) {
            this.validity = newState ? Validity.VALID : Validity.INVALID;
        }
    }

    private static enum Validity {
        NOT_SET,
        INVALID,
        VALID;

    }
}

