/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.lib.models;

import android.os.Parcel;
import android.os.Parcelable;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.blocks.lib.models.Link;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LinkList
implements Parcelable {
    private final List<Link> links;
    private final Link footerLink;
    public static final Parcelable.Creator<LinkList> CREATOR = new Parcelable.Creator<LinkList>(){

        public LinkList createFromParcel(Parcel in) {
            ArrayList<Link> links = new ArrayList<Link>();
            in.readList(links, Link.class.getClassLoader());
            Link footerLink = (Link)in.readParcelable(Link.class.getClassLoader());
            return new LinkList(links, footerLink);
        }

        public LinkList[] newArray(int size) {
            return new LinkList[size];
        }
    };

    public LinkList(List<Link> links, Link footerLink) {
        this.links = links;
        this.footerLink = footerLink;
    }

    public static LinkList fromBlock(Block block) {
        if (block == null) {
            return new LinkList(Collections.emptyList(), new Link.Builder().build());
        }
        return new LinkList(block.getLinks(), block.getFooterLink());
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public Link getFooterLink() {
        return this.footerLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkList linkList = (LinkList)o;
        if (!this.links.equals(linkList.links)) {
            return false;
        }
        return this.footerLink.equals(linkList.footerLink);
    }

    public int hashCode() {
        int result2 = this.links.hashCode();
        result2 = 31 * result2 + this.footerLink.hashCode();
        return result2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.links);
        dest.writeParcelable((Parcelable)this.footerLink, flags);
    }
}

