/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.Log;
import androidx.exifinterface.media.ExifInterface;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a \u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0000\u001a \u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u001a$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a8\u0006\u0015"}, d2={"drawableToBitmap", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "defaultWidth", "", "defaultHeight", "calculateInSampleSize", "options", "Landroid/graphics/BitmapFactory$Options;", "reqWidth", "reqHeight", "determineBitmapRotation", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "bitmap", "extractExifData", "", "", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nBitmapUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapUtils.kt\nio/intercom/android/sdk/utilities/BitmapUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1#2:115\n1863#3,2:116\n*S KotlinDebug\n*F\n+ 1 BitmapUtils.kt\nio/intercom/android/sdk/utilities/BitmapUtilsKt\n*L\n98#1:116,2\n*E\n"})
public final class BitmapUtilsKt {
    @NotNull
    public static final Bitmap drawableToBitmap(@NotNull Drawable drawable2, int defaultWidth, int defaultHeight) {
        Bitmap bitmap;
        Bitmap bitmap2;
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        if (drawable2 instanceof BitmapDrawable && ((BitmapDrawable)drawable2).getBitmap() != null) {
            Bitmap bitmap3 = ((BitmapDrawable)drawable2).getBitmap();
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"getBitmap(...)");
            return bitmap3;
        }
        if (drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0) {
            bitmap2 = Bitmap.createBitmap((int)defaultWidth, (int)defaultHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNull((Object)bitmap2);
            bitmap = bitmap2;
        } else {
            bitmap2 = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNull((Object)bitmap2);
            bitmap = bitmap2;
        }
        Bitmap bitmap4 = bitmap;
        Canvas canvas = new Canvas(bitmap4);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap4;
    }

    public static final int calculateInSampleSize(@NotNull BitmapFactory.Options options, int reqWidth, int reqHeight) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        BitmapFactory.Options $this$calculateInSampleSize_u24lambda_u240 = options;
        boolean bl = false;
        Pair pair = TuplesKt.to((Object)$this$calculateInSampleSize_u24lambda_u240.outHeight, (Object)$this$calculateInSampleSize_u24lambda_u240.outWidth);
        int height = ((Number)pair.component1()).intValue();
        int width = ((Number)pair.component2()).intValue();
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    @NotNull
    public static final Bitmap determineBitmapRotation(@NotNull Context context, @NotNull Uri uri, @NotNull Bitmap bitmap) {
        InputStream rotatedBitmap;
        block9: {
            InputStream inputStream;
            InputStream input;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                    Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                    input = context.getContentResolver().openInputStream(uri);
                    inputStream = input;
                    if (inputStream == null) break block7;
                    InputStream it = inputStream;
                    boolean bl = false;
                    ExifInterface exif = new ExifInterface(it);
                    int orientation = exif.getAttributeInt("Orientation", 0);
                    Matrix matrix = new Matrix();
                    switch (orientation) {
                        case 6: {
                            matrix.postRotate(90.0f);
                            break;
                        }
                        case 3: {
                            matrix.postRotate(180.0f);
                            break;
                        }
                        case 8: {
                            matrix.postRotate(270.0f);
                        }
                    }
                    Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                    inputStream = bitmap2;
                    if (bitmap2 != null) break block8;
                }
                inputStream = bitmap;
            }
            rotatedBitmap = inputStream;
            InputStream inputStream2 = input;
            if (inputStream2 == null) break block9;
            inputStream2.close();
        }
        return rotatedBitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Map<String, String> extractExifData(@NotNull Context context, @NotNull Uri uri) {
        Map exifData;
        block9: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            exifData = new LinkedHashMap();
            try {
                InputStream inputStream = context.getContentResolver().openInputStream(uri);
                if (inputStream == null) break block9;
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream inputStream2 = (InputStream)closeable;
                    boolean bl = false;
                    ExifInterface exif = new ExifInterface(inputStream2);
                    Object[] objectArray = new String[]{"DateTime", "DateTimeOriginal", "DateTimeDigitized"};
                    List tagsToExtract = CollectionsKt.listOf((Object[])objectArray);
                    Iterable $this$forEach$iv = tagsToExtract;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String value;
                        String tag = (String)element$iv;
                        boolean bl2 = false;
                        if (exif.getAttribute(tag) == null) continue;
                        boolean bl3 = false;
                        if (!(((CharSequence)value).length() > 0)) continue;
                        exifData.put(tag, value);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                Log.w((String)"ExifExtractor", (String)("Failed to extract EXIF data: " + e.getMessage()));
            }
            catch (NullPointerException e) {
                Log.w((String)"ExifExtractor", (String)("Failed to extract EXIF data (null pointer): " + e.getMessage()));
            }
        }
        return exifData;
    }
}

