/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import androidx.compose.ui.platform.ComposeView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.ButtonClickListener;
import io.intercom.android.sdk.blocks.ImageClickListener;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.blocks.lib.Blocks;
import io.intercom.android.sdk.blocks.lib.BlocksViewHolder;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.notification.ChatFullNotificationKt;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.overlay.ChatNotification;
import io.intercom.android.sdk.overlay.ComposeCompatibilityUtilKt;
import io.intercom.android.sdk.overlay.InAppNotification;

class ChatFull
extends ChatNotification {
    private final MetricTracker metricTracker;
    private final Activity activity;

    ChatFull(Context localisedContext, Conversation conversation, int position, int screenHeight, InAppNotification.Listener listener2, MetricTracker metricTracker, Provider<AppConfig> appConfigProvider, Activity activity) {
        super(localisedContext, conversation, position, screenHeight, listener2, appConfigProvider);
        this.metricTracker = metricTracker;
        this.activity = activity;
    }

    @Override
    protected ViewGroup inflateChatRootView(ViewGroup parent, LayoutInflater inflater) {
        final ViewGroup root = (ViewGroup)inflater.inflate(R.layout.intercom_preview_chat_full_overlay, parent, false);
        ComposeView composeView = (ComposeView)root.findViewById(R.id.chat_full_compose_view);
        if (ComposeCompatibilityUtilKt.hideForLegacyActivity(composeView)) {
            Blocks blocks2 = new Blocks(this.localisedContext, LumberMill.getBlocksTwig());
            Injector injector = Injector.get();
            Api api = injector.getApi();
            ViewHolderGenerator generator = new ViewHolderGenerator(new UploadingImageCache(), api, this.appConfigProvider, this.conversation.getId(), new ChatFullImageClickListener(), new ChatFullButtonClickListener(), injector.getGson(), this.metricTracker);
            BlocksViewHolder chatFullHolder = generator.getChatFullHolder();
            LinearLayout renderedBlocks = blocks2.createBlocks(this.conversation.lastPart().getBlocks(), chatFullHolder);
            final ViewGroup blockContainer = (ViewGroup)root.findViewById(R.id.chathead_text_container);
            blockContainer.addView((View)renderedBlocks);
            blockContainer.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    blockContainer.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    int blockContentHeight = blockContainer.getMeasuredHeight();
                    int bottomMargin = ((ViewGroup.MarginLayoutParams)blockContainer.getLayoutParams()).bottomMargin;
                    Resources res = ChatFull.this.localisedContext.getResources();
                    int topMargin = res.getDimensionPixelSize(R.dimen.intercom_chat_full_top_margin);
                    int bottomPadding = res.getDimensionPixelSize(R.dimen.intercom_bottom_padding);
                    int availableContentSpace = ChatFull.this.screenHeight - topMargin - bottomMargin - bottomPadding;
                    if (blockContentHeight >= availableContentSpace) {
                        View fade = root.findViewById(R.id.chat_overlay_overflow_fade);
                        fade.setVisibility(0);
                        return false;
                    }
                    return true;
                }
            });
            api.markConversationAsRead(this.conversation.getId());
        } else {
            ChatFullNotificationKt.addChatFullNotificationToView(composeView, this.conversation, (AppConfig)this.appConfigProvider.get());
        }
        this.metricTracker.viewedInApp(this.conversation.getId(), this.conversation.lastPart().getId(), 1);
        return root;
    }

    @Override
    protected View getContentContainer() {
        ComposeView composeView = (ComposeView)this.overlayRoot.findViewById(R.id.chat_full_compose_view);
        if (composeView != null && composeView.getVisibility() == 0) {
            return composeView;
        }
        return ((ViewGroup)this.overlayRoot.findViewById(R.id.chathead_text_container)).getChildAt(0);
    }

    @Override
    protected void updateContentContainer(Part part) {
    }

    @Override
    public void update(Conversation conversation, Runnable updateEndAction) {
        this.conversation = conversation;
        updateEndAction.run();
    }

    @Override
    void populateViewsWithData() {
        ComposeView chatFullComposeView = (ComposeView)this.overlayRoot.findViewById(R.id.chat_full_compose_view);
        if (!ComposeCompatibilityUtilKt.hideForLegacyActivity(chatFullComposeView)) {
            ChatFullNotificationKt.addChatFullNotificationToView(chatFullComposeView, this.conversation, (AppConfig)this.appConfigProvider.get());
        }
    }

    @Override
    protected void updateViewDataDuringReplyPulse(int bottomPadding) {
    }

    private static class ChatFullImageClickListener
    implements ImageClickListener {
        private ChatFullImageClickListener() {
        }

        @Override
        public void onImageClicked(String imageUrl, String linkUrl, View imageView, int width, int height) {
        }
    }

    private static class ChatFullButtonClickListener
    implements ButtonClickListener {
        private ChatFullButtonClickListener() {
        }

        @Override
        public void onButtonClicked(View view, String url) {
        }

        @Override
        public boolean shouldHandleClicks() {
            return false;
        }
    }
}

