/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.user;

import androidx.compose.runtime.internal.StabilityInferred;
import io.intercom.android.sdk.IntercomStatusCallbackKt;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.api.UserUpdater;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.models.HostAppState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0001\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\b0\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00040\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lio/intercom/android/sdk/user/UserUpdaterHelper;", "", "userUpdaterProvider", "Lio/intercom/android/sdk/Provider;", "Lio/intercom/android/sdk/api/UserUpdater;", "dataLayer", "Lio/intercom/android/sdk/m5/data/IntercomDataLayer;", "userIdentityProvider", "Lio/intercom/android/sdk/identity/UserIdentity;", "<init>", "(Lio/intercom/android/sdk/Provider;Lio/intercom/android/sdk/m5/data/IntercomDataLayer;Lio/intercom/android/sdk/Provider;)V", "userIdentity", "kotlin.jvm.PlatformType", "getUserIdentity", "()Lio/intercom/android/sdk/identity/UserIdentity;", "userUpdater", "getUserUpdater", "()Lio/intercom/android/sdk/api/UserUpdater;", "update", "", "currentTime", "", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
public final class UserUpdaterHelper {
    @NotNull
    private final Provider<UserUpdater> userUpdaterProvider;
    @NotNull
    private final IntercomDataLayer dataLayer;
    @NotNull
    private final Provider<UserIdentity> userIdentityProvider;
    public static final int $stable = 8;

    public UserUpdaterHelper(@NotNull Provider<UserUpdater> userUpdaterProvider, @NotNull IntercomDataLayer dataLayer, @NotNull Provider<UserIdentity> userIdentityProvider) {
        Intrinsics.checkNotNullParameter(userUpdaterProvider, (String)"userUpdaterProvider");
        Intrinsics.checkNotNullParameter((Object)dataLayer, (String)"dataLayer");
        Intrinsics.checkNotNullParameter(userIdentityProvider, (String)"userIdentityProvider");
        this.userUpdaterProvider = userUpdaterProvider;
        this.dataLayer = dataLayer;
        this.userIdentityProvider = userIdentityProvider;
    }

    public final UserIdentity getUserIdentity() {
        return this.userIdentityProvider.get();
    }

    public final UserUpdater getUserUpdater() {
        return this.userUpdaterProvider.get();
    }

    public final void update(long currentTime) {
        HostAppState hostAppState = (HostAppState)this.dataLayer.getHostAppState().getValue();
        long timeSinceBackgrounded = currentTime - hostAppState.getBackgroundedTimestamp();
        if (timeSinceBackgrounded > ((AppConfig)this.dataLayer.getConfig().getValue()).getNewSessionThresholdMs() && this.getUserIdentity().identityExists() && !hostAppState.getSessionStartedSinceLastBackgrounded()) {
            boolean isBackgrounded = hostAppState.isBackgrounded();
            UserUpdateRequest userUpdateRequest = UserUpdateRequest.create(true, isBackgrounded, true);
            this.getUserUpdater().updateUser(userUpdateRequest, IntercomStatusCallbackKt.getNoStatusCallback());
        }
    }
}

