/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomCarouselActivity;
import io.intercom.android.sdk.activities.IntercomNoteActivity;
import io.intercom.android.sdk.activities.IntercomPostActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.ConversationScreenOpenerKt;
import io.intercom.android.sdk.m5.IntercomRootActivity;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.m5.data.IntercomEvent;
import io.intercom.android.sdk.m5.navigation.IntercomRootActivityArgs;
import io.intercom.android.sdk.m5.navigation.IntercomRootActivityArgsKt;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.DeliveryOption;
import io.intercom.android.sdk.models.MessageStyle;
import io.intercom.android.sdk.models.OverlayState;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.carousel.Carousel;
import io.intercom.android.sdk.overlay.DefaultLauncher;
import io.intercom.android.sdk.overlay.DefaultLauncherPresenter;
import io.intercom.android.sdk.overlay.InAppNotificationPresenter;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;
import io.intercom.android.sdk.survey.model.SurveyData;
import io.intercom.android.sdk.survey.ui.IntercomSurveyActivity;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import io.intercom.android.sdk.utilities.ViewUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;

public class OverlayPresenter
implements InAppNotificationPresenter.Listener {
    final DefaultLauncherPresenter launcherPresenter;
    final InAppNotificationPresenter inAppNotificationPresenter;
    private final MetricTracker metricTracker;
    private final Provider<AppConfig> appConfigProvider;
    private final Handler handler;
    private final UserIdentity userIdentity;
    private final Twig twig = LumberMill.getLogger();
    private final Set<String> viewedPartIds = new HashSet<String>();
    private final IntercomDataLayer intercomDataLayer;
    private final Provider<Api> api;

    public OverlayPresenter(Application application, Provider<AppConfig> appConfigProvider, MetricTracker metricTracker, UserIdentity userIdentity, IntercomDataLayer dataLayer, Provider<Api> api) {
        this.appConfigProvider = appConfigProvider;
        this.metricTracker = metricTracker;
        this.userIdentity = userIdentity;
        this.intercomDataLayer = dataLayer;
        this.api = api;
        LayoutInflater inflater = LayoutInflater.from((Context)application);
        this.handler = new Handler(Looper.getMainLooper());
        this.inAppNotificationPresenter = new InAppNotificationPresenter(inflater, this.handler, this, metricTracker, appConfigProvider, new ContextLocaliser(appConfigProvider), this.hostActivity());
        this.launcherPresenter = new DefaultLauncherPresenter(inflater, new LauncherOpenBehaviour(), metricTracker);
        CoroutineScope mainScope = CoroutineScopeKt.MainScope();
        dataLayer.unreadConversationIdsUpdates(mainScope, (Function1<? super Set<String>, Unit>)((Function1)unreadConversationIds -> {
            OverlayState overlayState = (OverlayState)this.intercomDataLayer.getOverlayState().getValue();
            this.onStateChange(unreadConversationIds.size(), overlayState);
            return Unit.INSTANCE;
        }));
        dataLayer.configUpdates(mainScope, (Function1<? super AppConfig, Unit>)((Function1)config -> {
            this.onNewConfig();
            return Unit.INSTANCE;
        }));
        dataLayer.overlayStateUpdates(mainScope, (Function1<? super OverlayState, Unit>)((Function1)overlayState -> {
            Integer unreadCount = ((Set)this.intercomDataLayer.getUnreadConversationIds().getValue()).size();
            this.onStateChange(unreadCount, (OverlayState)overlayState);
            return Unit.INSTANCE;
        }));
        dataLayer.listenToEvents(mainScope, (Function1<? super IntercomEvent, Unit>)((Function1)event -> {
            this.handleLifecycleEvents((IntercomEvent)event);
            return Unit.INSTANCE;
        }));
    }

    @VisibleForTesting
    void handleLifecycleEvents(IntercomEvent event) {
        OverlayState oldState = (OverlayState)this.intercomDataLayer.getOverlayState().getValue();
        Activity oldPausedActivity = oldState.getPausedHostActivity();
        Activity oldResumedActivity = oldState.getResumedHostActivity();
        if (event instanceof IntercomEvent.ActivityReadyForViewAttachment) {
            Activity resumedActivity = ((IntercomEvent.ActivityReadyForViewAttachment)event).getActivity();
            if (resumedActivity != oldPausedActivity) {
                this.removeOverlays(oldPausedActivity);
            }
        } else if (event instanceof IntercomEvent.ActivityPaused) {
            this.removeOverlays(oldPausedActivity);
        } else if (event instanceof IntercomEvent.ActivityStopped) {
            Activity stoppedActivity = ((IntercomEvent.ActivityStopped)event).getActivity();
            if (stoppedActivity == oldPausedActivity) {
                this.removeOverlays(oldPausedActivity);
            }
        } else if (event instanceof IntercomEvent.AppEnteredBackground) {
            this.cancelAnimations();
            this.removeOverlays(oldPausedActivity);
            this.removeOverlays(oldResumedActivity);
        }
    }

    public void onStateChange(Integer unreadCount, OverlayState overlayState) {
        Activity activity = overlayState.getResumedHostActivity();
        List<Conversation> conversations = overlayState.getConversations();
        SurveyData survey = overlayState.getSurveyData();
        Carousel carousel = overlayState.getCarousel();
        int bottomPadding = overlayState.getBottomPadding();
        Intercom.Visibility launcherVisibility = overlayState.getLauncherVisibility();
        Intercom.Visibility inAppNotificationsVisibility = overlayState.getInAppNotificationsVisibility();
        this.launcherPresenter.setBottomPadding(bottomPadding);
        this.launcherPresenter.setUnreadCount(unreadCount);
        this.inAppNotificationPresenter.setBottomPadding(bottomPadding);
        if (activity == null || activity.isFinishing() || activity.isDestroyed()) {
            return;
        }
        if (this.shouldDisplaySurvey(survey, activity)) {
            this.openSurvey(activity);
        } else if (this.shouldDisplayCarousel(carousel, activity)) {
            this.openCarousel(activity);
        } else if (this.shouldDisplayNotifications(conversations, inAppNotificationsVisibility, activity)) {
            this.preloadAvatarThenDisplayNotifications(conversations, inAppNotificationsVisibility, activity, this.userIdentity.getFingerprint());
        } else if (this.shouldDisplayLauncher(conversations, inAppNotificationsVisibility, launcherVisibility, activity)) {
            ViewGroup root = this.getRootView(activity);
            ViewUtils.waitForViewAttachment((View)root, () -> {
                this.inAppNotificationPresenter.reset(root);
                this.launcherPresenter.displayLauncherOnAttachedRoot(root, this.appConfigProvider.get());
            });
        } else {
            this.removeOverlaysIfPresent(activity);
        }
    }

    public void softReset() {
        this.cancelAnimations();
        Activity hostActivity = this.hostActivity();
        if (hostActivity != null) {
            this.removeOverlaysIfPresent(hostActivity);
        }
    }

    public void onNewConfig() {
        Activity hostActivity;
        Intercom.Visibility launcherVisibility = ((OverlayState)this.intercomDataLayer.getOverlayState().getValue()).getLauncherVisibility();
        Intercom.Visibility inAppNotificationsVisibility = ((OverlayState)this.intercomDataLayer.getOverlayState().getValue()).getInAppNotificationsVisibility();
        List<Conversation> conversations = ((OverlayState)this.intercomDataLayer.getOverlayState().getValue()).getConversations();
        if (this.shouldDisplayLauncher(conversations, inAppNotificationsVisibility, launcherVisibility, hostActivity = ((OverlayState)this.intercomDataLayer.getOverlayState().getValue()).getResumedHostActivity())) {
            ViewGroup root = this.getRootView(hostActivity);
            ViewUtils.waitForViewAttachment((View)root, () -> this.launcherPresenter.displayLauncherOnAttachedRoot(root, this.appConfigProvider.get()));
        } else {
            this.launcherPresenter.setLauncherBackgroundColor(this.appConfigProvider.get());
        }
    }

    public void cancelAnimations() {
        this.handler.removeCallbacksAndMessages(null);
    }

    public void removeOverlaysIfPresent(Activity activity) {
        View root = activity.findViewById(R.id.intercom_overlay_root);
        activity.runOnUiThread(() -> {
            if (root != null) {
                this.launcherPresenter.removeLauncher();
                this.inAppNotificationPresenter.reset((ViewGroup)root);
                if (root.getParent() != null) {
                    ((ViewGroup)root.getParent()).removeView(root);
                }
            }
        });
    }

    void preloadAvatarThenDisplayNotifications(List<Conversation> conversations, Intercom.Visibility notificationVisibility, Activity activity, String fingerprint) {
        AvatarUtils.preloadAvatar(conversations.get(0).lastAdmin().getAvatar(), () -> {
            if (fingerprint.equals(this.userIdentity.getFingerprint()) && this.shouldDisplayNotifications(conversations, notificationVisibility, activity)) {
                this.displayNotifications(conversations, activity);
            }
        }, activity);
    }

    void displayNotifications(final List<Conversation> conversations, Activity activity) {
        final ViewGroup rootView = this.getRootView(activity);
        Conversation conversation = conversations.get(0);
        MessageStyle messageStyle = conversation.lastPart().getMessageStyle();
        DeliveryOption deliveryOption = conversation.lastPart().getDeliveryOption();
        if (conversations.size() > 1 || this.inAppNotificationPresenter.isDisplaying() || deliveryOption == DeliveryOption.SUMMARY || deliveryOption == DeliveryOption.FULL && MessageStyle.CHAT.equals((Object)messageStyle)) {
            if (this.launcherPresenter.isDisplaying()) {
                final DefaultLauncher defaultLauncher = this.launcherPresenter.getAndUnsetLauncher();
                if (conversations.size() == 1) {
                    defaultLauncher.pulseForTransformation((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            defaultLauncher.fadeOffScreen((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                public void onAnimationEnd(Animator animation) {
                                    defaultLauncher.removeView();
                                }
                            });
                            OverlayPresenter.this.inAppNotificationPresenter.displayNotifications(rootView, conversations);
                        }
                    });
                } else {
                    defaultLauncher.fadeOffScreen((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            defaultLauncher.removeView();
                            OverlayPresenter.this.inAppNotificationPresenter.displayNotifications(rootView, conversations);
                        }
                    });
                }
            } else {
                this.inAppNotificationPresenter.displayNotifications(rootView, conversations);
            }
        } else if (deliveryOption == DeliveryOption.FULL) {
            if (MessageStyle.POST.equals((Object)messageStyle)) {
                this.trackInAppView(conversation.getId(), conversation.lastPart().getId(), 1);
                this.openPost(conversation);
            } else if (MessageStyle.NOTE.equals((Object)messageStyle)) {
                this.trackInAppView(conversation.getId(), conversation.lastPart().getId(), 1);
                this.openNote(conversation);
            }
        }
    }

    @Override
    public ViewGroup getRootView() {
        Activity activity = this.hostActivity();
        if (activity == null) {
            throw new NullPointerException();
        }
        return this.getRootView(activity);
    }

    private ViewGroup getRootView(Activity activity) {
        ViewGroup root = (ViewGroup)activity.findViewById(R.id.intercom_overlay_root);
        if (root == null) {
            root = new FrameLayout((Context)activity);
            root.setClipChildren(false);
            root.setClipToPadding(false);
            root.setFitsSystemWindows(true);
            root.setId(R.id.intercom_overlay_root);
            activity.addContentView((View)root, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 80));
        }
        return root;
    }

    @Override
    public void markAsDismissed(Conversation conversation) {
        this.api.get().markConversationAsDismissed(conversation.getId());
        this.intercomDataLayer.markConversationPartAsDismissed(conversation.lastPart().getId());
    }

    @Override
    public void openNotification(Conversation conversation) {
        Part lastPart = conversation.getLastAdminPart();
        MessageStyle messageStyle = lastPart.getMessageStyle();
        if (MessageStyle.POST.equals((Object)messageStyle)) {
            this.trackInAppView(conversation.getId(), conversation.lastPart().getId(), 0);
            this.openPost(conversation);
        } else if (MessageStyle.NOTE.equals((Object)messageStyle)) {
            this.trackInAppView(conversation.getId(), conversation.lastPart().getId(), 0);
            this.openNote(conversation);
        } else {
            this.openMessenger(conversation);
            if (MessageStyle.CHAT.equals((Object)messageStyle) && DeliveryOption.FULL == lastPart.getDeliveryOption()) {
                this.metricTracker.openedConversationFromFull(conversation.getId(), lastPart.getId());
            } else {
                this.metricTracker.openedConversationFromSnippet(conversation.getId(), lastPart.getId());
            }
        }
    }

    private void openMessenger(Conversation conversation) {
        Activity activity = this.hostActivity();
        if (activity != null) {
            ArrayList<Intent> intents = new ArrayList<Intent>();
            Intent conversationIntent = ConversationScreenOpenerKt.getConversationIntent((Context)activity, conversation.getId());
            Intent inboxIntent = IntercomRootActivityArgsKt.getIntentForArgs((Context)activity, IntercomRootActivityArgs.MessagesScreenArgs.INSTANCE, IntercomRootActivity.class, 0x10000000);
            intents.add(inboxIntent);
            intents.add(conversationIntent);
            activity.startActivities(intents.toArray(new Intent[0]));
        }
    }

    private void openPost(Conversation conversation) {
        Activity activity = this.hostActivity();
        if (activity != null) {
            activity.startActivity(IntercomPostActivity.buildPostIntent((Context)activity, conversation.lastPart(), conversation.getId(), conversation.lastParticipatingAdmin(), conversation.getComposerState().isVisible(), true));
        }
    }

    private void openNote(Conversation conversation) {
        try {
            Activity activity = this.hostActivity();
            if (activity != null) {
                activity.startActivity(IntercomNoteActivity.buildNoteIntent((Context)activity, conversation.lastPart(), conversation.getId(), conversation.lastParticipatingAdmin(), conversation.getComposerState().isVisible()));
            }
        }
        catch (IllegalArgumentException e) {
            this.twig.internal("Overlay", "Error loading the note " + e.getMessage());
        }
    }

    private void openSurvey(@NonNull Activity activity) {
        activity.startActivity(IntercomSurveyActivity.buildIntent((Context)activity));
    }

    private void openCarousel(@NonNull Activity activity) {
        activity.startActivity(new Intent((Context)activity, IntercomCarouselActivity.class));
    }

    @Nullable
    private Activity hostActivity() {
        return ((OverlayState)this.intercomDataLayer.getOverlayState().getValue()).getResumedHostActivity();
    }

    private void trackInAppView(String conversationId2, String partId, @MetricTracker.InAppMessageViewContext int context) {
        if (this.viewedPartIds.contains(partId)) {
            return;
        }
        this.viewedPartIds.add(partId);
        this.metricTracker.viewedInApp(conversationId2, partId, context);
    }

    @VisibleForTesting
    boolean shouldDisplaySurvey(SurveyData survey, @Nullable Activity hostActivity) {
        return !SurveyData.Companion.getNULL().equals(survey) && !this.userIdentity.isSoftReset() && hostActivity != null;
    }

    @VisibleForTesting
    boolean shouldDisplayCarousel(Carousel carousel, @Nullable Activity hostActivity) {
        return !Carousel.NULL.equals(carousel) && !this.userIdentity.isSoftReset() && hostActivity != null;
    }

    boolean shouldDisplayNotifications(List<Conversation> conversations, Intercom.Visibility notificationVisibility, @Nullable Activity hostActivity) {
        return notificationVisibility == Intercom.Visibility.VISIBLE && !this.userIdentity.isSoftReset() && !conversations.isEmpty() && hostActivity != null;
    }

    boolean shouldDisplayLauncher(List<Conversation> conversations, Intercom.Visibility notificationVisibility, Intercom.Visibility launcherVisibility, @Nullable Activity hostActivity) {
        if (notificationVisibility == Intercom.Visibility.VISIBLE) {
            for (Conversation c : conversations) {
                if (DeliveryOption.BADGE == c.lastPart().getDeliveryOption()) continue;
                return false;
            }
        }
        return launcherVisibility == Intercom.Visibility.VISIBLE && !this.userIdentity.isSoftReset() && this.userIdentity.identityExists() && this.appConfigProvider.get().isReceivedFromServer() && hostActivity != null;
    }

    public void refreshStateBecauseUserIdentityIsNotInStoreYet() {
        Integer unreadCount = ((Set)this.intercomDataLayer.getUnreadConversationIds().getValue()).size();
        OverlayState overlayState = (OverlayState)this.intercomDataLayer.getOverlayState().getValue();
        this.onStateChange(unreadCount, overlayState);
    }

    private void removeOverlays(@Nullable Activity activity) {
        if (activity != null) {
            this.removeOverlaysIfPresent(activity);
        }
    }
}

