/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.models.BlockAttachment;
import io.intercom.android.sdk.utilities.IntentUtils;
import io.intercom.android.sdk.utilities.commons.ScreenUtils;

@SuppressLint(value={"ViewConstructor"})
public class AttachmentView
extends LinearLayout
implements View.OnClickListener {
    static final int ATTACHMENT_ICON_WIDTH_DP = 20;
    static final int DIVIDER_MARGIN_DP = 6;
    static final int DIVIDER_WIDTH_DP = 1;
    private final String url;

    public AttachmentView(Context context, StyleType style, @ColorInt int baseColour, BlockAttachment attachment) {
        super(context);
        this.url = attachment.getUrl();
        this.setOrientation(0);
        ImageView attachmentIcon = this.setupIcon(context, style, baseColour);
        this.addView((View)attachmentIcon);
        if (this.isUserMessage(style)) {
            View divider = this.setupDivider(context);
            this.addView(divider);
        }
        TextView attachmentName = this.setupName(context, style, baseColour, attachment.getName());
        this.addView((View)attachmentName);
    }

    private ImageView setupIcon(Context context, StyleType style, int baseColour) {
        ImageView divider = new ImageView(context);
        int width = ScreenUtils.dpToPx(20.0f, context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, -2);
        params.gravity = 8388627;
        divider.setLayoutParams((ViewGroup.LayoutParams)params);
        divider.setImageResource(R.drawable.intercom_icn_attachment);
        if (!this.isUserMessage(style)) {
            divider.setColorFilter(baseColour);
        }
        return divider;
    }

    private View setupDivider(Context context) {
        View divider = new View(context);
        int width = ScreenUtils.dpToPx(1.0f, context);
        int margin = ScreenUtils.dpToPx(6.0f, context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, -1);
        params.setMargins(margin, 0, margin, 0);
        divider.setLayoutParams((ViewGroup.LayoutParams)params);
        divider.setBackgroundResource(R.color.intercom_white);
        return divider;
    }

    private TextView setupName(Context context, StyleType style, int baseColour, String name) {
        TextView divider = new TextView(context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 8388627;
        divider.setLayoutParams((ViewGroup.LayoutParams)params);
        divider.setEllipsize(TextUtils.TruncateAt.END);
        divider.setBackgroundResource(R.color.intercom_full_transparent_full_black);
        divider.setGravity(8388627);
        divider.setTextSize(15.0f);
        divider.setText((CharSequence)name);
        divider.setOnClickListener((View.OnClickListener)this);
        if (this.isUserMessage(style)) {
            divider.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_white));
        } else {
            divider.setTextColor(baseColour);
        }
        return divider;
    }

    public void onClick(View v) {
        Uri uri = Uri.parse((String)this.url);
        if (!Uri.EMPTY.equals((Object)uri)) {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.setFlags(0x10000000);
            IntentUtils.safelyOpenIntent(this.getContext(), intent);
        }
    }

    private boolean isUserMessage(StyleType style) {
        return StyleType.PREVIEW == style || StyleType.USER == style;
    }
}

