/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.BlockAlignment;
import io.intercom.android.sdk.blocks.lib.interfaces.VideoFileBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.blocks.views.ParagraphView;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.utilities.AccessibilityUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.commons.HtmlCompat;
import io.intercom.android.sdk.utilities.commons.ScreenUtils;

public class VideoFile
implements VideoFileBlock {
    private final StyleType style;
    private final Provider<AppConfig> appConfigProvider;
    private final MetricTracker metricTracker;
    private static final int PLAY_BUTTON_DIAMETER_DP = 36;
    private static final int PLAY_ARROW_OFFSET_DP = 3;

    VideoFile(StyleType style2, Provider<AppConfig> appConfigProvider, MetricTracker metricTracker) {
        this.style = style2;
        this.appConfigProvider = appConfigProvider;
        this.metricTracker = metricTracker;
    }

    @Override
    public View addVideoFile(String text, String videoUrl, String thumbnailUrl, BlockMetadata blockMetadata, ViewGroup parent) {
        if (TextUtils.isEmpty((CharSequence)videoUrl)) {
            return this.textFallback(text, parent);
        }
        RelativeLayout relativeLayout = new RelativeLayout(parent.getContext());
        WebView webView = new WebView(parent.getContext());
        BlockUtils.createLayoutParams((View)webView, -1, 480);
        BlockUtils.setMarginBottom((View)webView, 16);
        webView.setWebChromeClient(new WebChromeClient());
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setMediaPlaybackRequiresUserGesture(true);
        webView.loadUrl(thumbnailUrl);
        ImageView playButtonView = this.getPlayButtonView(parent.getContext());
        playButtonView.setOnClickListener(view -> {
            playButtonView.setVisibility(8);
            webView.loadUrl(videoUrl);
        });
        relativeLayout.addView((View)webView);
        relativeLayout.addView((View)playButtonView);
        return relativeLayout;
    }

    private View textFallback(String text, ViewGroup parent) {
        ParagraphView textView = new ParagraphView(parent.getContext(), StyleType.ADMIN, BlockAlignment.LEFT, this.appConfigProvider.get());
        textView.setText((CharSequence)HtmlCompat.fromHtml(text));
        return textView;
    }

    private ImageView getPlayButtonView(Context context) {
        int diameterPx = ScreenUtils.dpToPx(36.0f, context);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(diameterPx, diameterPx);
        params.addRule(13);
        ImageView playButton = new ImageView(context);
        playButton.setLayoutParams((ViewGroup.LayoutParams)params);
        playButton.setScaleType(ImageView.ScaleType.CENTER);
        playButton.setImageResource(R.drawable.intercom_play_arrow);
        playButton.setPadding(ScreenUtils.dpToPx(3.0f, context), 0, 0, 0);
        playButton.setBackgroundResource(R.drawable.intercom_solid_circle);
        playButton.setVisibility(0);
        playButton.setId(R.id.intercom_video_thumbnail_play_button);
        AccessibilityUtils.INSTANCE.addClickAbilityAnnouncement((View)playButton);
        return playButton;
    }
}

