/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0003H\u0000\u00a8\u0006\n"}, d2={"getRegionCode", "", "context", "Landroid/content/Context;", "id", "getServerRegionFromManifest", "readHostFromManifest", "", "getLocaleCompat", "Ljava/util/Locale;", "intercom-sdk-base_release"})
public final class UtilsKt {
    @Nullable
    public static final String readHostFromManifest(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String host = null;
        try {
            Bundle bundle;
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.packageManager.g\u2026.GET_META_DATA,\n        )");
            ApplicationInfo app = applicationInfo;
            Bundle bundle2 = bundle = app.metaData;
            host = bundle2 != null ? bundle2.getString("io.intercom.android.sdk.host") : null;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return host;
    }

    public static final int getServerRegionFromManifest(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.packageManager.g\u2026ager.GET_META_DATA,\n    )");
        ApplicationInfo app = applicationInfo;
        Bundle bundle = app.metaData;
        return bundle != null ? bundle.getInt("io.intercom.android.sdk.server.region") : 0;
    }

    public static final int getRegionCode(@NotNull Context context, int id2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getInteger(id2);
    }

    @NotNull
    public static final Locale getLocaleCompat(@NotNull Context $this$getLocaleCompat) {
        Locale locale;
        Intrinsics.checkNotNullParameter((Object)$this$getLocaleCompat, (String)"<this>");
        Configuration configuration = $this$getLocaleCompat.getApplicationContext().getResources().getConfiguration();
        if (Build.VERSION.SDK_INT >= 24) {
            Locale locale2 = configuration.getLocales().get(0);
            locale = locale2;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"{\n        configuration.locales[0]\n    }");
        } else {
            Locale locale3 = configuration.locale;
            locale = locale3;
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"{\n        configuration.locale\n    }");
        }
        return locale;
    }
}

