/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.tickets;

import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.components.avatar.AvatarWrapper;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.tickets.ConversationButtonState;
import io.intercom.android.sdk.tickets.TicketDetailState;
import io.intercom.android.sdk.tickets.TicketLaunchedFrom;
import io.intercom.android.sdk.tickets.TicketStatus;
import io.intercom.android.sdk.tickets.TicketTimelineCardState;
import io.intercom.android.sdk.ui.common.StringProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u0011\u001a\u00020\f*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\f*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0000\u001a\f\u0010\u0015\u001a\u00020\f*\u00020\u0016H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0012*\u00020\u0018H\u0000\u00a8\u0006\u0019"}, d2={"computeTicketViewState", "Lio/intercom/android/sdk/tickets/TicketDetailState$TicketDetailContentState;", "ticket", "Lio/intercom/android/sdk/models/Ticket;", "user", "Lio/intercom/android/sdk/identity/UserIdentity;", "activeAdminsAvatars", "", "Lio/intercom/android/sdk/m5/components/avatar/AvatarWrapper;", "launchedFrom", "Lio/intercom/android/sdk/tickets/TicketLaunchedFrom;", "isConversationalMessenger", "", "conversationButtonState", "Lio/intercom/android/sdk/tickets/ConversationButtonState;", "conversationButton", "Lio/intercom/android/sdk/models/Ticket$ConversationButton;", "isDone", "Lio/intercom/android/sdk/tickets/TicketStatus;", "currentTicketStatus", "isLoading", "isUnassignedOrBot", "Lio/intercom/android/sdk/models/Participant;", "toTicketStatus", "Lio/intercom/android/sdk/models/Ticket$Status;", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nTicketDetailReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TicketDetailReducer.kt\nio/intercom/android/sdk/tickets/TicketDetailReducerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1549#2:96\n1620#2,3:97\n766#2:100\n857#2,2:101\n*S KotlinDebug\n*F\n+ 1 TicketDetailReducer.kt\nio/intercom/android/sdk/tickets/TicketDetailReducerKt\n*L\n33#1:96\n33#1:97,3\n43#1:100\n43#1:101,2\n*E\n"})
public final class TicketDetailReducerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TicketDetailState.TicketDetailContentState computeTicketViewState(@NotNull Ticket ticket, @NotNull UserIdentity user, @NotNull List<AvatarWrapper> activeAdminsAvatars, @NotNull TicketLaunchedFrom launchedFrom, boolean isConversationalMessenger) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Ticket.TicketAttribute it;
        Collection<TicketTimelineCardState.ProgressSection> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)ticket, (String)"ticket");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(activeAdminsAvatars, (String)"activeAdminsAvatars");
        Intrinsics.checkNotNullParameter((Object)launchedFrom, (String)"launchedFrom");
        String string2 = ticket.getTitle();
        Participant participant = ticket.getAssignee().build();
        Intrinsics.checkNotNullExpressionValue((Object)participant, (String)"ticket.assignee.build()");
        if (TicketDetailReducerKt.isUnassignedOrBot(participant) && !((Collection)activeAdminsAvatars).isEmpty()) {
            list = CollectionsKt.take((Iterable)activeAdminsAvatars, (int)3);
        } else {
            Avatar avatar = ticket.getAssignee().build().getAvatar();
            Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"ticket.assignee.build().avatar");
            list = CollectionsKt.listOf((Object)new AvatarWrapper(avatar, false, null, null, null, false, false, 126, null));
        }
        Iterable iterable = ticket.getStatusList();
        long l = TicketDetailReducerKt.toTicketStatus(ticket.getCurrentStatus()).getColor-0d7_KjU();
        String string3 = "";
        String string4 = ticket.getCurrentStatus().getStatusDetail();
        List list2 = list;
        String string5 = string2;
        boolean $i$f$map = false;
        void var7_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Ticket.Status status = (Ticket.Status)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TicketTimelineCardState.ProgressSection(TicketDetailReducerKt.isDone(TicketDetailReducerKt.toTicketStatus((Ticket.Status)((Object)it)), TicketDetailReducerKt.toTicketStatus(ticket.getCurrentStatus())), TicketDetailReducerKt.isLoading(TicketDetailReducerKt.toTicketStatus((Ticket.Status)((Object)it)), TicketDetailReducerKt.toTicketStatus(ticket.getCurrentStatus()))));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        Long l2 = ticket.getLatestStatusUpdatedAt();
        String string6 = ticket.getCurrentStatus().getTitle();
        Collection<TicketTimelineCardState.ProgressSection> collection2 = collection;
        long l3 = l;
        String string7 = string3;
        String string8 = string4;
        List list3 = list2;
        $this$map$iv = ticket.getAttributes();
        TicketTimelineCardState ticketTimelineCardState = new TicketTimelineCardState(list3, string8, string7, l3, (List)collection2, string6, l2, defaultConstructorMarker);
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Ticket.TicketAttribute)element$iv$iv;
            boolean bl = false;
            if (!it.hasValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list4 = (List)destination$iv$iv;
        String string9 = user.getEmail();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"user.email");
        boolean bl = isConversationalMessenger;
        ConversationButtonState conversationButtonState = TicketDetailReducerKt.conversationButtonState(ticket.getConversationButton(), launchedFrom);
        String string10 = ticket.getConversationId();
        String string11 = string9;
        List list5 = list4;
        TicketTimelineCardState ticketTimelineCardState2 = ticketTimelineCardState;
        String string12 = string5;
        return new TicketDetailState.TicketDetailContentState(string12, ticketTimelineCardState2, list5, string11, string10, conversationButtonState, bl);
    }

    public static /* synthetic */ TicketDetailState.TicketDetailContentState computeTicketViewState$default(Ticket ticket, UserIdentity userIdentity, List list, TicketLaunchedFrom ticketLaunchedFrom, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return TicketDetailReducerKt.computeTicketViewState(ticket, userIdentity, list, ticketLaunchedFrom, bl);
    }

    private static final ConversationButtonState conversationButtonState(Ticket.ConversationButton conversationButton, TicketLaunchedFrom launchedFrom) {
        Object object;
        Integer n;
        boolean bl = !(launchedFrom instanceof TicketLaunchedFrom.Conversation) && conversationButton != null;
        Ticket.ConversationButton conversationButton2 = conversationButton;
        Ticket.ConversationButton.IconType iconType = conversationButton2 != null ? conversationButton2.getIcon() : null;
        switch (iconType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[iconType.ordinal()]) {
            case 1: {
                n = R.drawable.intercom_send_message_icon;
                break;
            }
            case 2: {
                n = R.drawable.intercom_messages_icon;
                break;
            }
            default: {
                n = null;
            }
        }
        if ((object = conversationButton) == null || (object = ((Ticket.ConversationButton)object).getText()) == null) {
            object = "";
        }
        return new ConversationButtonState(bl, n, (StringProvider)new StringProvider.ActualString((String)object));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isUnassignedOrBot(Participant $this$isUnassignedOrBot) {
        if (Intrinsics.areEqual((Object)$this$isUnassignedOrBot, (Object)Participant.create("", "", "user", "", Avatar.create("", ""), false))) return true;
        Boolean bl = $this$isUnassignedOrBot.isBot();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"this.isBot");
        if (bl == false) return false;
        return true;
    }

    public static final boolean isDone(@NotNull TicketStatus $this$isDone, @NotNull TicketStatus currentTicketStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isDone), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)currentTicketStatus), (String)"currentTicketStatus");
        return currentTicketStatus.ordinal() >= $this$isDone.ordinal();
    }

    public static final boolean isLoading(@NotNull TicketStatus $this$isLoading, @NotNull TicketStatus currentTicketStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isLoading), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)currentTicketStatus), (String)"currentTicketStatus");
        return currentTicketStatus.ordinal() == $this$isLoading.ordinal() && currentTicketStatus.ordinal() < ArraysKt.getLastIndex((Object[])TicketStatus.values());
    }

    @NotNull
    public static final TicketStatus toTicketStatus(@NotNull Ticket.Status $this$toTicketStatus) {
        TicketStatus ticketStatus;
        Intrinsics.checkNotNullParameter((Object)$this$toTicketStatus, (String)"<this>");
        switch ($this$toTicketStatus.getType()) {
            case "submitted": {
                ticketStatus = TicketStatus.Submitted;
                break;
            }
            case "in_progress": {
                ticketStatus = TicketStatus.InProgress;
                break;
            }
            case "waiting_on_customer": {
                ticketStatus = TicketStatus.WaitingOnCustomer;
                break;
            }
            case "resolved": {
                ticketStatus = TicketStatus.Resolved;
                break;
            }
            default: {
                ticketStatus = TicketStatus.Submitted;
            }
        }
        return ticketStatus;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Ticket.ConversationButton.IconType.values().length];
            try {
                nArray[Ticket.ConversationButton.IconType.SEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Ticket.ConversationButton.IconType.CONVERSATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

