/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import androidx.annotation.VisibleForTesting;
import com.intercom.twig.Twig;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.nexus.NexusConfig;
import io.intercom.android.nexus.NexusEvent;
import io.intercom.android.nexus.NexusEventType;
import io.intercom.android.nexus.NexusListener;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0007J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u0015H\u0016J\b\u0010\"\u001a\u00020\u0015H\u0016J\b\u0010#\u001a\u00020\u0015H\u0016J\u000f\u0010$\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010%R\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/intercom/android/sdk/NexusWrapper;", "Lio/intercom/android/nexus/NexusClient;", "Lio/intercom/android/nexus/NexusListener;", "twig", "Lcom/intercom/twig/Twig;", "okHttpClient", "Lokhttp3/OkHttpClient;", "store", "Lio/intercom/android/sdk/store/Store;", "Lio/intercom/android/sdk/state/State;", "api", "Lio/intercom/android/sdk/api/Api;", "debouncePeriodMs", "", "(Lcom/intercom/twig/Twig;Lokhttp3/OkHttpClient;Lio/intercom/android/sdk/store/Store;Lio/intercom/android/sdk/api/Api;J)V", "actionFuture", "Ljava/util/concurrent/ScheduledFuture;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "connect", "", "config", "Lio/intercom/android/nexus/NexusConfig;", "shouldSendPresence", "", "connectNow", "disconnect", "disconnectNow", "logKnownEvent", "event", "Lio/intercom/android/nexus/NexusEvent;", "notifyEvent", "onConnect", "onConnectFailed", "onShutdown", "removeCallbacks", "()Ljava/lang/Boolean;", "Companion", "intercom-sdk-base_release"})
public final class NexusWrapper
extends NexusClient
implements NexusListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Twig twig;
    @NotNull
    private final Store<State> store;
    @NotNull
    private final Api api;
    private final long debouncePeriodMs;
    private final ScheduledExecutorService executor;
    @Nullable
    private ScheduledFuture<?> actionFuture;
    @NotNull
    private static final String CONVERSATION_ID = "conversationId";

    public NexusWrapper(@NotNull Twig twig, @NotNull OkHttpClient okHttpClient, @NotNull Store<State> store, @NotNull Api api, long debouncePeriodMs) {
        Intrinsics.checkNotNullParameter((Object)twig, (String)"twig");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkNotNullParameter(store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        super(twig, okHttpClient);
        this.twig = twig;
        this.store = store;
        this.api = api;
        this.debouncePeriodMs = debouncePeriodMs;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public void connect(@NotNull NexusConfig config, boolean shouldSendPresence) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (config.getEndpoints().isEmpty()) {
            this.twig.w("No realtime endpoints present so we can't connect", new Object[0]);
            return;
        }
        this.removeCallbacks();
        this.actionFuture = this.executor.schedule(() -> NexusWrapper.connect$lambda$0(this, config, shouldSendPresence), this.debouncePeriodMs, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public final void connectNow(@NotNull NexusConfig config, boolean shouldSendPresence) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (this.isConnected()) {
            return;
        }
        super.connect(config, shouldSendPresence);
        this.setTopics(CollectionsKt.listOf((Object)"*"));
        this.addEventListener(this);
    }

    public void disconnect() {
        this.removeCallbacks();
        this.actionFuture = this.executor.schedule(() -> NexusWrapper.disconnect$lambda$1(this), this.debouncePeriodMs, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public final void disconnectNow() {
        this.removeEventListener(this);
        super.disconnect();
    }

    private final Boolean removeCallbacks() {
        ScheduledFuture<?> scheduledFuture = this.actionFuture;
        return scheduledFuture != null ? Boolean.valueOf(scheduledFuture.cancel(false)) : null;
    }

    public void notifyEvent(@NotNull NexusEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String conversationId = event.getEventData().optString(CONVERSATION_ID);
        NexusEventType nexusEventType = event.getEventType();
        switch (nexusEventType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[nexusEventType.ordinal()]) {
            case 1: {
                this.logKnownEvent(event);
                break;
            }
            case 2: {
                this.logKnownEvent(event);
                this.store.dispatch(Actions.newCommentEventReceived(conversationId));
                break;
            }
            case 3: {
                this.logKnownEvent(event);
                break;
            }
            case 4: {
                this.logKnownEvent(event);
                this.store.dispatch(Actions.conversationMarkedAsRead(conversationId));
                break;
            }
            case 5: {
                this.logKnownEvent(event);
                long entityType = event.getEventData().optLong("entity_type");
                String entityId = event.getEventData().optString("entity_id");
                long l = entityType;
                if (l == 44L) {
                    this.api.fetchCarouselByEntityId(entityId);
                    break;
                }
                if (l == 85L) {
                    this.api.fetchSurveyByEntityId(entityId);
                    break;
                }
                this.twig.internal("Nexus NewContent", "Unexpected entity type: " + entityType);
                break;
            }
            default: {
                this.twig.internal("Nexus", "Unexpected event: " + event.getEventType());
            }
        }
    }

    private final void logKnownEvent(NexusEvent event) {
        this.twig.internal("Nexus", "Received " + event.getEventType() + " event");
    }

    public void onConnect() {
    }

    public void onConnectFailed() {
    }

    public void onShutdown() {
    }

    private static final void connect$lambda$0(NexusWrapper this$0, NexusConfig $config, boolean $shouldSendPresence) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        this$0.connectNow($config, $shouldSendPresence);
    }

    private static final void disconnect$lambda$1(NexusWrapper this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.disconnectNow();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/intercom/android/sdk/NexusWrapper$Companion;", "", "()V", "CONVERSATION_ID", "", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NexusEventType.values().length];
            try {
                nArray[NexusEventType.AdminIsTyping.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NexusEventType.NewComment.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NexusEventType.UserContentSeenByAdmin.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NexusEventType.ConversationSeen.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NexusEventType.NewContent.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

