/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import coil.request.ImageRequest;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.IntercomCoilKt;
import io.intercom.android.sdk.utilities.commons.ScreenUtils;

class DefaultLauncher
implements View.OnTouchListener {
    private static final int ANIMATION_DURATION_MS = 300;
    private static final int CUSTOM_LAUNCHER_SIZE_DP = 34;
    private final TextView badgeCount;
    final View launcherRoot;
    final Listener listener;
    private final ImageButton badge;

    public DefaultLauncher(ViewGroup root, LayoutInflater inflater, Listener listener2, int bottomPadding) {
        this.listener = listener2;
        inflater.inflate(R.layout.intercom_default_launcher, root, true);
        this.launcherRoot = root.findViewById(R.id.launcher_root);
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.launcherRoot.getLayoutParams();
        params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, bottomPadding);
        this.launcherRoot.setLayoutParams((ViewGroup.LayoutParams)params);
        this.badge = (ImageButton)this.launcherRoot.findViewById(R.id.launcher_icon);
        this.badgeCount = (TextView)this.launcherRoot.findViewById(R.id.launcher_badge_count);
        this.launcherRoot.setOnTouchListener((View.OnTouchListener)this);
    }

    public void setLauncherColor(@ColorInt int logoColor, @ColorInt int bgColor) {
        Context context = this.badge.getContext();
        Drawable iconBg = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_solid_circle);
        iconBg.setColorFilter(bgColor, PorterDuff.Mode.SRC_IN);
        Drawable countBg = iconBg.getConstantState().newDrawable();
        int countBackgroundColour = ContextCompat.getColor((Context)context, (int)R.color.intercom_inbox_count_background);
        countBg.setColorFilter(countBackgroundColour, PorterDuff.Mode.SRC_IN);
        BackgroundUtils.setBackground((View)this.badgeCount, countBg);
        BackgroundUtils.setBackground((View)this.badge, iconBg);
        Drawable drawable2 = this.badge.getDrawable();
        if (drawable2 != null) {
            drawable2.setColorFilter(logoColor, PorterDuff.Mode.SRC_IN);
        }
    }

    public void setLauncherLogo(AppConfig appConfig) {
        Context context = this.badge.getContext();
        int sizePx = ScreenUtils.dpToPx(34.0f, context);
        ImageRequest imageRequest = new ImageRequest.Builder(context).data((Object)appConfig.getLauncherLogoUrl()).error(R.drawable.intercom_launcher_icon).target((ImageView)this.badge).size(sizePx, sizePx).build();
        IntercomCoilKt.loadIntercomImage(context, imageRequest);
    }

    public void setBadgeCount(String unreadCount) {
        this.badgeCount.setVisibility(0);
        this.badgeCount.setText((CharSequence)unreadCount);
    }

    public void hideBadgeCount() {
        this.badgeCount.setVisibility(8);
    }

    public void fadeOnScreen() {
        this.launcherRoot.setAlpha(0.0f);
        this.launcherRoot.animate().alpha(1.0f).setDuration(100L).start();
    }

    public void fadeOffScreen(@Nullable Animator.AnimatorListener listener2) {
        this.launcherRoot.animate().alpha(0.0f).setDuration(100L).setListener(listener2).start();
    }

    public void pulseForTransformation(final Animator.AnimatorListener listener2) {
        this.launcherRoot.animate().scaleX(1.1f).scaleY(1.1f).setDuration(100L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                listener2.onAnimationEnd(animation);
                DefaultLauncher.this.launcherRoot.animate().scaleX(1.0f).scaleY(1.0f).setDuration(100L).start();
            }
        }).start();
    }

    public void removeView() {
        if (this.launcherRoot.getParent() != null) {
            ((ViewGroup)this.launcherRoot.getParent()).removeView(this.launcherRoot);
        }
    }

    public boolean isAttachedToRoot(ViewGroup root) {
        return this.launcherRoot.getParent() == root;
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                v.setScaleX(0.9f);
                v.setScaleY(0.9f);
                break;
            }
            case 1: {
                this.callListenerWithFadeOut();
                break;
            }
        }
        return true;
    }

    private void callListenerWithFadeOut() {
        this.launcherRoot.setAlpha(1.0f);
        this.launcherRoot.animate().alpha(0.0f).setDuration(50L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                DefaultLauncher.this.listener.onLauncherClicked(DefaultLauncher.this.launcherRoot.getContext());
            }
        }).start();
    }

    public void updateBottomPadding(int bottomPadding) {
        final ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.launcherRoot.getLayoutParams();
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{params.bottomMargin, bottomPadding});
        valueAnimator.setDuration(300L);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, ((Integer)animation.getAnimatedValue()).intValue());
                DefaultLauncher.this.launcherRoot.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        });
        valueAnimator.start();
    }

    public static interface Listener {
        public void onLauncherClicked(Context var1);
    }
}

