/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.models.AutoValue_ConversationList;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.EmptyState;
import io.intercom.android.sdk.utilities.commons.CollectionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@AutoValue
public abstract class ConversationList {
    public static ConversationList create(List<Conversation> conversations, Set<String> unreadConversationIds, EmptyState emptyState, boolean morePagesAvailable, int unreadConversationsCount2) {
        return new AutoValue_ConversationList(conversations, unreadConversationIds, unreadConversationsCount2, emptyState, morePagesAvailable);
    }

    public abstract List<Conversation> getConversations();

    public abstract Set<String> getUnreadConversationIds();

    public abstract int getUnreadConversationsCount();

    public abstract EmptyState getEmptyState();

    public abstract boolean hasMorePages();

    public static final class Builder {
        @Nullable
        List<Conversation.Builder> conversations;
        @Nullable
        List<String> unread_conversation_ids;
        int total_count = 0;
        @Nullable
        EmptyState empty_state;
        boolean more_pages_available;

        public ConversationList build() {
            ArrayList<Conversation> conversations = new ArrayList<Conversation>(CollectionUtils.capacityFor(this.conversations));
            if (this.conversations != null) {
                for (Conversation.Builder builder : this.conversations) {
                    if (builder == null) continue;
                    conversations.add(builder.build());
                }
            }
            HashSet<String> unreadConversationIds = new HashSet<String>(CollectionUtils.capacityFor(this.unread_conversation_ids));
            if (this.unread_conversation_ids != null) {
                for (String id2 : this.unread_conversation_ids) {
                    if (id2 == null) continue;
                    unreadConversationIds.add(id2);
                }
            }
            EmptyState emptyState = this.empty_state != null ? this.empty_state : EmptyState.Companion.getNULL();
            return ConversationList.create(conversations, unreadConversationIds, emptyState, this.more_pages_available, this.total_count);
        }

        public Builder withConversations(List<Conversation.Builder> conversations) {
            this.conversations = conversations;
            return this;
        }

        public Builder withMorePagesAvailable(boolean morePagesAvailable) {
            this.more_pages_available = morePagesAvailable;
            return this;
        }

        public Builder withEmptyState(EmptyState emptyState) {
            this.empty_state = emptyState;
            return this;
        }

        public Builder withUnreadConversationsCount(int unreadConversationsCount2) {
            this.total_count = unreadConversationsCount2;
            return this;
        }
    }
}

