/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.lightcompressor.CompressionListener;
import io.intercom.android.sdk.lightcompressor.VideoCompressor;
import io.intercom.android.sdk.lightcompressor.VideoQuality;
import io.intercom.android.sdk.lightcompressor.config.AppSpecificStorageConfiguration;
import io.intercom.android.sdk.lightcompressor.config.Configuration;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.utils.CompressedImageData;
import io.intercom.android.sdk.utilities.BitmapUtilsKt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0000\u001a3\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0001H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"compressedImagesFolderName", "", "compressedVideosFolderName", "deleteCompressedMedia", "", "uri", "Landroid/net/Uri;", "getCompressedImageData", "Lio/intercom/android/sdk/m5/utils/CompressedImageData;", "context", "Landroid/content/Context;", "imageName", "getCompressedVideoData", "Lkotlin/Pair;", "", "videoName", "(Landroid/net/Uri;Landroid/content/Context;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intercom-sdk-base_release"})
public final class MediaCompressionKt {
    @NotNull
    private static final String compressedVideosFolderName = "compressed_videos";
    @NotNull
    private static final String compressedImagesFolderName = "compressed_images";

    @Nullable
    public static final Object getCompressedVideoData(@NotNull Uri $this$getCompressedVideoData, @NotNull Context context, @NotNull String videoName, @NotNull Continuation<? super Pair<? extends Uri, Long>> $completion) {
        Continuation<? super Pair<? extends Uri, Long>> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        Twig twig = LumberMill.getLogger();
        VideoCompressor.start$default((Context)context, (List)CollectionsKt.listOf((Object)$this$getCompressedVideoData), (boolean)false, null, (AppSpecificStorageConfiguration)new AppSpecificStorageConfiguration(compressedVideosFolderName), (Configuration)new Configuration(VideoQuality.LOW, false, null, false, false, null, null, CollectionsKt.listOf((Object)videoName), 126, null), (CompressionListener)new CompressionListener(twig, (Continuation<? super Pair<? extends Uri, Long>>)continuation2){
            final /* synthetic */ Twig $twig;
            final /* synthetic */ Continuation<Pair<? extends Uri, Long>> $continuation;
            {
                this.$twig = $twig;
                this.$continuation = $continuation;
            }

            public void onStart(int index) {
                this.$twig.internal("Video compression started.");
            }

            public void onSuccess(int index, long size, @Nullable String path) {
                File file;
                this.$twig.internal("Video compression succeeded. Video saved in " + path + '.');
                String string2 = path;
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    file = new File(it);
                } else {
                    file = null;
                }
                Uri uri = Uri.fromFile(file);
                this.$continuation.resumeWith(Result.constructor-impl((Object)TuplesKt.to((Object)uri, (Object)size)));
            }

            public void onFailure(int index, @NotNull String failureMessage) {
                Intrinsics.checkNotNullParameter((Object)failureMessage, (String)"failureMessage");
                this.$twig.internal("Video compression failed: " + failureMessage + '.');
                this.$continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Throwable(failureMessage))));
            }

            public void onProgress(int index, float percent) {
                this.$twig.internal("Video compression in progress: " + percent + '.');
            }

            public void onCancelled(int index) {
                this.$twig.internal("Video compression cancelled.");
                this.$continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new CancellationException())));
            }
        }, (int)8, null);
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public static final void deleteCompressedMedia(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (uri.getPathSegments().contains(compressedVideosFolderName) || uri.getPathSegments().contains(compressedImagesFolderName)) {
            new File(uri.toString()).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final CompressedImageData getCompressedImageData(@NotNull Uri $this$getCompressedImageData, @NotNull Context context, @NotNull String imageName) {
        CompressedImageData compressedImageData;
        block9: {
            block8: {
                Uri uri;
                Uri uri2;
                Bitmap bitmap;
                Intrinsics.checkNotNullParameter((Object)$this$getCompressedImageData, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
                BitmapFactory.Options $this$getCompressedImageData_u24lambda_u241 = new BitmapFactory.Options();
                boolean bl = false;
                $this$getCompressedImageData_u24lambda_u241.inJustDecodeBounds = true;
                InputStream input = context.getContentResolver().openInputStream($this$getCompressedImageData);
                BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)$this$getCompressedImageData_u24lambda_u241);
                InputStream inputStream = input;
                if (inputStream != null) {
                    inputStream.close();
                }
                $this$getCompressedImageData_u24lambda_u241.inSampleSize = BitmapUtilsKt.calculateInSampleSize($this$getCompressedImageData_u24lambda_u241, 612, 816);
                $this$getCompressedImageData_u24lambda_u241.inJustDecodeBounds = false;
                input = context.getContentResolver().openInputStream($this$getCompressedImageData);
                Bitmap bitmap2 = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)$this$getCompressedImageData_u24lambda_u241);
                InputStream inputStream2 = input;
                if (inputStream2 != null) {
                    inputStream2.close();
                }
                if ((bitmap = bitmap2) == null) break block8;
                Bitmap bitmap3 = bitmap;
                boolean bl2 = false;
                Bitmap rotatedBitmap = BitmapUtilsKt.determineBitmapRotation(context, $this$getCompressedImageData, bitmap3);
                File imageFolder = new File(context.getCacheDir(), compressedImagesFolderName);
                imageFolder.mkdirs();
                File file = new File(imageFolder, imageName + ".jpg");
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(file);
                    rotatedBitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)outputStream);
                    uri2 = Uri.fromFile((File)file);
                }
                catch (Throwable throwable) {
                    FileOutputStream fileOutputStream = outputStream;
                    if (fileOutputStream != null) {
                        fileOutputStream.flush();
                    }
                    FileOutputStream fileOutputStream2 = outputStream;
                    if (fileOutputStream2 != null) {
                        fileOutputStream2.close();
                    }
                    throw throwable;
                }
                outputStream.flush();
                outputStream.close();
                Uri uri3 = uri = uri2;
                if (uri3 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"uri");
                    Uri it = uri;
                    boolean bl3 = false;
                    compressedImageData = new CompressedImageData(it, rotatedBitmap.getWidth(), rotatedBitmap.getHeight(), file.length());
                } else {
                    compressedImageData = null;
                }
                break block9;
            }
            compressedImageData = null;
        }
        return compressedImageData;
    }
}

