/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.activities.ConversationReactionListener;
import io.intercom.android.sdk.activities.FullScreenInAppPresenter;
import io.intercom.android.sdk.activities.InAppToolbarListener;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.LightboxOpeningImageClickListener;
import io.intercom.android.sdk.blocks.LinkOpeningButtonClickListener;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.blocks.lib.BlocksViewHolder;
import io.intercom.android.sdk.blocks.views.AttachmentView;
import io.intercom.android.sdk.blocks.views.ParagraphView;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.ConversationScreenOpenerKt;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.post.PostActivityV2;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.utilities.commons.ScreenUtils;
import io.intercom.android.sdk.views.ActiveStatePresenter;
import io.intercom.android.sdk.views.ContentAwareScrollView;
import io.intercom.android.sdk.views.IntercomToolbar;

public class IntercomPostActivity
extends IntercomBaseActivity
implements View.OnClickListener {
    private static final String PARCEL_PART = "parcel_part";
    private static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    private static final String POST_PREVIEW = "is_post_preview";
    private static final String LAST_PARTICIPANT = "last_participant";
    private static final String COMPOSER_IS_VISIBLE = "composer_is_visible";
    private final FullScreenInAppPresenter presenter = new FullScreenInAppPresenter();
    Part part;
    private FrameLayout postContainer;
    ContentAwareScrollView postView;
    String conversationId;
    View composerLayout;
    private EditText textComposer;
    ReactionInputView reactionComposer;
    private LastParticipatingAdmin lastParticipatingAdmin;
    private boolean composerIsVisible = true;
    private boolean isPreview = false;
    MetricTracker metricTracker;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_post);
        Injector injector2 = Injector.get();
        Api api = injector2.getApi();
        this.metricTracker = injector2.getMetricTracker();
        Provider<AppConfig> appConfigProvider2 = injector2.getAppConfigProvider();
        final IntercomToolbar intercomToolbar = (IntercomToolbar)this.findViewById(R.id.intercom_toolbar);
        intercomToolbar.setListener(new InAppToolbarListener((Activity)this));
        this.part = new Part();
        this.lastParticipatingAdmin = LastParticipatingAdmin.NULL;
        TimeFormatter timeFormatter2 = new TimeFormatter((Context)this, injector2.getTimeProvider());
        Bundle data = this.getIntent().getExtras();
        if (data != null) {
            data.setClassLoader(Part.class.getClassLoader());
            if (data.containsKey(PARCEL_PART)) {
                this.part = (Part)data.getParcelable(PARCEL_PART);
                String teamMateName = "";
                if (this.part != null && this.part.getParticipant() != null) {
                    teamMateName = this.part.getParticipant().getForename();
                }
                String appName = appConfigProvider2.get().getName();
                CharSequence title = Phrase.from((Context)this, R.string.intercom_teammate_from_company).put("name", teamMateName).put("company", appName).format();
                intercomToolbar.setTitle(title);
            }
            if (data.containsKey(PARCEL_CONVERSATION_ID)) {
                this.conversationId = data.getString(PARCEL_CONVERSATION_ID, "");
                injector2.getStore().dispatch(Actions.conversationMarkedAsRead(this.conversationId));
                api.markConversationAsRead(this.conversationId);
            }
            if (data.containsKey(COMPOSER_IS_VISIBLE)) {
                this.composerIsVisible = data.getBoolean(COMPOSER_IS_VISIBLE, true);
            }
            if (data.containsKey(POST_PREVIEW)) {
                this.isPreview = data.getBoolean(POST_PREVIEW, false);
            }
            if (data.containsKey(LAST_PARTICIPANT)) {
                this.lastParticipatingAdmin = (LastParticipatingAdmin)data.getParcelable(LAST_PARTICIPANT);
                if (!LastParticipatingAdmin.isNull(this.lastParticipatingAdmin)) {
                    intercomToolbar.setSubtitle(timeFormatter2.getAdminActiveStatus(this.lastParticipatingAdmin, appConfigProvider2));
                }
            }
        }
        intercomToolbar.setVisibility(8);
        intercomToolbar.setUpPostToolbar(this.part.getParticipant(), this.lastParticipatingAdmin.isActive(), new ActiveStatePresenter(), appConfigProvider2.get());
        int primaryColor = appConfigProvider2.get().getPrimaryColor();
        View background = this.getWindow().getDecorView();
        background.setBackgroundColor(Color.argb((int)153, (int)Color.red((int)primaryColor), (int)Color.green((int)primaryColor), (int)Color.blue((int)primaryColor)));
        ViewHolderGenerator viewHolderGenerator = new ViewHolderGenerator(new UploadingImageCache(), api, appConfigProvider2, this.conversationId, new LightboxOpeningImageClickListener(api), new LinkOpeningButtonClickListener(api), injector2.getGson(), this.metricTracker);
        BlocksViewHolder postHolder = viewHolderGenerator.getPostHolder();
        this.postContainer = (FrameLayout)this.findViewById(R.id.post_container);
        this.composerLayout = this.findViewById(R.id.conversation_coordinator);
        this.textComposer = (EditText)this.findViewById(R.id.composer_input_view);
        this.applyAccessibilityFullScreenPostStyling(this.textComposer);
        this.reactionComposer = (ReactionInputView)this.findViewById(R.id.reaction_input_view);
        this.postView = (ContentAwareScrollView)this.findViewById(R.id.post_view);
        LinearLayout partsView = ViewHolderGenerator.createPartsLayout(postHolder, this.part, (Context)this);
        this.ensureColorConformanceForViews(partsView);
        this.postView.addView(BlockUtils.getBlockView((ViewGroup)this.postView, partsView, (Context)this));
        if (this.isPreview && !ReactionReply.isNull(this.part.getReactionReply())) {
            final ConversationReactionListener reactionListener = new ConversationReactionListener(MetricTracker.ReactionLocation.IN_APP, this.part.getId(), this.conversationId, Injector.get().getApi(), this.metricTracker);
            this.postView.setListener(new ContentAwareScrollView.Listener(){

                @Override
                public void onBottomReached() {
                    IntercomPostActivity.this.postView.setListener(null);
                    if (IntercomPostActivity.this.composerLayout.getVisibility() != 0) {
                        IntercomPostActivity.this.composerLayout.setVisibility(0);
                        IntercomPostActivity.this.reactionComposer.setUpReactions(IntercomPostActivity.this.part.getReactionReply(), true, reactionListener);
                    }
                }

                @Override
                public void onScrollChanged(int scrollPosition) {
                }
            });
            this.reactionComposer.preloadReactionImages(this.part.getReactionReply());
        }
        if (this.openedFromConversation()) {
            this.metricTracker.viewedInAppFromMessenger(this.part.getMessageStyle(), this.conversationId, this.part.getId());
        }
        background.setAlpha(0.0f);
        background.animate().alpha(1.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomPostActivity.this.animateToolbar(intercomToolbar);
                IntercomPostActivity.this.animateContent();
                if (IntercomPostActivity.this.openedFromConversation()) {
                    IntercomPostActivity.this.composerLayout.setVisibility(8);
                } else if (IntercomPostActivity.this.composerIsVisible && ReactionReply.isNull(IntercomPostActivity.this.part.getReactionReply())) {
                    View touchTarget = IntercomPostActivity.this.findViewById(R.id.post_touch_target);
                    touchTarget.setOnClickListener((View.OnClickListener)IntercomPostActivity.this);
                    IntercomPostActivity.this.animateComposer();
                }
            }
        }).start();
    }

    private void ensureColorConformanceForViews(LinearLayout partsView) {
        Injector injector2 = Injector.get();
        Provider<AppConfig> appConfigProvider2 = injector2.getAppConfigProvider();
        for (int i = 0; i < partsView.getChildCount(); ++i) {
            View view = partsView.getChildAt(i);
            if (view instanceof Button) {
                this.ensureButtonCorrectness((Button)view, appConfigProvider2);
                continue;
            }
            if (view instanceof ParagraphView) {
                this.ensureTextViewCorrectness((TextView)view);
                continue;
            }
            if (view instanceof TextView) {
                this.ensureTextViewCorrectness((TextView)view);
                continue;
            }
            if (view instanceof AttachmentView) {
                this.ensureWhiteAttachmentView((AttachmentView)view);
                continue;
            }
            if (!(view instanceof LinearLayout)) continue;
            this.ensureColorConformanceForViews((LinearLayout)view);
        }
    }

    private void ensureTextViewCorrectness(TextView view) {
        view.setTextColor(ContextCompat.getColor((Context)this.getApplicationContext(), (int)R.color.intercom_white));
        view.setLinkTextColor(this.getResources().getColor(R.color.intercom_white));
    }

    private void ensureButtonCorrectness(Button view, Provider<AppConfig> appConfigProvider2) {
        if (ColorUtils.isColorLight(appConfigProvider2.get().getPrimaryColor())) {
            view.setTextColor(ContextCompat.getColor((Context)this.getApplicationContext(), (int)R.color.intercom_accessibility_black));
        } else {
            view.setTextColor(ContextCompat.getColor((Context)this.getApplicationContext(), (int)R.color.intercom_white));
        }
    }

    private void ensureWhiteAttachmentView(AttachmentView view) {
        for (int i = 0; i < view.getChildCount(); ++i) {
            View childView = view.getChildAt(i);
            if (childView instanceof TextView) {
                ((TextView)childView).setTextColor(ContextCompat.getColor((Context)this.getApplicationContext(), (int)R.color.intercom_white));
                continue;
            }
            if (!(childView instanceof ImageView)) continue;
            ((ImageView)childView).setColorFilter(ContextCompat.getColor((Context)this.getApplicationContext(), (int)R.color.intercom_white));
        }
    }

    private void applyAccessibilityFullScreenPostStyling(EditText textComposer) {
        int whiteColor = this.getResources().getColor(R.color.intercom_white);
        textComposer.setHintTextColor(whiteColor);
        textComposer.setTextColor(whiteColor);
    }

    void animateToolbar(IntercomToolbar toolbar) {
        toolbar.setY(toolbar.getY() + (float)ScreenUtils.dpToPx(200.0f, (Context)this));
        toolbar.setVisibility(0);
        toolbar.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).translationY(0.0f).setDuration(300L).start();
    }

    void animateContent() {
        this.postContainer.setY(this.postContainer.getY() + (float)ScreenUtils.dpToPx(400.0f, (Context)this));
        this.postContainer.setVisibility(0);
        this.postContainer.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).translationY(0.0f).setDuration(300L).start();
    }

    void animateComposer() {
        this.composerLayout.setY(this.composerLayout.getY() + (float)ScreenUtils.dpToPx(156.0f, (Context)this));
        this.composerLayout.setVisibility(0);
        this.textComposer.setVisibility(0);
        this.composerLayout.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).translationY(0.0f).setDuration(300L).start();
    }

    public static Intent buildPostIntent(Context context, Part part, String conversationId, LastParticipatingAdmin lastParticipatingAdmin, boolean composerIsVisible, boolean isPreview) {
        Class intentClass = !Injector.isNotInitialised() && Injector.get().getAppConfigProvider().get().hasFeature("new-post-rendering-enabled") ? PostActivityV2.class : IntercomPostActivity.class;
        Intent intent = new Intent(context, intentClass).putExtra(PARCEL_PART, (Parcelable)part).putExtra(LAST_PARTICIPANT, (Parcelable)lastParticipatingAdmin).putExtra(COMPOSER_IS_VISIBLE, composerIsVisible).putExtra(POST_PREVIEW, isPreview);
        if (!TextUtils.isEmpty((CharSequence)conversationId)) {
            intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        }
        intent.setExtrasClassLoader(Part.class.getClassLoader());
        return intent;
    }

    boolean openedFromConversation() {
        return !this.isPreview;
    }

    public void onBackPressed() {
        this.presenter.closeWindow((Activity)this);
        if (this.isPreview) {
            this.metricTracker.closedInAppFromFull(this.conversationId, this.part.getId());
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.post_touch_target) {
            this.presenter.closeWindow((Activity)this);
            if (this.isPreview) {
                this.metricTracker.openedConversationFromFull(this.conversationId, this.part.getId());
                this.startActivity(ConversationScreenOpenerKt.getConversationIntent((Context)this, this.conversationId, this.lastParticipatingAdmin));
            }
        }
    }
}

