/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import coil.ImageLoader;
import coil.ImageLoaders;
import coil.request.ImageRequest;
import io.intercom.android.sdk.ui.IntercomImageLoaderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\f"}, d2={"cleanUp", "", "clearIntercomImage", "imageView", "Landroid/widget/ImageView;", "loadIntercomImage", "context", "Landroid/content/Context;", "imageRequest", "Lcoil/request/ImageRequest;", "loadIntercomImageBlocking", "Landroid/graphics/drawable/Drawable;", "intercom-sdk-base_release"})
public final class IntercomCoilKt {
    public static final void loadIntercomImage(@NotNull Context context, @NotNull ImageRequest imageRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        IntercomImageLoaderKt.getImageLoader((Context)context).enqueue(imageRequest);
    }

    @Nullable
    public static final Drawable loadIntercomImageBlocking(@NotNull Context context, @NotNull ImageRequest imageRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        return ImageLoaders.executeBlocking((ImageLoader)IntercomImageLoaderKt.getImageLoader((Context)context), (ImageRequest)imageRequest).getDrawable();
    }

    public static final void clearIntercomImage(@NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Context context = imageView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"imageView.context");
        ImageRequest clearImageRequest = new ImageRequest.Builder(context).data(null).build();
        Context context2 = imageView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"imageView.context");
        IntercomImageLoaderKt.getImageLoader((Context)context2).enqueue(clearImageRequest);
    }

    public static final void cleanUp() {
    }
}

