/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.models.BaseResponse;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;

public class AppConfigMiddleware
implements Store.Middleware<State> {
    private final IntercomDataLayer dataLayer;

    public AppConfigMiddleware(IntercomDataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        switch (action.type()) {
            case BASE_RESPONSE_RECEIVED: {
                BaseResponse response = (BaseResponse)action.value();
                this.dataLayer.updateConfig(response.getConfig());
                break;
            }
            case HARD_RESET: {
                this.dataLayer.resetConfig();
                break;
            }
        }
    }
}

