/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities.commons;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

public class DeviceUtils {
    public static boolean hasPermission(Context context, String permissionType) {
        int res = context.checkCallingOrSelfPermission(permissionType);
        return res == 0;
    }

    public static String getAppVersion(Context context) {
        String version = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            if (packageInfo.versionName != null) {
                version = packageInfo.versionName;
            }
        }
        catch (PackageManager.NameNotFoundException | RuntimeException throwable) {
            // empty catch block
        }
        return version;
    }

    public static String getAppMinSdkVersionVersion(Context context) {
        String version = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            if (packageInfo.applicationInfo != null) {
                version = String.valueOf(packageInfo.applicationInfo.minSdkVersion);
            }
        }
        catch (PackageManager.NameNotFoundException | RuntimeException throwable) {
            // empty catch block
        }
        return version;
    }

    public static String getAppName(Context context) {
        String packageName = context.getPackageName();
        return packageName == null ? "" : packageName;
    }
}

