/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import io.intercom.android.sdk.NotificationStatuses;
import io.intercom.android.sdk.models.ComposerState;
import io.intercom.android.sdk.models.ConversationHeaderStyle;
import io.intercom.android.sdk.models.ConversationState;
import io.intercom.android.sdk.models.ConversationUiFlags;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.utilities.NullSafety;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nullable;

public class Conversation {
    public static final int RECENCY_THRESHOLD_FOR_HOMESCREEN_CONVERSATION = 864000000;
    private final Map<String, Participant> participants;
    private final List<Part> conversationParts;
    private final List<Participant> groupConversationParticipants;
    private final LastParticipatingAdmin lastParticipatingAdmin;
    private final ComposerState composerState;
    private final String id;
    private final boolean read;
    private final String intercomLinkSolution;
    private final boolean preventEndUserReplies;
    private final boolean inboundConversationsDisabled;
    private final String notificationStatus;
    private final String state;
    private final boolean isInbound;
    private final Ticket ticket;
    private final ConversationHeaderStyle headerStyle;
    private final ConversationUiFlags uiFlags;

    public Conversation() {
        this(new Builder());
    }

    Conversation(Builder builder) {
        this.id = NullSafety.valueOrEmpty(builder.id);
        this.read = builder.read;
        this.participants = new LinkedHashMap<String, Participant>();
        this.intercomLinkSolution = NullSafety.valueOrEmpty(builder.intercom_link_solution);
        if (builder.participants != null) {
            for (Participant.Builder participantBuilder : builder.participants) {
                Participant participant = participantBuilder.build();
                this.participants.put(participant.getId(), participant);
            }
        }
        this.conversationParts = new ArrayList<Part>();
        if (builder.conversation_parts != null) {
            for (Part.Builder partBuilder : builder.conversation_parts) {
                Part part = partBuilder.build();
                part.setParticipant(this.getParticipant(part.getParticipantId()));
                this.conversationParts.add(part);
            }
        }
        this.groupConversationParticipants = new ArrayList<Participant>();
        if (builder.group_conversation_participant_ids != null) {
            for (String participantId : builder.group_conversation_participant_ids) {
                if (participantId == null) continue;
                this.groupConversationParticipants.add(this.getParticipant(participantId));
            }
        }
        this.lastParticipatingAdmin = builder.last_participating_admin != null ? builder.last_participating_admin.build() : LastParticipatingAdmin.NULL;
        this.composerState = builder.composer_state != null ? builder.composer_state.build() : ComposerState.NULL;
        this.preventEndUserReplies = builder.prevent_end_user_replies;
        this.inboundConversationsDisabled = NullSafety.valueOrDefault(builder.inbound_conversations_disabled, false);
        this.notificationStatus = NullSafety.valueOrEmpty(builder.notification_status);
        this.state = NullSafety.valueOrEmpty(builder.state);
        this.isInbound = NullSafety.valueOrDefault(builder.is_inbound, false);
        this.ticket = builder.ticket == null ? Ticket.Companion.getNULL() : builder.ticket;
        this.headerStyle = builder.ux_style != null ? builder.ux_style : ConversationHeaderStyle.NONE;
        this.uiFlags = builder.ui_flags != null ? builder.ui_flags : ConversationUiFlags.getDEFAULT();
    }

    private Conversation(Map<String, Participant> participants, List<Part> conversationParts, List<Participant> groupConversationParticipantIds, LastParticipatingAdmin lastParticipatingAdmin, ComposerState composerState, String id2, boolean read, String intercomLinkSolution, boolean preventEndUserReplies, boolean inboundConversationsDisabled, String notificationStatus, String state, boolean isInbound, Ticket ticket, ConversationHeaderStyle headerStyle, ConversationUiFlags uiFlags) {
        this.participants = participants;
        this.conversationParts = conversationParts;
        this.groupConversationParticipants = groupConversationParticipantIds;
        this.lastParticipatingAdmin = lastParticipatingAdmin;
        this.composerState = composerState;
        this.id = id2;
        this.read = read;
        this.intercomLinkSolution = intercomLinkSolution;
        this.preventEndUserReplies = preventEndUserReplies;
        this.inboundConversationsDisabled = inboundConversationsDisabled;
        this.notificationStatus = notificationStatus;
        this.state = state;
        this.isInbound = isInbound;
        this.ticket = ticket;
        this.headerStyle = headerStyle;
        this.uiFlags = uiFlags;
    }

    public List<Part> getParts() {
        return this.conversationParts;
    }

    public Part getLastPart() {
        return this.conversationParts.isEmpty() ? Part.NULL : this.conversationParts.get(this.conversationParts.size() - 1);
    }

    public Part getLastNonEventPart() {
        for (int i = this.conversationParts.size() - 1; i >= 0; --i) {
            Part part = this.conversationParts.get(i);
            if (part.isEvent().booleanValue()) continue;
            return part;
        }
        return Part.NULL;
    }

    public Part getLastAdminPart() {
        for (int i = this.conversationParts.size() - 1; i >= 0; --i) {
            Part part = this.conversationParts.get(i);
            if (!part.isAdmin()) continue;
            return part;
        }
        return Part.NULL;
    }

    public Participant getParticipant(String id2) {
        Participant participant = this.participants.get(id2);
        if (participant == null) {
            participant = Participant.NULL;
        }
        return participant;
    }

    public List<Participant> getGroupConversationParticipants() {
        return this.groupConversationParticipants;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRead() {
        return this.read;
    }

    public String getIntercomLinkSolution() {
        return this.intercomLinkSolution;
    }

    public Participant getLastAdmin() {
        ListIterator<Participant> iterator = new ArrayList<Participant>(this.participants.values()).listIterator(this.participants.values().size());
        while (iterator.hasPrevious()) {
            Participant participant = iterator.previous();
            if (!participant.isAdmin()) continue;
            return participant;
        }
        return Participant.NULL;
    }

    public Map<String, Participant> getParticipants() {
        return this.participants;
    }

    public LastParticipatingAdmin getLastParticipatingAdmin() {
        return this.lastParticipatingAdmin;
    }

    public ComposerState getComposerState() {
        return this.composerState;
    }

    public boolean shouldPreventEndUserReplies() {
        return this.preventEndUserReplies;
    }

    public boolean getInboundConversationsDisabled() {
        return this.inboundConversationsDisabled;
    }

    @NotificationStatuses
    public String getNotificationStatus() {
        return this.notificationStatus;
    }

    @ConversationState
    public String getState() {
        return this.state;
    }

    public ConversationHeaderStyle getHeaderStyle() {
        return this.headerStyle;
    }

    public boolean isInbound() {
        return this.isInbound;
    }

    public boolean isAdminReply() {
        return this.participants.size() > 1;
    }

    public boolean isRecentInboundConversation(long currentTime) {
        long tenDaysAgo = currentTime - 864000000L;
        return this.isInbound && "state_open".equals(this.state) && this.createdSince(tenDaysAgo);
    }

    public boolean createdSince(long timeInPastMillis) {
        return 1000L * this.getLastPart().getCreatedAt() > timeInPastMillis;
    }

    public ConversationUiFlags getUiFlags() {
        return this.uiFlags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conversation that = (Conversation)o;
        if (this.read != that.read) {
            return false;
        }
        if (!this.participants.equals(that.participants)) {
            return false;
        }
        if (!this.conversationParts.equals(that.conversationParts)) {
            return false;
        }
        if (!this.groupConversationParticipants.equals(that.groupConversationParticipants)) {
            return false;
        }
        if (!this.lastParticipatingAdmin.equals(that.lastParticipatingAdmin)) {
            return false;
        }
        if (!this.composerState.equals(that.composerState)) {
            return false;
        }
        if (!this.intercomLinkSolution.equals(that.intercomLinkSolution)) {
            return false;
        }
        if (this.preventEndUserReplies != that.preventEndUserReplies) {
            return false;
        }
        if (this.inboundConversationsDisabled != that.inboundConversationsDisabled) {
            return false;
        }
        if (!this.notificationStatus.equals(that.notificationStatus)) {
            return false;
        }
        if (!this.state.equals(that.state)) {
            return false;
        }
        if (this.isInbound != that.isInbound) {
            return false;
        }
        if (!this.ticket.equals(that.ticket)) {
            return false;
        }
        if (this.headerStyle != that.headerStyle) {
            return false;
        }
        if (this.uiFlags != that.uiFlags) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result2 = this.participants.hashCode();
        result2 = 31 * result2 + this.conversationParts.hashCode();
        result2 = 31 * result2 + this.groupConversationParticipants.hashCode();
        result2 = 31 * result2 + this.lastParticipatingAdmin.hashCode();
        result2 = 31 * result2 + this.composerState.hashCode();
        result2 = 31 * result2 + this.id.hashCode();
        result2 = 31 * result2 + (this.read ? 1 : 0);
        result2 = 31 * result2 + (this.preventEndUserReplies ? 1 : 0);
        result2 = 31 * result2 + (this.inboundConversationsDisabled ? 1 : 0);
        result2 = 31 * result2 + this.intercomLinkSolution.hashCode();
        result2 = 31 * result2 + this.notificationStatus.hashCode();
        result2 = 31 * result2 + this.state.hashCode();
        result2 = 31 * result2 + (this.isInbound ? 1 : 0);
        result2 = 31 * result2 + this.ticket.hashCode();
        result2 = 31 * result2 + this.headerStyle.hashCode();
        result2 = 31 * result2 + this.uiFlags.hashCode();
        return result2;
    }

    public Conversation withRead(boolean read) {
        return new Conversation(this.participants, this.conversationParts, this.groupConversationParticipants, this.lastParticipatingAdmin, this.composerState, this.id, read, this.intercomLinkSolution, this.preventEndUserReplies, this.inboundConversationsDisabled, this.notificationStatus, this.state, this.isInbound, this.ticket, this.headerStyle, this.uiFlags);
    }

    public Conversation withParts(List<Part> conversationParts) {
        return new Conversation(this.participants, conversationParts, this.groupConversationParticipants, this.lastParticipatingAdmin, this.composerState, this.id, this.read, this.intercomLinkSolution, this.preventEndUserReplies, this.inboundConversationsDisabled, this.notificationStatus, this.state, this.isInbound, this.ticket, this.headerStyle, this.uiFlags);
    }

    public static final class Builder {
        String id;
        boolean read;
        List<Participant.Builder> participants;
        List<Part.Builder> conversation_parts;
        List<String> group_conversation_participant_ids;
        LastParticipatingAdmin.Builder last_participating_admin;
        ComposerState.Builder composer_state;
        boolean user_participated;
        String intercom_link_solution;
        boolean prevent_end_user_replies;
        boolean inbound_conversations_disabled;
        String notification_status;
        String state;
        boolean is_inbound;
        @Nullable
        ConversationHeaderStyle ux_style;
        @Nullable
        Ticket ticket;
        ConversationUiFlags ui_flags;

        public Builder withId(String id2) {
            this.id = id2;
            return this;
        }

        public Builder withLastParticipatingAdmin(LastParticipatingAdmin.Builder lastParticipatingAdmin) {
            this.last_participating_admin = lastParticipatingAdmin;
            return this;
        }

        public Builder withParticipants(List<Participant.Builder> participants) {
            this.participants = participants;
            return this;
        }

        public Builder withParts(List<Part.Builder> parts) {
            this.conversation_parts = parts;
            return this;
        }

        public Builder withPreventUserReplies(boolean shouldPrevent) {
            this.prevent_end_user_replies = shouldPrevent;
            return this;
        }

        public Builder withInboundConversationsDisabled(boolean disabled) {
            this.inbound_conversations_disabled = disabled;
            return this;
        }

        public Builder withIsInbound(boolean isInbound) {
            this.is_inbound = isInbound;
            return this;
        }

        public Builder withState(String state) {
            this.state = state;
            return this;
        }

        public Builder withTicket(Ticket ticket) {
            this.ticket = ticket;
            return this;
        }

        public Builder withRead(Boolean read) {
            this.read = read;
            return this;
        }

        public Builder withConversationParts(List<Part.Builder> conversationParts) {
            this.conversation_parts = conversationParts;
            return this;
        }

        public Builder withGroupConversationParticipantIds(List<String> groupConversationParticipantIds) {
            this.group_conversation_participant_ids = groupConversationParticipantIds;
            return this;
        }

        public Builder withComposerState(ComposerState.Builder composerState) {
            this.composer_state = composerState;
            return this;
        }

        public Builder withUserParticipated(boolean userParticipated) {
            this.user_participated = userParticipated;
            return this;
        }

        public Builder withIntercomLinkSolution(String intercomLinkSolution) {
            this.intercom_link_solution = intercomLinkSolution;
            return this;
        }

        public Builder withNotificationStatus(String notificationStatus) {
            this.notification_status = notificationStatus;
            return this;
        }

        public Builder withConversationHeaderStyle(ConversationHeaderStyle style2) {
            this.ux_style = style2;
            return this;
        }

        public Builder withUiFlags(ConversationUiFlags uiFlags) {
            this.ui_flags = uiFlags;
            return this;
        }

        public Conversation build() {
            return new Conversation(this);
        }
    }
}

