/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.conversation.states.BottomBarUiState;
import io.intercom.android.sdk.m5.conversation.states.ComposerState;
import io.intercom.android.sdk.m5.conversation.states.ConversationClientState;
import io.intercom.android.sdk.models.ActiveBot;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.extensions.AppConfigExtensionsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a$\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"reduceComposerState", "Lio/intercom/android/sdk/m5/conversation/states/BottomBarUiState;", "clientState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "config", "Lio/intercom/android/sdk/identity/AppConfig;", "composerSuggestions", "Lio/intercom/android/sdk/models/ComposerSuggestions;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "reduceTextInput", "Lio/intercom/android/sdk/m5/conversation/states/ComposerState;", "conversation", "Lio/intercom/android/sdk/models/Conversation;", "activeBot", "Lio/intercom/android/sdk/models/ActiveBot;", "currentState", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nComposerStateReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerStateReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/ComposerStateReducerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1747#2,3:92\n*S KotlinDebug\n*F\n+ 1 ComposerStateReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/ComposerStateReducerKt\n*L\n69#1:92,3\n*E\n"})
public final class ComposerStateReducerKt {
    @NotNull
    public static final BottomBarUiState reduceComposerState(@NotNull ConversationClientState clientState, @NotNull AppConfig config, @NotNull ComposerSuggestions composerSuggestions, @NotNull TeamPresence teamPresence) {
        ComposerState composerState;
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)composerSuggestions, (String)"composerSuggestions");
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        Conversation conversation = clientState.getConversation();
        if (conversation == null) {
            composerState = composerSuggestions.isComposerDisabled() ? (ComposerState)new ComposerState.Hidden(false, 1, null) : ComposerStateReducerKt.reduceTextInput(null, teamPresence.getActiveBot(), clientState.getComposerState());
        } else {
            boolean hasReactions;
            boolean allowStartingNewConversation = AppConfigExtensionsKt.canStartNewConversation(config) && !conversation.getInboundConversationsDisabled();
            Pair pair = allowStartingNewConversation && clientState.getStartNewConvCtaData() != null ? new Pair((Object)clientState.getStartNewConvCtaData().getText(), (Object)clientState.getStartNewConvCtaData().getIcon().getIcon()) : new Pair(null, null);
            String ctaTitle = (String)pair.component1();
            Integer trailingIcon = (Integer)pair.component2();
            ComposerState.ConversationEnded conversationEndedState = new ComposerState.ConversationEnded(allowStartingNewConversation, ctaTitle, trailingIcon);
            boolean bl = hasReactions = !ReactionReply.isNull(conversation.getLastPart().getReactionReply());
            if (conversation.shouldPreventEndUserReplies()) {
                composerState = conversationEndedState;
            } else if (conversation.getComposerState().isVisible() && !hasReactions) {
                composerState = ComposerStateReducerKt.reduceTextInput(conversation, teamPresence.getActiveBot(), clientState.getComposerState());
            } else if (hasReactions) {
                ReactionReply reactionReply = conversation.getLastPart().getReactionReply();
                Intrinsics.checkNotNullExpressionValue((Object)reactionReply, (String)"conversation.lastPart.reactionReply");
                String string2 = conversation.getLastPart().getId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"conversation.lastPart.id");
                String string3 = conversation.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"conversation.id");
                composerState = new ComposerState.Reactions(reactionReply, string2, string3);
            } else {
                boolean bl2;
                block11: {
                    List<Part> list = conversation.getParts();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"conversation.parts");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Part it = (Part)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getMessageStyle(), (Object)"attribute_collector")) continue;
                            bl2 = true;
                            break block11;
                        }
                        bl2 = false;
                    }
                }
                boolean bl4 = !bl2;
                composerState = new ComposerState.Hidden(bl4);
            }
        }
        ComposerState composerState2 = composerState;
        return new BottomBarUiState(composerState2, clientState.getCurrentlyTypingState());
    }

    private static final ComposerState reduceTextInput(Conversation conversation, ActiveBot activeBot, ComposerState currentState) {
        return currentState instanceof ComposerState.TextInput ? (ComposerState)ComposerState.TextInput.copy$default((ComposerState.TextInput)currentState, null, R.string.intercom_message_placeholder, 1, null) : currentState;
    }
}

