/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.home.reducers;

import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.components.ErrorState;
import io.intercom.android.sdk.m5.components.TicketHeaderType;
import io.intercom.android.sdk.m5.components.avatar.AvatarWrapper;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeLocation;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeState;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeStateReducer;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomLinkSolution;
import io.intercom.android.sdk.m5.home.data.HomeCards;
import io.intercom.android.sdk.m5.home.data.HomeV2Response;
import io.intercom.android.sdk.m5.home.reducers.HomeHeaderStateReducerKt;
import io.intercom.android.sdk.m5.home.states.HomeClientState;
import io.intercom.android.sdk.m5.home.states.HomeUiState;
import io.intercom.android.sdk.models.ActiveBot;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.Space;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.tickets.list.reducers.TicketHeaderReducerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ#\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003H\u0000\u00a2\u0006\u0002\b\u0010R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/intercom/android/sdk/m5/home/reducers/HomeReducer;", "", "config", "Lkotlin/Function0;", "Lio/intercom/android/sdk/identity/AppConfig;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "badgeStateReducer", "Lio/intercom/android/sdk/m5/components/intercombadge/IntercomBadgeStateReducer;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "computeUiState", "Lio/intercom/android/sdk/m5/home/states/HomeUiState;", "homeClientState", "Lio/intercom/android/sdk/m5/home/states/HomeClientState;", "onRetryClicked", "", "computeUiState$intercom_sdk_base_release", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nHomeReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HomeReducer.kt\nio/intercom/android/sdk/m5/home/reducers/HomeReducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n819#2:78\n847#2,2:79\n1549#2:81\n1620#2,3:82\n1#3:85\n*S KotlinDebug\n*F\n+ 1 HomeReducer.kt\nio/intercom/android/sdk/m5/home/reducers/HomeReducer\n*L\n47#1:78\n47#1:79,2\n52#1:81\n52#1:82,3\n*E\n"})
public final class HomeReducer {
    @NotNull
    private final Function0<AppConfig> config;
    @NotNull
    private final Function0<TeamPresence> teamPresence;
    @NotNull
    private final Function0<IntercomBadgeStateReducer> badgeStateReducer;

    public HomeReducer(@NotNull Function0<AppConfig> config, @NotNull Function0<? extends TeamPresence> teamPresence, @NotNull Function0<IntercomBadgeStateReducer> badgeStateReducer) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Intrinsics.checkNotNullParameter(teamPresence, (String)"teamPresence");
        Intrinsics.checkNotNullParameter(badgeStateReducer, (String)"badgeStateReducer");
        this.config = config;
        this.teamPresence = teamPresence;
        this.badgeStateReducer = badgeStateReducer;
    }

    public /* synthetic */ HomeReducer(Function0 function0, Function0 function02, Function0 function03, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function02 = 2.INSTANCE;
        }
        if ((n & 4) != 0) {
            function03 = 3.INSTANCE;
        }
        this((Function0<AppConfig>)function0, (Function0<? extends TeamPresence>)function02, (Function0<IntercomBadgeStateReducer>)function03);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HomeUiState computeUiState$intercom_sdk_base_release(@NotNull HomeClientState homeClientState, @NotNull Function0<Unit> onRetryClicked) {
        HomeUiState homeUiState;
        Intrinsics.checkNotNullParameter((Object)homeClientState, (String)"homeClientState");
        Intrinsics.checkNotNullParameter(onRetryClicked, (String)"onRetryClicked");
        NetworkResponse<HomeV2Response> networkResponse = homeClientState.getHomeResponse();
        if (networkResponse instanceof NetworkResponse.ClientError ? true : networkResponse instanceof NetworkResponse.ServerError) {
            homeUiState = new HomeUiState.Error(IntercomBadgeState.Hidden.INSTANCE, new ErrorState.WithoutCTA(0, 0, null, 7, null), HomeHeaderStateReducerKt.computeErrorHeader(((AppConfig)this.config.invoke()).getConfigModules()));
        } else if (networkResponse instanceof NetworkResponse.NetworkError) {
            homeUiState = new HomeUiState.Error(IntercomBadgeState.Hidden.INSTANCE, new ErrorState.WithCTA(0, 0, null, 0, onRetryClicked, 15, null), HomeHeaderStateReducerKt.computeErrorHeader(((AppConfig)this.config.invoke()).getConfigModules()));
        } else if (networkResponse instanceof NetworkResponse.Success) {
            AvatarWrapper avatarWrapper;
            Participant.Builder builder;
            Collection<AvatarWrapper> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object it;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Object object = ((HomeV2Response)((NetworkResponse.Success)networkResponse).getBody()).getCards();
            IntercomBadgeState intercomBadgeState = ((IntercomBadgeStateReducer)this.badgeStateReducer.invoke()).computeIntercomBadgeState(IntercomBadgeLocation.Home.INSTANCE, IntercomLinkSolution.LIVE_CHAT);
            boolean $i$f$filterNot = false;
            Participant participant = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (HomeCards)element$iv$iv;
                boolean bl = false;
                if (it instanceof HomeCards.HomeNewConversationData && ((HomeCards.HomeNewConversationData)it).getPreventMultipleInboundConversationsEnabled() && !((Collection)((HomeCards.HomeNewConversationData)it).getOpenInboundConversationsIds()).isEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List<Participant> list = ((TeamPresence)this.teamPresence.invoke()).getActiveAdmins();
            Intrinsics.checkNotNullExpressionValue(list, (String)"teamPresence().activeAdmins");
            $this$filterNot$iv = list;
            List list2 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Participant)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Avatar avatar = ((Participant)it).getAvatar();
                Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"it.avatar");
                Boolean bl2 = ((Participant)it).isBot();
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"it.isBot");
                collection.add(new AvatarWrapper(avatar, bl2, null, false, false, 28, null));
            }
            collection = (List)destination$iv$iv;
            IntercomBadgeState intercomBadgeState2 = intercomBadgeState;
            List list3 = list2;
            Collection collection2 = collection;
            object = ((TeamPresence)this.teamPresence.invoke()).getActiveBot();
            if (object != null && (builder = ((ActiveBot)object).getParticipant()) != null && (participant = builder.build()) != null) {
                void it2;
                Participant $i$f$mapTo2 = participant;
                collection = collection2;
                list2 = list3;
                intercomBadgeState = intercomBadgeState2;
                boolean bl = false;
                Avatar avatar = it2.getAvatar();
                Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"it.avatar");
                Boolean bl3 = it2.isBot();
                Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"it.isBot");
                AvatarWrapper avatarWrapper2 = new AvatarWrapper(avatar, bl3, null, false, false, 28, null);
                intercomBadgeState2 = intercomBadgeState;
                list3 = list2;
                collection2 = collection;
                avatarWrapper = avatarWrapper2;
            } else {
                avatarWrapper = null;
            }
            HomeUiState.Content.ContentHeader contentHeader = HomeHeaderStateReducerKt.computeContentHeader(((AppConfig)this.config.invoke()).getConfigModules(), (TeamPresence)this.teamPresence.invoke(), homeClientState.isHeaderImageLoaded());
            TicketHeaderType ticketHeaderType = TicketHeaderReducerKt.reduceTicketHeaderType(((AppConfig)this.config.invoke()).isSpaceEnabled(Space.Type.TICKETS));
            boolean bl = ((AppConfig)this.config.invoke()).isAccessToTeammateEnabled();
            AvatarWrapper avatarWrapper3 = avatarWrapper;
            List list4 = collection2;
            List list5 = list3;
            IntercomBadgeState intercomBadgeState3 = intercomBadgeState2;
            homeUiState = new HomeUiState.Content(intercomBadgeState3, list5, list4, avatarWrapper3, bl, ticketHeaderType, contentHeader);
        } else if (networkResponse == null) {
            homeUiState = new HomeUiState.Loading(((IntercomBadgeStateReducer)this.badgeStateReducer.invoke()).computeIntercomBadgeState(IntercomBadgeLocation.Home.INSTANCE, IntercomLinkSolution.LIVE_CHAT));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return homeUiState;
    }

    public HomeReducer() {
        this(null, null, null, 7, null);
    }
}

