/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeLocation;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeState;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeStateReducer;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomLinkSolution;
import io.intercom.android.sdk.m5.conversation.reducers.ComposerStateReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.ConversationPartsReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.ErrorReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.HeaderReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.TeamPresenceReducer;
import io.intercom.android.sdk.m5.conversation.states.BottomBarUiState;
import io.intercom.android.sdk.m5.conversation.states.ContentRow;
import io.intercom.android.sdk.m5.conversation.states.ConversationClientState;
import io.intercom.android.sdk.m5.conversation.states.ConversationHeader;
import io.intercom.android.sdk.m5.conversation.states.ConversationUiState;
import io.intercom.android.sdk.m5.conversation.states.NetworkState;
import io.intercom.android.sdk.m5.conversation.states.PendingMessage;
import io.intercom.android.sdk.m5.conversation.states.SharpCornersShape;
import io.intercom.android.sdk.m5.conversation.utils.PartExtensionsKt;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.models.ActiveBot;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationHeaderStyle;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Suggestion;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.state.BotIntroState;
import io.intercom.android.sdk.ui.ReplySuggestion;
import io.intercom.android.sdk.utilities.commons.TimeProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001By\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/intercom/android/sdk/m5/conversation/reducers/ConversationReducer;", "", "config", "Lkotlin/Function0;", "Lio/intercom/android/sdk/identity/AppConfig;", "composerSuggestions", "Lio/intercom/android/sdk/models/ComposerSuggestions;", "botIntro", "Lio/intercom/android/sdk/state/BotIntroState;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "badgeStateReducer", "Lio/intercom/android/sdk/m5/components/intercombadge/IntercomBadgeStateReducer;", "timeProvider", "Lio/intercom/android/sdk/utilities/commons/TimeProvider;", "intercomDataLayer", "Lio/intercom/android/sdk/m5/data/IntercomDataLayer;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lio/intercom/android/sdk/utilities/commons/TimeProvider;Lio/intercom/android/sdk/m5/data/IntercomDataLayer;)V", "computeUiState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationUiState;", "clientState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "computeUiState$intercom_sdk_base_release", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nConversationReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversationReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/ConversationReducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n1549#2:234\n1620#2,3:235\n1559#2:238\n1590#2,4:239\n1549#2:243\n1620#2,3:244\n1549#2:247\n1620#2,3:248\n1864#2,3:251\n*S KotlinDebug\n*F\n+ 1 ConversationReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/ConversationReducer\n*L\n115#1:234\n115#1:235,3\n126#1:238\n126#1:239,4\n168#1:243\n168#1:244,3\n179#1:247\n179#1:248,3\n188#1:251,3\n*E\n"})
public final class ConversationReducer {
    @NotNull
    private final Function0<AppConfig> config;
    @NotNull
    private final Function0<ComposerSuggestions> composerSuggestions;
    @NotNull
    private final Function0<BotIntroState> botIntro;
    @NotNull
    private final Function0<UserIdentity> userIdentity;
    @NotNull
    private final Function0<TeamPresence> teamPresence;
    @NotNull
    private final Function0<IntercomBadgeStateReducer> badgeStateReducer;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final IntercomDataLayer intercomDataLayer;

    public ConversationReducer(@NotNull Function0<AppConfig> config, @NotNull Function0<? extends ComposerSuggestions> composerSuggestions, @NotNull Function0<BotIntroState> botIntro, @NotNull Function0<? extends UserIdentity> userIdentity, @NotNull Function0<? extends TeamPresence> teamPresence, @NotNull Function0<IntercomBadgeStateReducer> badgeStateReducer, @NotNull TimeProvider timeProvider, @NotNull IntercomDataLayer intercomDataLayer) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Intrinsics.checkNotNullParameter(composerSuggestions, (String)"composerSuggestions");
        Intrinsics.checkNotNullParameter(botIntro, (String)"botIntro");
        Intrinsics.checkNotNullParameter(userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter(teamPresence, (String)"teamPresence");
        Intrinsics.checkNotNullParameter(badgeStateReducer, (String)"badgeStateReducer");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)intercomDataLayer, (String)"intercomDataLayer");
        this.config = config;
        this.composerSuggestions = composerSuggestions;
        this.botIntro = botIntro;
        this.userIdentity = userIdentity;
        this.teamPresence = teamPresence;
        this.badgeStateReducer = badgeStateReducer;
        this.timeProvider = timeProvider;
        this.intercomDataLayer = intercomDataLayer;
    }

    public /* synthetic */ ConversationReducer(Function0 function0, Function0 function02, Function0 function03, Function0 function04, Function0 function05, Function0 function06, TimeProvider timeProvider, IntercomDataLayer intercomDataLayer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function02 = 2.INSTANCE;
        }
        if ((n & 4) != 0) {
            function03 = 3.INSTANCE;
        }
        if ((n & 8) != 0) {
            function04 = 4.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function05 = 5.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            function06 = 6.INSTANCE;
        }
        if ((n & 0x40) != 0) {
            TimeProvider timeProvider2 = TimeProvider.SYSTEM;
            Intrinsics.checkNotNullExpressionValue((Object)timeProvider2, (String)"SYSTEM");
            timeProvider = timeProvider2;
        }
        if ((n & 0x80) != 0) {
            IntercomDataLayer intercomDataLayer2 = Injector.get().getDataLayer();
            Intrinsics.checkNotNullExpressionValue((Object)intercomDataLayer2, (String)"get().dataLayer");
            intercomDataLayer = intercomDataLayer2;
        }
        this((Function0<AppConfig>)function0, (Function0<? extends ComposerSuggestions>)function02, (Function0<BotIntroState>)function03, (Function0<? extends UserIdentity>)function04, (Function0<? extends TeamPresence>)function05, (Function0<IntercomBadgeStateReducer>)function06, timeProvider, intercomDataLayer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConversationUiState computeUiState$intercom_sdk_base_release(@NotNull ConversationClientState clientState) {
        ConversationUiState conversationUiState;
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Conversation conversation = clientState.getConversation();
        String conversationId = clientState.getConversationId();
        NetworkResponse<Conversation.Builder> lastNetworkCall = clientState.getLastNetworkCall();
        boolean isLoadingExistingConversation = conversation == null && conversationId != null;
        if (isLoadingExistingConversation && lastNetworkCall != null && !(lastNetworkCall instanceof NetworkResponse.Success)) {
            conversationUiState = ErrorReducerKt.reduceError(lastNetworkCall);
        } else if (isLoadingExistingConversation) {
            Conversation conversation2 = this.intercomDataLayer.getConversationById(conversationId);
            ConversationHeaderStyle conversationHeaderStyle = conversation2 != null ? conversation2.getHeaderStyle() : null;
            conversationUiState = new ConversationUiState.Loading(conversationHeaderStyle == null ? ConversationHeaderStyle.NONE : conversationHeaderStyle);
        } else {
            int partsSize;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<Part> list;
            Iterable<Part> $i$f$map3;
            String string2;
            int n;
            Object object;
            void $this$mapIndexed$iv;
            Collection collection;
            boolean shouldShowTemporaryExpectationsRow;
            boolean bl;
            boolean hasTemporaryExpectationsMessage;
            List list2;
            ConversationHeader headerState = HeaderReducerKt.reduceHeader(clientState.getConversation(), (AppConfig)this.config.invoke(), (TeamPresence)this.teamPresence.invoke(), !clientState.getPendingMessages().isEmpty());
            NetworkState networkState = clientState.getNetworkState();
            BottomBarUiState bottomBarUiState = ComposerStateReducerKt.reduceComposerState(clientState, (AppConfig)this.config.invoke(), (ComposerSuggestions)this.composerSuggestions.invoke(), (TeamPresence)this.teamPresence.invoke());
            List $this$computeUiState_u24lambda_u246 = list2 = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            boolean bl3 = hasTemporaryExpectationsMessage = !StringsKt.isBlank((CharSequence)((AppConfig)this.config.invoke()).getTemporaryExpectationsMessage());
            if (conversation != null) {
                bl = !conversation.getLastParticipatingAdmin().isBot() && hasTemporaryExpectationsMessage;
            } else {
                ActiveBot activeBot = ((TeamPresence)this.teamPresence.invoke()).getActiveBot();
                bl = shouldShowTemporaryExpectationsRow = (activeBot != null ? !activeBot.getUseBotUx() : false) && hasTemporaryExpectationsMessage;
            }
            if (shouldShowTemporaryExpectationsRow) {
                $this$computeUiState_u24lambda_u246.add(new ContentRow.TemporaryExpectationRow(((AppConfig)this.config.invoke()).getTemporaryExpectationsMessage()));
            }
            boolean botIntroIsEmpty = ((BotIntroState)this.botIntro.invoke()).getBotIntro().getBlocks().isEmpty();
            ContentRow.TeamPresenceRow.Position position = conversationId == null && clientState.getPendingMessages().isEmpty() && botIntroIsEmpty ? ContentRow.TeamPresenceRow.Position.CENTERED : ContentRow.TeamPresenceRow.Position.PINNED;
            $this$computeUiState_u24lambda_u246.add(new ContentRow.TeamPresenceRow(TeamPresenceReducer.INSTANCE.getTeamPresenceState(clientState.getConversation(), (TeamPresence)this.teamPresence.invoke(), (AppConfig)this.config.invoke()), position));
            if (conversation == null) {
                boolean hasNoAdditionalParts;
                boolean bl4 = hasNoAdditionalParts = clientState.getPendingMessages().isEmpty() && ((ComposerSuggestions)this.composerSuggestions.invoke()).getSuggestions().isEmpty();
                if (!botIntroIsEmpty) {
                    void $this$mapIndexedTo$iv$iv;
                    Part part;
                    int n2;
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv2;
                    $this$computeUiState_u24lambda_u246.add(new ContentRow.DayDividerRow(this.timeProvider.currentTimeMillis() / (long)1000));
                    Iterable iterable = ((BotIntroState)this.botIntro.invoke()).getBotIntro().getBlocks();
                    boolean $i$f$map2 = false;
                    void var20_27 = $this$map$iv2;
                    Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        List list3 = (List)item$iv$iv;
                        collection = destination$iv$iv;
                        n2 = 0;
                        Part $this$computeUiState_u24lambda_u246_u24lambda_u241_u24lambda_u240 = part = new Part.Builder().withBlocks((List<Block.Builder>)it).withParticipantIsAdmin(true).withCreatedAt(this.timeProvider.currentTimeMillis()).build();
                        boolean bl5 = false;
                        $this$computeUiState_u24lambda_u246_u24lambda_u241_u24lambda_u240.setParticipant(((BotIntroState)this.botIntro.invoke()).getBotIntro().getBuiltParticipant());
                        collection.add(part);
                    }
                    List botIntroParts = (List)destination$iv$iv;
                    $this$map$iv2 = botIntroParts;
                    collection = $this$computeUiState_u24lambda_u246;
                    boolean $i$f$mapIndexed = false;
                    $this$mapTo$iv$iv2 = $this$mapIndexed$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo = false;
                    int index$iv$iv = 0;
                    for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        void index;
                        void part2;
                        if ((n2 = index$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        part = (Part)item$iv$iv;
                        int $this$computeUiState_u24lambda_u246_u24lambda_u241_u24lambda_u240 = n2;
                        object = destination$iv$iv;
                        boolean bl6 = false;
                        boolean showAvatarIfAvailable = !Intrinsics.areEqual((Object)part2.getMessageStyle(), (Object)"quick_reply") && !PartExtensionsKt.hasNextConcatPart(botIntroParts, (int)index);
                        boolean isGrouped = PartExtensionsKt.hasNextConcatPart(botIntroParts, (int)index);
                        n = index == CollectionsKt.getLastIndex((List)botIntroParts) && hasNoAdditionalParts ? 1 : 0;
                        string2 = ((AppConfig)this.config.invoke()).getName();
                        SharpCornersShape sharpCornersShape = ConversationPartsReducerKt.getSharpCornersShape(botIntroParts, (int)index, true);
                        Intrinsics.checkNotNullExpressionValue((Object)part2, (String)"part");
                        object.add(new ContentRow.MessageRow(new ContentRow.MessageRow.PartWrapper((Part)part2, n != 0, null, true, showAvatarIfAvailable, string2, false, isGrouped, sharpCornersShape, null, null, 1536, null)));
                    }
                    collection.addAll((List)destination$iv$iv);
                }
            }
            $this$computeUiState_u24lambda_u246.addAll((Collection)ConversationPartsReducerKt.reduceMessages(clientState, (UserIdentity)this.userIdentity.invoke(), (AppConfig)this.config.invoke()));
            if (conversation == null && clientState.getPendingMessages().isEmpty()) {
                List<Suggestion> list4 = ((ComposerSuggestions)this.composerSuggestions.invoke()).getSuggestions();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"composerSuggestions().suggestions");
                if (!((Collection)list4).isEmpty()) {
                    Collection<ReplySuggestion> collection2;
                    void $this$mapTo$iv$iv3;
                    void $this$map$iv3;
                    String string3 = ((ComposerSuggestions)this.composerSuggestions.invoke()).getPrompt();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"composerSuggestions().prompt");
                    List<Suggestion> list5 = ((ComposerSuggestions)this.composerSuggestions.invoke()).getSuggestions();
                    Intrinsics.checkNotNullExpressionValue(list5, (String)"composerSuggestions().suggestions");
                    Iterable hasNoAdditionalParts = list5;
                    String string4 = string3;
                    collection = $this$computeUiState_u24lambda_u246;
                    boolean $i$f$map3 = false;
                    $this$mapIndexed$iv = $this$map$iv3;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        void it;
                        Suggestion index$iv$iv = (Suggestion)item$iv$iv;
                        collection2 = destination$iv$iv;
                        boolean bl7 = false;
                        String string5 = it.getUuid();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.uuid");
                        String string6 = it.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"it.text");
                        collection2.add(new ReplySuggestion(string5, string6));
                    }
                    collection2 = (List)destination$iv$iv;
                    List list6 = collection2;
                    String string7 = string4;
                    collection.add(new ContentRow.ComposerSuggestionRow(string7, list6));
                }
            }
            Conversation conversation3 = clientState.getConversation();
            List<Part> list7 = $i$f$map3 = conversation3 != null ? conversation3.getParts() : null;
            if (list7 == null) {
                list = CollectionsKt.emptyList();
            } else {
                Intrinsics.checkNotNullExpressionValue(list7, (String)"clientState.conversation?.parts ?: emptyList()");
                list = $i$f$map3;
            }
            $i$f$map3 = clientState.getPendingMessages().values();
            collection = list;
            boolean $i$f$map4 = false;
            void destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void pending;
                PendingMessage bl7 = (PendingMessage)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl8 = false;
                object.add(pending.getPart());
            }
            List allConcatParts = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
            Object object2 = clientState.getConversation();
            int n3 = object2 != null && (object2 = ((Conversation)object2).getParts()) != null ? object2.size() : (partsSize = 0);
            if (clientState.getConversation() == null && !clientState.getPendingMessages().isEmpty() && botIntroIsEmpty) {
                $this$computeUiState_u24lambda_u246.add(new ContentRow.DayDividerRow(this.timeProvider.currentTimeMillis() / (long)1000));
            }
            Iterable $this$forEachIndexed$iv = clientState.getPendingMessages().values();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void it;
                int n4;
                if ((n4 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                PendingMessage pending = (PendingMessage)item$iv;
                int index = n4;
                boolean bl9 = false;
                int lastConcatPartsIndex = partsSize + index;
                boolean showAvatarIfAvailable = !Intrinsics.areEqual((Object)it.getPart().getMessageStyle(), (Object)"quick_reply") && !PartExtensionsKt.hasNextConcatPart(allConcatParts, lastConcatPartsIndex);
                boolean isGrouped = PartExtensionsKt.hasNextConcatPart(allConcatParts, lastConcatPartsIndex);
                Part part = it.getPart();
                boolean bl10 = index == clientState.getPendingMessages().size() - 1;
                n = it.isFailed() || it.getFailedImageUploadData() != null ? R.string.intercom_failed_delivery : R.string.intercom_message_state_sending;
                string2 = ((AppConfig)this.config.invoke()).getName();
                boolean bl11 = it.isFailed();
                PendingMessage.FailedImageUploadData failedImageUploadData = it.getFailedImageUploadData();
                SharpCornersShape sharpCornersShape = ConversationPartsReducerKt.getSharpCornersShape(allConcatParts, lastConcatPartsIndex, false);
                $this$computeUiState_u24lambda_u246.add(new ContentRow.MessageRow(new ContentRow.MessageRow.PartWrapper(part, bl10, n, false, showAvatarIfAvailable, string2, bl11, isGrouped, sharpCornersShape, failedImageUploadData, null, 1024, null)));
            }
            IntercomBadgeState intercomBadgeState = ((IntercomBadgeStateReducer)this.badgeStateReducer.invoke()).computeIntercomBadgeState(new IntercomBadgeLocation.Conversation(clientState.isLaunchedProgrammatically()), IntercomLinkSolution.LIVE_CHAT);
            if (intercomBadgeState instanceof IntercomBadgeState.Shown) {
                $this$computeUiState_u24lambda_u246.add(new ContentRow.IntercomBadgeRow(((IntercomBadgeState.Shown)intercomBadgeState).getUrl()));
            }
            List list8 = CollectionsKt.build((List)list2);
            conversationUiState = new ConversationUiState.Content(headerState, list8, bottomBarUiState, networkState);
        }
        return conversationUiState;
    }

    public ConversationReducer() {
        this(null, null, null, null, null, null, null, null, 255, null);
    }
}

