/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.models.ActiveBot;
import io.intercom.android.sdk.models.AutoValue_TeamPresence;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.utilities.NullSafety;
import io.intercom.android.sdk.utilities.commons.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

@AutoValue
public abstract class TeamPresence {
    public static TeamPresence create(List<Participant> activeAdmins, @Nullable ActiveBot activeBot, String expectedResponseDelayShortText, String expectedResponseDelayLongText, String officeHours) {
        return new AutoValue_TeamPresence(activeAdmins, activeBot, expectedResponseDelayShortText, expectedResponseDelayLongText, officeHours);
    }

    public abstract List<Participant> getActiveAdmins();

    @Nullable
    public abstract ActiveBot getActiveBot();

    public abstract String getExpectedResponseDelayShortText();

    public abstract String getExpectedResponseDelayLongText();

    public abstract String getOfficeHours();

    public boolean isEmpty() {
        return this.getActiveAdmins().isEmpty() && this.getExpectedResponseDelayLongText().isEmpty();
    }

    public static final class Builder {
        @Nullable
        List<Participant.Builder> active_admins;
        @Nullable
        ActiveBot active_bot;
        @Nullable
        String expected_response_delay_short_text;
        @Nullable
        String expected_response_delay_long_text;
        @Nullable
        String office_hours;

        public TeamPresence build() {
            ArrayList<Participant> activeAdmins = new ArrayList<Participant>(CollectionUtils.capacityFor(this.active_admins));
            if (this.active_admins != null) {
                for (Participant.Builder participantBuilder : this.active_admins) {
                    if (participantBuilder == null) continue;
                    activeAdmins.add(participantBuilder.build());
                }
            }
            return TeamPresence.create(activeAdmins, this.active_bot, NullSafety.valueOrEmpty(this.expected_response_delay_short_text), NullSafety.valueOrEmpty(this.expected_response_delay_long_text), NullSafety.valueOrEmpty(this.office_hours));
        }
    }
}

