/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import io.intercom.android.sdk.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/intercom/android/sdk/helpcenter/utils/PaddedDividerItemDecoration;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "padding", "", "dividerDrawable", "Landroid/graphics/drawable/Drawable;", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
public final class PaddedDividerItemDecoration
extends RecyclerView.ItemDecoration {
    @NotNull
    private final Context context;
    private final int padding;
    @Nullable
    private Drawable dividerDrawable;
    public static final int $stable = 8;

    public PaddedDividerItemDecoration(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.padding = (int)TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
        this.dividerDrawable = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.intercom_list_divider);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public void onDraw(@NotNull Canvas canvas, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int left = parent.getPaddingLeft() + this.padding;
        int right = parent.getWidth() - parent.getPaddingRight() - this.padding;
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (adapter != null) {
            int n = parent.getChildCount() - 1;
            for (int i = 0; i < n; ++i) {
                View child = parent.getChildAt(i);
                int childAdapterPosition = parent.getChildAdapterPosition(child);
                if (childAdapterPosition == -1) {
                    return;
                }
                int top = child.getBottom();
                Drawable drawable2 = this.dividerDrawable;
                int bottom = top + (drawable2 != null ? drawable2.getIntrinsicHeight() : 0);
                Drawable drawable3 = this.dividerDrawable;
                if (drawable3 != null) {
                    drawable3.setBounds(left, top, right, bottom);
                }
                Drawable drawable4 = this.dividerDrawable;
                if (drawable4 == null) continue;
                drawable4.draw(canvas);
            }
        }
    }
}

