/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities.extensions;

import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.models.MessageStyle;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReplyOption;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u001a\u001a\u0010\r\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u001a\u0010\u0011\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a8\u0006\u0012"}, d2={"nextPartFromSameParticipant", "", "Lio/intercom/android/sdk/models/Part;", "nextPart", "isTypingPart", "isAttributeCollector", "isLinkCard", "isQuickReplyOnly", "isSingleBlockPartOfType", "type", "Lio/intercom/android/sdk/blocks/lib/BlockType;", "shouldConcatenate", "part", "hasPreviousConcatPartNewStyle", "", "index", "", "hasNextConcatPartNewStyle", "intercom-sdk-base_release"})
public final class PartExtensionsKt {
    public static final boolean nextPartFromSameParticipant(@NotNull Part $this$nextPartFromSameParticipant, @NotNull Part nextPart) {
        Intrinsics.checkNotNullParameter((Object)$this$nextPartFromSameParticipant, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)nextPart, (String)"nextPart");
        return Intrinsics.areEqual((Object)$this$nextPartFromSameParticipant.getParticipantId(), (Object)nextPart.getParticipantId());
    }

    public static final boolean isTypingPart(@NotNull Part $this$isTypingPart) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypingPart, (String)"<this>");
        return $this$isTypingPart.getMessageStyle() == MessageStyle.ADMIN_IS_TYPING_STYLE;
    }

    public static final boolean isAttributeCollector(@NotNull Part $this$isAttributeCollector) {
        Intrinsics.checkNotNullParameter((Object)$this$isAttributeCollector, (String)"<this>");
        return $this$isAttributeCollector.getMessageStyle() == MessageStyle.ATTRIBUTE_COLLECTOR && !((Collection)$this$isAttributeCollector.getForm().getAttributes()).isEmpty();
    }

    public static final boolean isLinkCard(@NotNull Part $this$isLinkCard) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkCard, (String)"<this>");
        return PartExtensionsKt.isSingleBlockPartOfType($this$isLinkCard, BlockType.LINK) && MessageStyle.CHAT == $this$isLinkCard.getMessageStyle();
    }

    public static final boolean isQuickReplyOnly(@NotNull Part $this$isQuickReplyOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$isQuickReplyOnly, (String)"<this>");
        List<ReplyOption> list = $this$isQuickReplyOnly.getReplyOptions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getReplyOptions(...)");
        return !((Collection)list).isEmpty() && $this$isQuickReplyOnly.getBlocks().isEmpty();
    }

    private static final boolean isSingleBlockPartOfType(Part $this$isSingleBlockPartOfType, BlockType type2) {
        return $this$isSingleBlockPartOfType.getBlocks().size() == 1 && $this$isSingleBlockPartOfType.getBlocks().get(0).getType() == type2;
    }

    private static final boolean shouldConcatenate(Part part, Part nextPart) {
        return PartExtensionsKt.nextPartFromSameParticipant(part, nextPart) && Math.abs(nextPart.getCreatedAt() - part.getCreatedAt()) < TimeUnit.MINUTES.toSeconds(3L) && !PartExtensionsKt.isTypingPart(part) && !PartExtensionsKt.isTypingPart(nextPart) && !PartExtensionsKt.isLinkCard(part) && !PartExtensionsKt.isLinkCard(nextPart) && part.isEvent() == false && nextPart.isEvent() == false && !PartExtensionsKt.isAttributeCollector(part) && !PartExtensionsKt.isAttributeCollector(nextPart) && !PartExtensionsKt.isQuickReplyOnly(part) && !PartExtensionsKt.isQuickReplyOnly(nextPart) && part.getMessageStyle() != MessageStyle.POST && nextPart.getMessageStyle() != MessageStyle.POST && part.getMessageStyle() != MessageStyle.NOTE && nextPart.getMessageStyle() != MessageStyle.NOTE;
    }

    public static final boolean hasPreviousConcatPartNewStyle(@NotNull List<? extends Part> $this$hasPreviousConcatPartNewStyle, int index) {
        Intrinsics.checkNotNullParameter($this$hasPreviousConcatPartNewStyle, (String)"<this>");
        return (1 <= index ? index <= CollectionsKt.getLastIndex($this$hasPreviousConcatPartNewStyle) : false) && PartExtensionsKt.shouldConcatenate($this$hasPreviousConcatPartNewStyle.get(index - 1), $this$hasPreviousConcatPartNewStyle.get(index));
    }

    public static final boolean hasNextConcatPartNewStyle(@NotNull List<? extends Part> $this$hasNextConcatPartNewStyle, int index) {
        Intrinsics.checkNotNullParameter($this$hasNextConcatPartNewStyle, (String)"<this>");
        return (0 <= index ? index < CollectionsKt.getLastIndex($this$hasNextConcatPartNewStyle) : false) && PartExtensionsKt.shouldConcatenate($this$hasNextConcatPartNewStyle.get(index), $this$hasNextConcatPartNewStyle.get(index + 1));
    }
}

