/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.utilities.Phrase;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\r"}, d2={"Lio/intercom/android/sdk/utilities/GroupConversationTextFormatter;", "", "<init>", "()V", "groupConversationTitle", "", "firstName", "", "otherParticipants", "", "context", "Landroid/content/Context;", "groupConversationSubtitle", "intercom-sdk-base_release"})
@StabilityInferred(parameters=1)
public final class GroupConversationTextFormatter {
    @NotNull
    public static final GroupConversationTextFormatter INSTANCE = new GroupConversationTextFormatter();
    public static final int $stable;

    private GroupConversationTextFormatter() {
    }

    @JvmStatic
    @NotNull
    public static final CharSequence groupConversationTitle(@NotNull String firstName, int otherParticipants, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)firstName, (String)"firstName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return otherParticipants == 1 ? (CharSequence)(firstName + context.getString(R.string.intercom_group_conversation_1_other_participant_count_short)) : (otherParticipants > 1 ? (CharSequence)(firstName + Phrase.from(context, R.string.intercom_group_conversation_multiple_other_participant_count_short).put("other_participant_count", otherParticipants).format()) : (CharSequence)firstName);
    }

    @JvmStatic
    @NotNull
    public static final CharSequence groupConversationSubtitle(@NotNull String firstName, int otherParticipants, @NotNull Context context) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)firstName, (String)"firstName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (otherParticipants == 1) {
            CharSequence charSequence2 = Phrase.from(context, R.string.intercom_name_and_1_other).put("name", firstName).format();
            Intrinsics.checkNotNull((Object)charSequence2);
            charSequence = charSequence2;
        } else if (otherParticipants > 1) {
            CharSequence charSequence3 = Phrase.from(context, R.string.intercom_name_and_x_others).put("name", firstName).put("count", otherParticipants).format();
            Intrinsics.checkNotNull((Object)charSequence3);
            charSequence = charSequence3;
        } else {
            charSequence = firstName;
        }
        return charSequence;
    }
}

