/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.content.Context;
import android.os.Bundle;
import androidx.compose.runtime.internal.StabilityInferred;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.push.IntercomNotificationHandler;
import io.intercom.android.sdk.m5.push.IntercomPushClientHandler;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.push.IntercomLegacyPushClientHandlerKt;
import io.intercom.android.sdk.push.PushHandler;
import io.intercom.android.sdk.push.PushPayload;
import io.intercom.android.sdk.push.SystemNotificationManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ4\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J>\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0016J\u000e\u0010!\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/intercom/android/sdk/push/IntercomLegacyPushClientHandler;", "", "pushClientHandler", "Lio/intercom/android/sdk/m5/push/IntercomPushClientHandler;", "legacyPushClientHandler", "Lio/intercom/android/sdk/push/PushHandler;", "<init>", "(Lio/intercom/android/sdk/m5/push/IntercomPushClientHandler;Lio/intercom/android/sdk/push/PushHandler;)V", "shouldSendDeviceToken", "", "context", "Landroid/content/Context;", "token", "", "sendTokenToIntercom", "", "api", "Lio/intercom/android/sdk/api/Api;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "appConfigProvider", "Lio/intercom/android/sdk/Provider;", "Lio/intercom/android/sdk/identity/AppConfig;", "handlePush", "message", "Landroid/os/Bundle;", "systemNotificationManager", "Lio/intercom/android/sdk/push/SystemNotificationManager;", "appBackgrounded", "localisedContext", "metricTracker", "Lio/intercom/android/sdk/metrics/MetricTracker;", "appConfig", "isIntercomPush", "Companion", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
public final class IntercomLegacyPushClientHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntercomPushClientHandler pushClientHandler;
    @NotNull
    private final PushHandler legacyPushClientHandler;
    public static final int $stable = 8;

    public IntercomLegacyPushClientHandler(@NotNull IntercomPushClientHandler pushClientHandler, @NotNull PushHandler legacyPushClientHandler) {
        Intrinsics.checkNotNullParameter((Object)pushClientHandler, (String)"pushClientHandler");
        Intrinsics.checkNotNullParameter((Object)legacyPushClientHandler, (String)"legacyPushClientHandler");
        this.pushClientHandler = pushClientHandler;
        this.legacyPushClientHandler = legacyPushClientHandler;
    }

    public /* synthetic */ IntercomLegacyPushClientHandler(IntercomPushClientHandler intercomPushClientHandler, PushHandler pushHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            intercomPushClientHandler = new IntercomPushClientHandler();
        }
        if ((n & 2) != 0) {
            pushHandler = new PushHandler();
        }
        this(intercomPushClientHandler, pushHandler);
    }

    public final boolean shouldSendDeviceToken(@NotNull Context context, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return IntercomLegacyPushClientHandlerKt.access$getNewPushNotificationEnabled() ? this.pushClientHandler.shouldSendDeviceToken(context, token) : this.legacyPushClientHandler.shouldSendDeviceToken(context, token);
    }

    public final void sendTokenToIntercom(@NotNull Context context, @NotNull String token, @NotNull Api api, @NotNull UserIdentity userIdentity, @NotNull Provider<AppConfig> appConfigProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter(appConfigProvider, (String)"appConfigProvider");
        if (IntercomLegacyPushClientHandlerKt.access$getNewPushNotificationEnabled()) {
            this.pushClientHandler.sendTokenToIntercom(context, token, api, userIdentity, appConfigProvider);
        } else {
            this.legacyPushClientHandler.sendTokenToIntercom(context, token, api, userIdentity, appConfigProvider);
        }
    }

    public final void handlePush(@NotNull Bundle message, @NotNull UserIdentity userIdentity, @NotNull SystemNotificationManager systemNotificationManager, boolean appBackgrounded, @NotNull Context localisedContext, @NotNull MetricTracker metricTracker, @NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter((Object)systemNotificationManager, (String)"systemNotificationManager");
        Intrinsics.checkNotNullParameter((Object)localisedContext, (String)"localisedContext");
        Intrinsics.checkNotNullParameter((Object)metricTracker, (String)"metricTracker");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        if (IntercomLegacyPushClientHandlerKt.access$getNewPushNotificationEnabled()) {
            this.pushClientHandler.handlePush(message, localisedContext, userIdentity);
        } else {
            this.legacyPushClientHandler.handlePush(message, userIdentity, systemNotificationManager, appBackgrounded, localisedContext, metricTracker, appConfig);
        }
    }

    public final boolean isIntercomPush(@NotNull Bundle message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return IntercomLegacyPushClientHandlerKt.access$getNewPushNotificationEnabled() ? this.pushClientHandler.isIntercomPush(message) : PushPayload.create(message).isIntercomPush();
    }

    public IntercomLegacyPushClientHandler() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lio/intercom/android/sdk/push/IntercomLegacyPushClientHandler$Companion;", "", "<init>", "()V", "clear", "", "systemNotificationManager", "Lio/intercom/android/sdk/push/SystemNotificationManager;", "context", "Landroid/content/Context;", "setUpNotificationChannels", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void clear(@NotNull SystemNotificationManager systemNotificationManager, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)systemNotificationManager, (String)"systemNotificationManager");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (IntercomLegacyPushClientHandlerKt.access$getNewPushNotificationEnabled()) {
                IntercomNotificationHandler.INSTANCE.clear(context);
            } else {
                systemNotificationManager.clear();
            }
        }

        public final void setUpNotificationChannels(@NotNull SystemNotificationManager systemNotificationManager, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)systemNotificationManager, (String)"systemNotificationManager");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (IntercomLegacyPushClientHandlerKt.access$getNewPushNotificationEnabled()) {
                IntercomNotificationHandler.INSTANCE.setUpNotificationChannels$intercom_sdk_base_release(context);
            } else {
                systemNotificationManager.setUpNotificationChannelsIfSupported(context);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

