/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.gson.annotations.SerializedName;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0003\b\u0081\b\u0018\u0000 &2\u00020\u0001:\u0001&B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000bH\u00c6\u0003JK\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010!\u001a\u00020\u00032\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\tH\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0016\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lio/intercom/android/sdk/models/AttachmentSettings;", "", "cameraEnabled", "", "mediaEnabled", "filesEnabled", "gifsEnabled", "trustedFileExtensions", "", "", "uploadSizeLimit", "", "<init>", "(ZZZZLjava/util/Set;J)V", "getCameraEnabled", "()Z", "getMediaEnabled", "getFilesEnabled", "getGifsEnabled", "getTrustedFileExtensions", "()Ljava/util/Set;", "getUploadSizeLimit", "()J", "uploadSizeLimitMB", "getUploadSizeLimitMB", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
public final class AttachmentSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @SerializedName(value="conversation_camera_enabled")
    private final boolean cameraEnabled;
    @SerializedName(value="conversation_media_enabled")
    private final boolean mediaEnabled;
    @SerializedName(value="conversation_files_enabled")
    private final boolean filesEnabled;
    @SerializedName(value="conversation_gifs_enabled")
    private final boolean gifsEnabled;
    @SerializedName(value="file_upload_extension_trusted_list")
    @NotNull
    private final Set<String> trustedFileExtensions;
    @SerializedName(value="upload_size_limit")
    private final long uploadSizeLimit;
    public static final int $stable = 8;
    private static final long DEFAULT_UPLOAD_SIZE_LIMIT = 0x6400000L;
    @NotNull
    private static final AttachmentSettings DEFAULT = new AttachmentSettings(true, true, true, true, SetsKt.emptySet(), 0x6400000L);

    public AttachmentSettings(boolean cameraEnabled, boolean mediaEnabled, boolean filesEnabled, boolean gifsEnabled, @NotNull Set<String> trustedFileExtensions, long uploadSizeLimit) {
        Intrinsics.checkNotNullParameter(trustedFileExtensions, (String)"trustedFileExtensions");
        this.cameraEnabled = cameraEnabled;
        this.mediaEnabled = mediaEnabled;
        this.filesEnabled = filesEnabled;
        this.gifsEnabled = gifsEnabled;
        this.trustedFileExtensions = trustedFileExtensions;
        this.uploadSizeLimit = uploadSizeLimit;
    }

    public final boolean getCameraEnabled() {
        return this.cameraEnabled;
    }

    public final boolean getMediaEnabled() {
        return this.mediaEnabled;
    }

    public final boolean getFilesEnabled() {
        return this.filesEnabled;
    }

    public final boolean getGifsEnabled() {
        return this.gifsEnabled;
    }

    @NotNull
    public final Set<String> getTrustedFileExtensions() {
        return this.trustedFileExtensions;
    }

    public final long getUploadSizeLimit() {
        return this.uploadSizeLimit;
    }

    @NotNull
    public final String getUploadSizeLimitMB() {
        return String.valueOf(this.uploadSizeLimit / (long)0x100000);
    }

    public final boolean component1() {
        return this.cameraEnabled;
    }

    public final boolean component2() {
        return this.mediaEnabled;
    }

    public final boolean component3() {
        return this.filesEnabled;
    }

    public final boolean component4() {
        return this.gifsEnabled;
    }

    @NotNull
    public final Set<String> component5() {
        return this.trustedFileExtensions;
    }

    public final long component6() {
        return this.uploadSizeLimit;
    }

    @NotNull
    public final AttachmentSettings copy(boolean cameraEnabled, boolean mediaEnabled, boolean filesEnabled, boolean gifsEnabled, @NotNull Set<String> trustedFileExtensions, long uploadSizeLimit) {
        Intrinsics.checkNotNullParameter(trustedFileExtensions, (String)"trustedFileExtensions");
        return new AttachmentSettings(cameraEnabled, mediaEnabled, filesEnabled, gifsEnabled, trustedFileExtensions, uploadSizeLimit);
    }

    public static /* synthetic */ AttachmentSettings copy$default(AttachmentSettings attachmentSettings, boolean bl, boolean bl2, boolean bl3, boolean bl4, Set set, long l, int n, Object object) {
        if ((n & 1) != 0) {
            bl = attachmentSettings.cameraEnabled;
        }
        if ((n & 2) != 0) {
            bl2 = attachmentSettings.mediaEnabled;
        }
        if ((n & 4) != 0) {
            bl3 = attachmentSettings.filesEnabled;
        }
        if ((n & 8) != 0) {
            bl4 = attachmentSettings.gifsEnabled;
        }
        if ((n & 0x10) != 0) {
            set = attachmentSettings.trustedFileExtensions;
        }
        if ((n & 0x20) != 0) {
            l = attachmentSettings.uploadSizeLimit;
        }
        return attachmentSettings.copy(bl, bl2, bl3, bl4, set, l);
    }

    @NotNull
    public String toString() {
        return "AttachmentSettings(cameraEnabled=" + this.cameraEnabled + ", mediaEnabled=" + this.mediaEnabled + ", filesEnabled=" + this.filesEnabled + ", gifsEnabled=" + this.gifsEnabled + ", trustedFileExtensions=" + this.trustedFileExtensions + ", uploadSizeLimit=" + this.uploadSizeLimit + ')';
    }

    public int hashCode() {
        int result2 = Boolean.hashCode(this.cameraEnabled);
        result2 = result2 * 31 + Boolean.hashCode(this.mediaEnabled);
        result2 = result2 * 31 + Boolean.hashCode(this.filesEnabled);
        result2 = result2 * 31 + Boolean.hashCode(this.gifsEnabled);
        result2 = result2 * 31 + ((Object)this.trustedFileExtensions).hashCode();
        result2 = result2 * 31 + Long.hashCode(this.uploadSizeLimit);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttachmentSettings)) {
            return false;
        }
        AttachmentSettings attachmentSettings = (AttachmentSettings)other;
        if (this.cameraEnabled != attachmentSettings.cameraEnabled) {
            return false;
        }
        if (this.mediaEnabled != attachmentSettings.mediaEnabled) {
            return false;
        }
        if (this.filesEnabled != attachmentSettings.filesEnabled) {
            return false;
        }
        if (this.gifsEnabled != attachmentSettings.gifsEnabled) {
            return false;
        }
        if (!Intrinsics.areEqual(this.trustedFileExtensions, attachmentSettings.trustedFileExtensions)) {
            return false;
        }
        return this.uploadSizeLimit == attachmentSettings.uploadSizeLimit;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/intercom/android/sdk/models/AttachmentSettings$Companion;", "", "<init>", "()V", "DEFAULT_UPLOAD_SIZE_LIMIT", "", "DEFAULT", "Lio/intercom/android/sdk/models/AttachmentSettings;", "getDEFAULT", "()Lio/intercom/android/sdk/models/AttachmentSettings;", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttachmentSettings getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

