/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.sentry;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.api.PlatformIdentifierUtilKt;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.sentry.SentrySessionManagerKt;
import io.sentry.Hint;
import io.sentry.IScope;
import io.sentry.IScopes;
import io.sentry.Integration;
import io.sentry.Scope;
import io.sentry.Scopes;
import io.sentry.SentryEvent;
import io.sentry.SentryOptions;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.protocol.Device;
import io.sentry.protocol.SentryException;
import io.sentry.protocol.SentryStackFrame;
import io.sentry.protocol.SentryStackTrace;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0019\u001a\u00020\u000f*\u00020\u001aH\u0002J\f\u0010\u001b\u001a\u00020\u000f*\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u0018*\u00020\u0018H\u0002J\f\u0010 \u001a\u00020\u001c*\u00020\u001cH\u0002J\f\u0010!\u001a\u00020\u0018*\u00020\u0018H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/intercom/android/sdk/sentry/SentrySessionManager;", "", "()V", "scope", "Lio/sentry/Scope;", "scopes", "Lio/sentry/Scopes;", "closeSentry", "", "getRedactedStacktrace", "", "Ljava/lang/StackTraceElement;", "stackTrace", "([Ljava/lang/StackTraceElement;)[Ljava/lang/StackTraceElement;", "isIntercomActivity", "", "activity", "Landroid/app/Activity;", "onActivityStarted", "onActivityStopped", "registerSentry", "context", "Landroid/content/Context;", "applyIntercomMetadata", "Lio/sentry/SentryEvent;", "isFromAllowedPackage", "", "isIntercomError", "", "redact", "Lio/sentry/protocol/SentryStackTrace;", "redactSentryExceptions", "redactStackTrace", "redactThrowable", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSentrySessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SentrySessionManager.kt\nio/intercom/android/sdk/sentry/SentrySessionManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,204:1\n12511#2,2:205\n12511#2,2:209\n37#3,2:207\n*S KotlinDebug\n*F\n+ 1 SentrySessionManager.kt\nio/intercom/android/sdk/sentry/SentrySessionManager\n*L\n82#1:205,2\n134#1:209,2\n108#1:207,2\n*E\n"})
public final class SentrySessionManager {
    @NotNull
    public static final SentrySessionManager INSTANCE = new SentrySessionManager();
    @Nullable
    private static Scope scope;
    @Nullable
    private static Scopes scopes;
    public static final int $stable;

    private SentrySessionManager() {
    }

    public final void registerSentry(@NotNull Context context) {
        SentryOptions sentryOptions;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (SentrySessionManagerKt.access$getNewSentrySetupDisabled()) {
            return;
        }
        SentryOptions $this$registerSentry_u24lambda_u241 = sentryOptions = new SentryOptions();
        boolean bl = false;
        $this$registerSentry_u24lambda_u241.setDsn("https://9c56b6fa301e50355ad7befce1458f0b@o2129.ingest.us.sentry.io/4508687817965568");
        $this$registerSentry_u24lambda_u241.setRelease("15.14.0");
        $this$registerSentry_u24lambda_u241.setEnableUncaughtExceptionHandler(true);
        $this$registerSentry_u24lambda_u241.setEnabled(true);
        $this$registerSentry_u24lambda_u241.setBeforeSend((arg_0, arg_1) -> SentrySessionManager.registerSentry$lambda$1$lambda$0(context, arg_0, arg_1));
        SentryOptions options = sentryOptions;
        Scope scope = new Scope(options);
        Scopes scopes = new Scopes((IScope)scope, (IScope)scope, (IScope)scope, "intercom");
        SentrySessionManager.scope = scope;
        SentrySessionManager.scopes = scopes;
        UncaughtExceptionHandlerIntegration integration = new UncaughtExceptionHandlerIntegration();
        options.addIntegration((Integration)integration);
        integration.register((IScopes)scopes, options);
    }

    public final void closeSentry() {
        block0: {
            Scopes scopes = SentrySessionManager.scopes;
            if (scopes == null) break block0;
            scopes.close();
        }
    }

    public final void onActivityStarted(@NotNull Activity activity) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            if (!this.isIntercomActivity(activity)) break block1;
            Scopes scopes = SentrySessionManager.scopes;
            if (scopes != null) {
                scopes.startSession();
            }
        }
    }

    public final void onActivityStopped(@NotNull Activity activity) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            if (!this.isIntercomActivity(activity)) break block1;
            Scopes scopes = SentrySessionManager.scopes;
            if (scopes != null) {
                scopes.endSession();
            }
        }
    }

    private final boolean isIntercomActivity(Activity activity) {
        String string2 = activity.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = string2;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        return StringsKt.contains$default((CharSequence)string4, (CharSequence)"intercom", (boolean)false, (int)2, null);
    }

    private final boolean isIntercomError(Throwable $this$isIntercomError) {
        boolean bl;
        block1: {
            StackTraceElement[] stackTraceElementArray = $this$isIntercomError.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            Object[] $this$any$iv = stackTraceElementArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                StackTraceElement it = (StackTraceElement)element$iv;
                boolean bl2 = false;
                String string2 = it.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClassName(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)"io.intercom.android.sdk", (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final Throwable redactStackTrace(Throwable $this$redactStackTrace) {
        Throwable throwable;
        StackTraceElement[] stackTraceElementArray = $this$redactStackTrace.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
        StackTraceElement[] redactedStackTrace = this.getRedactedStacktrace(stackTraceElementArray);
        Throwable $this$redactStackTrace_u24lambda_u243 = throwable = $this$redactStackTrace;
        boolean bl = false;
        $this$redactStackTrace_u24lambda_u243.setStackTrace(redactedStackTrace);
        return throwable;
    }

    private final StackTraceElement[] getRedactedStacktrace(StackTraceElement[] stackTrace) {
        List list;
        List $this$getRedactedStacktrace_u24lambda_u244 = list = CollectionsKt.createListBuilder((int)stackTrace.length);
        boolean bl = false;
        for (StackTraceElement stackTraceElement : stackTrace) {
            String string2 = stackTraceElement.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClassName(...)");
            if (INSTANCE.isFromAllowedPackage(string2)) {
                $this$getRedactedStacktrace_u24lambda_u244.add(stackTraceElement);
                continue;
            }
            StackTraceElement redactedStackTraceElement = new StackTraceElement("[Non Intercom/OS method]", "[Non Intercom/OS method]", "[Non Intercom/OS method]", stackTraceElement.getLineNumber());
            $this$getRedactedStacktrace_u24lambda_u244.add(redactedStackTraceElement);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.build((List)list);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new StackTraceElement[0]);
    }

    private final SentryStackTrace redact(SentryStackTrace $this$redact) {
        SentryStackTrace sentryStackTrace;
        List list;
        List list2 = $this$redact.getFrames();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List frames = list2;
        List $this$redact_u24lambda_u246 = list = CollectionsKt.createListBuilder((int)frames.size());
        boolean bl = false;
        for (SentryStackFrame frame : frames) {
            SentryStackFrame sentryStackFrame;
            boolean bl2;
            String string2;
            String string3 = string2 = frame.getModule();
            if (string3 != null) {
                Intrinsics.checkNotNull((Object)string3);
                bl2 = INSTANCE.isFromAllowedPackage(string2);
            } else {
                bl2 = false;
            }
            if (bl2) {
                $this$redact_u24lambda_u246.add(frame);
                continue;
            }
            SentryStackFrame $this$redact_u24lambda_u246_u24lambda_u245 = sentryStackFrame = frame;
            boolean bl3 = false;
            $this$redact_u24lambda_u246_u24lambda_u245.setFilename("[Non Intercom/OS method]");
            $this$redact_u24lambda_u246_u24lambda_u245.setFunction("[Non Intercom/OS method]");
            $this$redact_u24lambda_u246_u24lambda_u245.setModule("[Non Intercom/OS method]");
            SentryStackFrame redactedFrame = sentryStackFrame;
            $this$redact_u24lambda_u246.add(redactedFrame);
        }
        List redactedFrames = CollectionsKt.build((List)list);
        SentryStackTrace $this$redact_u24lambda_u247 = sentryStackTrace = $this$redact;
        boolean bl4 = false;
        $this$redact_u24lambda_u247.setFrames(redactedFrames);
        return sentryStackTrace;
    }

    private final boolean isFromAllowedPackage(String $this$isFromAllowedPackage) {
        boolean bl;
        block1: {
            String[] $this$any$iv = SentrySessionManagerKt.access$getALLOWED_PACKAGES$p();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)$this$isFromAllowedPackage, (String)it, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final SentryEvent redactThrowable(SentryEvent $this$redactThrowable) {
        SentryEvent sentryEvent;
        Throwable throwable = $this$redactThrowable.getThrowable();
        Throwable redactedThrowable = throwable != null ? this.redactStackTrace(throwable) : null;
        SentryEvent $this$redactThrowable_u24lambda_u249 = sentryEvent = $this$redactThrowable;
        boolean bl = false;
        $this$redactThrowable_u24lambda_u249.setThrowable(redactedThrowable);
        return sentryEvent;
    }

    private final SentryEvent redactSentryExceptions(SentryEvent $this$redactSentryExceptions) {
        SentryEvent sentryEvent;
        List list;
        List list2 = $this$redactSentryExceptions.getExceptions();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List exceptions = list2;
        List $this$redactSentryExceptions_u24lambda_u2411 = list = CollectionsKt.createListBuilder((int)exceptions.size());
        boolean bl = false;
        for (SentryException exception : exceptions) {
            SentryStackTrace sentryStackTrace;
            SentryStackTrace sentryStackTrace2;
            SentryStackTrace sentryStackTrace3 = sentryStackTrace2 = exception.getStacktrace();
            if (sentryStackTrace3 != null) {
                Intrinsics.checkNotNull((Object)sentryStackTrace3);
                sentryStackTrace = INSTANCE.redact(sentryStackTrace2);
            } else {
                sentryStackTrace = null;
            }
            SentryStackTrace redactedSentryStackTrace = sentryStackTrace;
            SentryStackTrace $this$redactSentryExceptions_u24lambda_u2411_u24lambda_u2410 = sentryStackTrace2 = exception;
            boolean bl2 = false;
            $this$redactSentryExceptions_u24lambda_u2411_u24lambda_u2410.setStacktrace(redactedSentryStackTrace);
            $this$redactSentryExceptions_u24lambda_u2411.add(exception);
        }
        List redactedExceptions = CollectionsKt.build((List)list);
        SentryEvent $this$redactSentryExceptions_u24lambda_u2412 = sentryEvent = $this$redactSentryExceptions;
        boolean bl3 = false;
        $this$redactSentryExceptions_u24lambda_u2412.setExceptions(redactedExceptions);
        return sentryEvent;
    }

    private final SentryEvent applyIntercomMetadata(SentryEvent $this$applyIntercomMetadata, Context context) {
        SentryEvent sentryEvent;
        Device device;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"device", (Object)Build.MODEL), TuplesKt.to((Object)"os", (Object)("Android " + Build.VERSION.RELEASE))};
        Map baseTags = MapsKt.mapOf((Pair[])pairArray);
        Device $this$applyIntercomMetadata_u24lambda_u2413 = device = new Device();
        boolean bl = false;
        $this$applyIntercomMetadata_u24lambda_u2413.setModel(Build.MODEL);
        $this$applyIntercomMetadata_u24lambda_u2413.setBrand(Build.BRAND);
        $this$applyIntercomMetadata_u24lambda_u2413.setLocale(Locale.getDefault().toString());
        Device device2 = device;
        if (Injector.isNotInitialised()) {
            Device $this$applyIntercomMetadata_u24lambda_u2414 = device = $this$applyIntercomMetadata;
            boolean bl2 = false;
            $this$applyIntercomMetadata_u24lambda_u2414.setTags(baseTags);
            $this$applyIntercomMetadata_u24lambda_u2414.getContexts().setDevice(device2);
            return device;
        }
        AppIdentity appIdentity = Injector.get().getAppIdentity();
        AppConfig config = Injector.get().getAppConfigProvider().get();
        SentryEvent $this$applyIntercomMetadata_u24lambda_u2415 = sentryEvent = $this$applyIntercomMetadata;
        boolean bl3 = false;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"app_id", (Object)appIdentity.appId()), TuplesKt.to((Object)"customer_name", (Object)config.getName()), TuplesKt.to((Object)"package_name", (Object)context.getPackageName()), TuplesKt.to((Object)"sdk_type", (Object)PlatformIdentifierUtilKt.getPlatformIdentifier(context))};
        $this$applyIntercomMetadata_u24lambda_u2415.setTags(MapsKt.plus((Map)baseTags, (Map)MapsKt.mapOf((Pair[])pairArray2)));
        $this$applyIntercomMetadata_u24lambda_u2415.getContexts().setDevice(device2);
        return sentryEvent;
    }

    private static final SentryEvent registerSentry$lambda$1$lambda$0(Context $context, SentryEvent event, Hint hint) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"<anonymous parameter 1>");
        Throwable throwable2 = throwable = event.getThrowable();
        boolean bl = throwable2 != null ? INSTANCE.isIntercomError(throwable2) : false;
        if (bl) {
            SentryEvent intercomEvent = INSTANCE.applyIntercomMetadata(INSTANCE.redactSentryExceptions(INSTANCE.redactThrowable(event)), $context);
            return intercomEvent;
        }
        return null;
    }

    static {
        $stable = 8;
    }
}

