/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.commons.TimeProvider;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class TimeFormatter {
    private final Context context;
    private final TimeProvider timeProvider;
    private SimpleDateFormat absoluteDateFormatter;
    private SimpleDateFormat absoluteTimeFormatter;

    public TimeFormatter(Context context, TimeProvider timeProvider) {
        this.context = context;
        this.timeProvider = timeProvider;
    }

    public CharSequence getAdminActiveStatus(LastParticipatingAdmin admin, Provider<AppConfig> appConfigProvider2) {
        if (this.shouldShowActiveOrAwayState(appConfigProvider2.get().getLocale())) {
            return admin.isActive() ? this.context.getString(R.string.intercom_active_state) : this.context.getString(R.string.intercom_away_state);
        }
        if (admin.getLastActiveAt() <= 0L) {
            return "";
        }
        return this.getAdminActiveStatus(this.getDateFromTimeStamp(admin.getLastActiveAt()));
    }

    private CharSequence getAdminActiveStatus(Date date) {
        long diffInMin = this.getDifferenceInMinutes(date);
        if (diffInMin > TimeUnit.DAYS.toMinutes(6L)) {
            return this.context.getText(R.string.intercom_active_week_ago);
        }
        Phrase displayDate = diffInMin >= TimeUnit.HOURS.toMinutes(23L) + 31L ? Phrase.from(this.context, R.string.intercom_active_day_ago).put("days", Long.toString(1L + (diffInMin / 60L - 13L) / 24L)) : (diffInMin >= 53L ? Phrase.from(this.context, R.string.intercom_active_hour_ago).put("hours", Long.toString(1L + (diffInMin - 31L) / 60L)) : (diffInMin >= 38L ? Phrase.from(this.context, R.string.intercom_active_minute_ago).put("minutes", Long.toString(45L)) : (diffInMin >= 16L ? Phrase.from(this.context, R.string.intercom_active_minute_ago).put("minutes", Long.toString(30L)) : Phrase.from(this.context, R.string.intercom_active_15m_ago).put("minutes", Long.toString(15L)))));
        return displayDate.format();
    }

    @VisibleForTesting
    boolean shouldShowActiveOrAwayState(String locale) {
        return locale.equals("en");
    }

    private long getDifferenceInMinutes(Date date) {
        return TimeUnit.MILLISECONDS.toMinutes(this.timeProvider.currentTimeMillis() - date.getTime());
    }

    private Date getDateFromTimeStamp(long time) {
        return new Date(time * 1000L);
    }

    public static String formatTimeInMillisAsDate(long timeInMillis, String pattern) {
        Date date = new Date(timeInMillis);
        return new SimpleDateFormat(pattern, Locale.getDefault()).format(date);
    }

    public static String formatTimeForTickets(long timeInMillis, Context context) {
        Phrase displayDate;
        Date date = new Date(timeInMillis * 1000L);
        long diffInMin = TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - date.getTime());
        long diffInHours = TimeUnit.MILLISECONDS.toHours(System.currentTimeMillis() - date.getTime());
        long diffInDays = TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis() - date.getTime());
        long diffInWeeks = diffInDays / 7L;
        if (diffInWeeks > 0L) {
            displayDate = Phrase.from(context, R.string.intercom_time_week_ago).put("delta", Long.toString(diffInWeeks));
        } else if (diffInDays > 0L) {
            displayDate = Phrase.from(context, R.string.intercom_time_day_ago).put("delta", Long.toString(diffInDays));
        } else if (diffInHours > 0L) {
            displayDate = Phrase.from(context, R.string.intercom_time_hour_ago).put("delta", Long.toString(diffInHours));
        } else if (diffInMin >= 1L) {
            displayDate = Phrase.from(context, R.string.intercom_time_minute_ago).put("delta", Long.toString(diffInMin));
        } else {
            return context.getString(R.string.intercom_time_just_now);
        }
        return displayDate.format().toString();
    }

    public static String formatToUtcTime(int hour, int min) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, hour);
        calendar.set(12, min);
        Date date = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm", Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    public static String formatFromUtcTime(int hour, int min) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.set(11, hour);
        calendar.set(12, min);
        Date date = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm", Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(date);
    }

    public static int getHour(long timeInMillis) {
        Date date = new Date(timeInMillis);
        return date.getHours();
    }

    public static int getMinute(long timeInMillis) {
        Date date = new Date(timeInMillis);
        return date.getMinutes();
    }
}

