/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.actions;

public final class Action<V> {
    private final Type type;
    private final V value;

    Action(Type type2, V value2) {
        this.type = type2;
        this.value = value2;
    }

    public Type type() {
        return this.type;
    }

    public V value() {
        return this.value;
    }

    public String toString() {
        return this.type.toString() + ": " + this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action = (Action)o;
        if (this.type != action.type) {
            return false;
        }
        return this.value.equals(action.value);
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = 31 * result2 + this.value.hashCode();
        return result2;
    }

    public static enum Type {
        ACTIVITY_PAUSED,
        ACTIVITY_READY_FOR_VIEW_ATTACHMENT,
        ACTIVITY_STOPPED,
        APP_ENTERED_BACKGROUND,
        APP_ENTERED_FOREGROUND,
        BASE_RESPONSE_RECEIVED,
        CONVERSATION_MARKED_AS_DISMISSED,
        CONVERSATION_MARKED_AS_READ,
        FETCH_CONVERSATION_SUCCESS,
        HARD_RESET,
        NEW_COMMENT_EVENT_RECEIVED,
        SESSION_STARTED,
        SET_LAUNCHER_VISIBILITY,
        SET_IN_APP_NOTIFICATION_VISIBILITY,
        SET_BOTTOM_PADDING,
        SOFT_RESET,
        UNREAD_CONVERSATIONS_SUCCESS,
        CAROUSEL_DISMISSED,
        OPEN_PROGRAMMATIC_CAROUSEL,
        PROGRAMMATIC_CAROUSEL_LOADING,
        PROGRAMMATIC_CAROUSEL_SUCCESS,
        PROGRAMMATIC_CAROUSEL_ERROR;

    }
}

